/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import io.axoniq.axonserver.util.StreamObserverUtils;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private final Logger e = LoggerFactory.getLogger(ClusterUpdatesService.class);
    private static final Logger C = AuditLog.getLogger();
    private final Sinks.Many<SimpleUpdate> g = Sinks.many().multicast().onBackpressureBuffer();

    private static /* synthetic */ void L(Authentication a2) {
        C.info(StreamObserverUtils.L((Object)"I^ox2vgGaF`Lp@v\u0005fJ2F}Kf@jQ2PbAsQwV<"), (Object)AuditLog.username((String)a2.username()));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected axonServerInstanceDisconnected) {
        ClusterUpdatesService a2 = axonServerInstanceDisconnected;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.a, a2.getNodeName(), SimpleUpdateState.e);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        ClusterUpdatesService a2 = applicationDisconnected;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.A, a2.A(), SimpleUpdateState.e);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin contextUnregisteredInAdmin) {
        ClusterUpdatesService a2 = contextUnregisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.i, a2.context(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ClusterUpdatesService a2 = becomeLeader;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.M, a2.replicationGroup(), SimpleUpdateState.g);
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin contextUpdatedInAdmin) {
        ClusterUpdatesService a2 = contextUpdatedInAdmin;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.i, a2.L(), SimpleUpdateState.g);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(UpdateType updateType, String string, SimpleUpdateState simpleUpdateState) {
        void a2;
        void a3;
        ClusterUpdatesService a4 = simpleUpdateState;
        ClusterUpdatesService a5 = this;
        a5.g.emitNext((Object)new SimpleUpdate((UpdateType)a3, (String)a2 + ":" + a4.name()), (signalType, emitResult) -> {
            SignalType a2 = emitResult;
            SignalType a3 = signalType;
            if (a2 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown leaderStepDown) {
        ClusterUpdatesService a2 = leaderStepDown;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.M, a2.replicationGroup(), SimpleUpdateState.g);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        ClusterUpdatesService a2 = replicationGroupUpdated;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.I, a2.replicationGroup(), SimpleUpdateState.g);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin contextRegisteredInAdmin) {
        ClusterUpdatesService a2 = contextRegisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.i, a2.context(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected axonServerInstanceConnected) {
        ClusterUpdatesService a2 = axonServerInstanceConnected;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.a, a2.getNodeName(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated replicationGroupCreated) {
        ClusterUpdatesService a2 = replicationGroupCreated;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.I, a2.replicationGroup(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        ClusterUpdatesService a2 = replicationGroupDeleted;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.I, a2.replicationGroup(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted axonServerNodeDeleted) {
        ClusterUpdatesService a2 = axonServerNodeDeleted;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.C, a2.node(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ClusterUpdatesService a2 = leaderConfirmation;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.M, a2.replicationGroup(), SimpleUpdateState.g);
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication authentication) {
        ClusterUpdatesService clusterUpdatesService = clusterUpdatesService2;
        ClusterUpdatesService clusterUpdatesService2 = authentication;
        ClusterUpdatesService a2 = clusterUpdatesService;
        return a2.g.asFlux().publish().autoConnect().doFirst(() -> ClusterUpdatesService.L((Authentication)clusterUpdatesService2));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected axonServerNodeConnected) {
        ClusterUpdatesService a2 = axonServerNodeConnected;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.C, a2.getNodeInfo().getHostName(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        ClusterUpdatesService a2 = applicationConnected;
        ClusterUpdatesService a3 = this;
        a3.L(UpdateType.A, a2.I(), SimpleUpdateState.C);
    }
}

