/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.cluster.replication.file;

import io.axoniq.axonserver.cluster.exception.IteratorClosedException;
import io.axoniq.axonserver.cluster.rules.PrimaryMajorityAndActiveBackupsRule;
import java.io.File;
import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties {
    private long numberOfSegments;
    private String logSuffix;
    private int syncInterval;
    private int segmentSize;
    protected Boolean useMmapIndex;
    protected Boolean forceCleanMmapIndex;
    private String indexSuffix;
    private Long minFreeSpace;
    private String logStorageFolder;
    private int flags;
    private int forceInterval;
    private static final String FILENAME_PATTERN = "%s" + File.separator + "%020d%s";
    private int validationSegments;
    private long secondaryCleanupDelay;
    private Long warnFreeSpace;
    private int minActiveBackups;
    private int primaryCleanupDelay;
    private int maxIndexesInMemory;
    private static final boolean WINDOWS = System.getProperty(PrimaryMajorityAndActiveBackupsRule.e((Object)"W`\u0016}Y~]"), IteratorClosedException.e((Object)"\u0014i.U?r")).toLowerCase().startsWith(PrimaryMajorityAndActiveBackupsRule.e((Object)"OzV"));

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public void setSyncInterval(Duration duration) {
        Duration a2 = duration;
        StorageProperties a3 = this;
        a3.syncInterval = (int)a2.toMillis();
    }

    public StorageProperties() {
        StorageProperties a2;
        StorageProperties storageProperties = a2;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        storageProperties7.forceCleanMmapIndex = true;
        storageProperties7.syncInterval = 1000;
        storageProperties6.forceInterval = 1000;
        storageProperties6.logSuffix = ".log";
        storageProperties5.indexSuffix = ".index";
        storageProperties5.validationSegments = 2;
        storageProperties4.flags = 0;
        storageProperties4.primaryCleanupDelay = 5;
        storageProperties3.segmentSize = 0x1000000;
        storageProperties3.numberOfSegments = 1000L;
        storageProperties2.secondaryCleanupDelay = 30L;
        storageProperties2.logStorageFolder = "log";
        storageProperties.minActiveBackups = 1;
        storageProperties.maxIndexesInMemory = 5;
    }

    public long getNumberOfSegments() {
        StorageProperties a2;
        return a2.numberOfSegments;
    }

    public void setLogSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.logSuffix = a2;
    }

    public void setNumberOfSegments(long a2) {
        a.numberOfSegments = a2;
    }

    public void setForceInterval(Duration duration) {
        Duration a2 = duration;
        StorageProperties a3 = this;
        a3.forceInterval = (int)a2.toMillis();
    }

    public void setValidationSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.validationSegments = a2;
    }

    public void setSecondaryCleanupDelay(long a2) {
        a.secondaryCleanupDelay = a2;
    }

    public long warnFreeSpace() {
        StorageProperties a2;
        if (a2.warnFreeSpace == null) {
            return (long)((double)a2.minFreeSpace() * 1.25);
        }
        return a2.warnFreeSpace;
    }

    public long getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    public String getLogSuffix() {
        StorageProperties a2;
        return a2.logSuffix;
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        if (a2.useMmapIndex != null) {
            return a2.useMmapIndex;
        }
        return false;
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.warnFreeSpace = a2 == null ? null : Long.valueOf(a2.toBytes());
    }

    public String getStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        return a3.logStorageFolder + File.separator + (String)a2;
    }

    public long minFreeSpace() {
        StorageProperties a2;
        if (a2.minFreeSpace == null) {
            return 5L * (long)a2.segmentSize;
        }
        return a2.minFreeSpace;
    }

    public String getLogStorageFolder() {
        StorageProperties a2;
        return a2.logStorageFolder;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public void setUseMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.useMmapIndex = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File logFile(String string, Long l2) {
        void a2;
        Object a3 = l2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.logSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setPrimaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.primaryCleanupDelay = a2;
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.minFreeSpace = a2 == null ? null : Long.valueOf(a2.toBytes());
    }

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)PrimaryMajorityAndActiveBackupsRule.e((Object)"kv_~]}L3KzBv\u0018~M`L3Zv\u0018\u007f]`K3L{Y}\u0018!\t'\u000f'\u0000 \u000e'\u000f"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)IteratorClosedException.e((Object)"\tc=k?h.&)o czk/u.&8czk5t?&.n;hz6"));
        a3.segmentSize = (int)a2.toBytes();
    }

    public int getMinActiveBackups() {
        StorageProperties a2;
        return a2.minActiveBackups;
    }

    /*
     * WARNING - void declaration
     */
    public File indexTempFile(String string, Long l2) {
        void a2;
        Object a3 = l2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix + ".temp";
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    public void setLogStorageFolder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.logStorageFolder = a2;
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceCleanMmapIndex = a2;
    }

    public void setIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexSuffix = a2;
    }

    public void setFlags(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.flags = a2;
    }

    public void setMinActiveBackups(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.minActiveBackups = a2;
    }

    public void setMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxIndexesInMemory = a2;
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public File indexFile(String string, Long l2) {
        void a2;
        Object a3 = l2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return WINDOWS;
    }

    public int getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public long getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }
}

