/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.admin.application.api.EventProcessorInfo;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final NodeSelector k;
    private final ClientTagsCache c;
    private final PlatformService j;
    private final NavigableSet<PlatformService.ClientComponent> D;
    private final boolean M;
    private final Logger f;

    @EventListener
    public void on(ReadyForConnections readyForConnections) {
        AutoRebalancing a2 = readyForConnections;
        AutoRebalancing a3 = this;
        if (a2.ready()) {
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.D.clear();
            autoRebalancing.D.addAll(a3.j.getConnectedClients());
        }
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        AutoRebalancing a2;
        AutoRebalancing a3 = applicationDisconnected;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.f.debug(EventProcessorInfo.e((Object)"2\u0012\u0003\u000e\u001a\u0001\u0012\u0016\u001a\r\u001dB7\u000b\u0000\u0001\u001c\f\u001d\u0007\u0010\u0016\u0016\u0006IB\b\u001f"), (Object)a3.c());
        a3 = new PlatformService.ClientComponent(a3.c(), a3.j(), a3.F(), a3.E());
        autoRebalancing.D.remove(a3);
        a2.f.debug(EventProcessorInfo.e((Object)"5\u001b\u000b\u0007\u0007\u001f\u000b\u0000\u0016IB\b\u001f"), (Object)a2.D);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged axonServerNodeHealthChanged) {
        AutoRebalancing a2;
        AutoRebalancing a3 = axonServerNodeHealthChanged;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.f.debug(EventProcessorInfo.e((Object)"!\u0007\u0010\u0007\u001a\u0014\u0016\u0006S\n\u0016\u0003\u001f\u0016\u001bB\u0010\n\u0012\f\u0014\u0007\u0017B\u0015\r\u0001B\b\u001f"), (Object)a3.getNode());
        autoRebalancing.D.clear();
        autoRebalancing.D.addAll(a2.j.getConnectedClients());
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void e() {
        boolean bl;
        AutoRebalancing autoRebalancing = this;
        if (!autoRebalancing.M) {
            return;
        }
        autoRebalancing.f.debug(EventProcessorInfo.e((Object)"0\u0016\u0000\u0012\u000e\u0012\f\u0010\u0007IB\b\u001f"), (Object)autoRebalancing.D);
        boolean bl2 = false;
        do {
            AutoRebalancing a2;
            if ((a2 = (PlatformService.ClientComponent)autoRebalancing.D.pollFirst()) != null && autoRebalancing.k.canRebalance(a2.getClientId(), a2.getComponent(), a2.getContext(), autoRebalancing.e(a2.getContext(), a2.getClientStreamId()))) {
                bl = bl2;
                autoRebalancing.e((PlatformService.ClientComponent)a2);
                continue;
            }
            bl = bl2 = a2 != null;
        } while (bl);
    }

    /*
     * WARNING - void declaration
     */
    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientTagsCache, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean bl) {
        void nodeSelector2;
        void clientsTags;
        void platformService2;
        AutoRebalancing a2;
        boolean bl2 = bl;
        AutoRebalancing autoRebalancing = a2 = this;
        AutoRebalancing autoRebalancing2 = a2;
        a2.f = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = a2;
        a2.D = new ConcurrentSkipListSet();
        autoRebalancing2.j = platformService2;
        autoRebalancing2.c = clientsTags;
        autoRebalancing.k = nodeSelector2;
        autoRebalancing.M = this;
    }

    private /* synthetic */ Map<String, String> e(String string, String string2) {
        Object a2 = string2;
        AutoRebalancing a3 = this;
        return a3.c.apply((String)a2);
    }

    private /* synthetic */ void e(PlatformService.ClientComponent clientComponent) {
        AutoRebalancing a2;
        AutoRebalancing a3 = clientComponent;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.f.info(EventProcessorInfo.e((Object)"0\u0016\u0013\u0006\u0007\u0000\u0016\u001a\f\u0014B\u0001\u0007\u0010\r\u001d\f\u0016\u0001\u0007B\u0015\r\u0001B\b\u001f"), (Object)a3.getClientStreamId());
        autoRebalancing.j.requestReconnect((PlatformService.ClientComponent)a3, EventProcessorInfo.e((Object)"\u0010\u0016\u0001\u001c\f\u001d\u0007\u0010\u0016S\u0010\u0016\u0013\u0006\u0007\u0000\u0016\u0016\u0006S\u0000\nB\u0012\u0017\u0007\rS\u0000\u0012\u000e\u0012\f\u0010\u000b\u001d\u0005"));
    }
}

