/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.admin.application.api.SegmentStatus;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.rest.ReplicationGroupJSON;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final AdminNodes A;
    private final MessagingPlatformConfiguration L;
    private final AdminConfigurationFactory l;
    private final Logger C;
    private volatile boolean k;
    private final RemoteConnections c;
    private final Limits j;
    private final ClusterTagsCache D;
    private final ApplicationEventPublisher M;
    private final CurrentNodeProvider f;

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.A.deleteAllByNameNot(clusterController.getName());
        clusterController.c.sync();
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.e();
        a2.k = true;
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.L.getName()) || a3.c.get(a2) != null && a3.c.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.C = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.L = messagingPlatformConfiguration2;
        clusterController6.A = clusterNodeRepository;
        clusterController5.l = adminConfigurationFactory2;
        clusterController5.D = clusterTagsCache2;
        clusterController4.M = applicationEventPublisher2;
        clusterController4.j = limits2;
        clusterController3.c = remoteConnections2;
        clusterController3.f = clusterController2;
    }

    public ClusterNode getNode(String string) {
        String a2 = string;
        Object a3 = this;
        if (a2.equals(a3.getName())) {
            return a3.getMe();
        }
        ClusterController clusterController = a3;
        return clusterController.e(clusterController.A.findById(a2).orElseGet(() -> {
            Object a2 = a2;
            ClusterController a3 = this;
            if ((a2 = a3.c.get((String)a2)) == null) {
                return null;
            }
            return a2.getClusterNode();
        }));
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.e((ClusterNode)clusterController.f.get());
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.C.info(ReplicationGroupJSON.e((Object)"E)m)u)!\"n(dv!7|"), a3);
        clusterController2.M.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.L.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.A.deleteAllByNameNot((String)a3);
            clusterController3.c.closeAll();
        } else {
            a2.A.findById((String)a3).ifPresent(arg_0 -> a2.e((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.M.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.c.sync();
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.k;
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.c.nodes();
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.e((NodeInfo)a3);
        clusterController.c.updateNodeInfo((NodeInfo)a3);
        clusterController.M.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.c.connections();
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.c.activeConnections();
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.e(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.L.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.C.info(SegmentStatus.e((Object)"3`\u001e{\tuGf\b2\r}\u000e|Ge\u000ef\u000f2\u0004g\u0015`\u0002|\u00132\t}\u0003wG|\u0006\u007f\u0002(Gi\u001a"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.L.getInternalHostname()) && a2.getGrpcInternalPort() == a3.L.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, ReplicationGroupJSON.e((Object)"\u000f`\"o#ulk#h\"!/m9r8d>!;h8ilr-l)!$n?u\"`!dl`\"elh\"u)s\"` !<n>u"));
        }
        ClusterNode clusterNode = a3.A.findById(a2.getNodeName()).orElseGet(() -> a3.e((NodeInfo)a2));
        if (!a3.c.contains(a2.getNodeName())) {
            a3.e((NodeInfo)a2);
        }
        return clusterNode;
    }

    public void stop() {
        a.k = false;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.M.publishEvent(a2);
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.A.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.D.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    private /* synthetic */ void e(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.L.getName())) {
            return;
        }
        a3.c.connect((NodeInfo)a2, true);
    }

    private /* synthetic */ ClusterNode e(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.C.info(SegmentStatus.e((Object)"&v\u00032\t}\u0003wGi\u001a"), (Object)a3);
        a3 = clusterController.l.clusterNode((NodeInfo)a3);
        return clusterController.A.save((ClusterNode)a3);
    }

    private /* synthetic */ void e() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.A.findById(clusterController2.L.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.A.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.L.getName();
                a2 = String.format(SegmentStatus.e((Object)"Q\u0012`\u0015w\tfG|\bv\u00022\ts\nwGz\u0006aGq\u000fs\tu\u0002vK2\tw\u00102\ts\nwG7\u0014<GA\u0013s\u0015fGS\u001f}\tA\u0002`\u0011w\u00152\u0010{\u0013zG`\u0002q\bd\u0002`\u001e2\u0001{\u000bwI"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.l.clusterNode(clusterController3.L.getName(), clusterController.L.getFullyQualifiedHostname(), clusterController.L.getFullyQualifiedInternalHostname(), clusterController.L.getPort(), clusterController.L.getInternalPort(), clusterController.L.getHttpPort());
            clusterController3.A.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.L.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.L.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.L.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.L.getInternalPort();
            object = String.format(ReplicationGroupJSON.e((Object)"\u000ft>s)o8!\"n(dkrlh\"u)s\"` !$n?u\"`!dcq#s8!d$?;iee!$`?!/i-o+d(-l!\"d;!:` t)rl$?;ieb!\u001fu-s8!\ry#o\u001fd>w)slv%u$!>d/n:d>xlg%m)/"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    public int getPhase() {
        return 50;
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.c.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.c.disconnect((String)a2);
    }

    private /* synthetic */ void e(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.A.deleteById((String)a2);
    }

    private /* synthetic */ void e(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.c.contains((String)a2) || a3.L.getName().equals(a2)) {
            return;
        }
        a3.j.getMaxClusterSize().ifPresent(arg_0 -> a3.e((String)a2, arg_0));
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.c.get((String)a2));
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.f.isAdmin();
    }
}

