/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.rest.ReplicationGroupJSON;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final MessagingPlatformConfiguration K;
    private final ApplicationEventPublisher B;
    private Server A;
    private final LogReplicationService L;
    private final Supplier<ScheduledExecutorService> l;
    private final ExecutorService C;
    private boolean k;
    private final LeaderElectionService c;
    private final List<AxonServerInternalService> j;
    private static final DataSize D = DataSize.ofMegabytes((long)32L);
    private AdvancedTlsX509KeyManager.Closeable M;
    private final Logger f;

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.M != null) {
            messagingClusterServer.M.close();
        }
        messagingClusterServer.C.shutdown();
        try {
            if (!messagingClusterServer.A.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.f.debug(ReplicationGroupJSON.e((Object)"\nn>b)g9m xlr8n<q%o+!\u000fm9r8d>!\u001fd>w)s"));
                messagingClusterServer2.A.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.f.debug(MessageJson.e((Object)"}\u000e@\u0005F\u0012A\u0010@\u0005P@P\u0015F\tZ\u0007\u0014\u0013\\\u0015@\u0004[\u0017Z@[\u0006\u0014\tZ\u0014Q\u0012Z\u0001X@u\u0018[\u000eg\u0005F\u0016Q\u0012"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.k = false;
        messagingClusterServer.f.info(ReplicationGroupJSON.e((Object)"\ry#olR)s:d>!\u000fm9r8d>!\u001fd>w)slr8n<q)e"));
    }

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.f = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.K = a8;
        messagingClusterServer3.L = a6;
        messagingClusterServer3.c = a5;
        messagingClusterServer2.j = a4;
        messagingClusterServer2.l = a3;
        messagingClusterServer.B = a2;
        messagingClusterServer.C = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(MessageJson.e((Object)"\u0003X\u0015G\u0014Q\u0012\u0019\u0005L\u0005W\u0015@\u000fFM")));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.k;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = MessageJson.e((Object)"Z\u000f\u00143g,");
            if (messagingClusterServer.K.getSsl() != null && messagingClusterServer.K.getSsl().isEnabled()) {
                Object object = messagingClusterServer.K.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(ReplicationGroupJSON.e((Object)"`4n\"h=/-y#o?d>w)sbr?mbb)s8,/i-h\",*h dlo#ulr)u"));
                }
                Object object2 = messagingClusterServer.K.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(MessageJson.e((Object)"U\u0018[\u000e]\u0011\u001a\u0001L\u000fZ\u0013Q\u0012B\u0005FNG\u0013XND\u0012]\u0016U\u0014QM_\u0005MMR\tX\u0005\u0014\u000e[\u0014\u0014\u0013Q\u0014"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.M = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.l.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.K.getInternalPort(), (ServerCredentials)object);
                string = ReplicationGroupJSON.e((Object)"R\u001fMld\"`.m)e");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.K.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.K.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(D.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.K.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.K));
            messagingClusterServer.j.forEach(arg_0 -> MessagingClusterServer.e((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.c);
            a2.addService((BindableService)messagingClusterServer2.L);
            if (messagingClusterServer2.K.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.K.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.K.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.K.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.C);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(MessageJson.e((Object)"\u0003X\u0015G\u0014Q\u0012\u0019\u0002[\u0013GM"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ReplicationGroupJSON.e((Object)"b t?u)sav#s'd>,"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(MessageJson.e((Object)"\u0003X\u0015G\u0014Q\u0012\u0019\u0002[\u0013GM"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ReplicationGroupJSON.e((Object)"b t?u)sav#s'd>,"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.A = a2.build();
            messagingClusterServer.A.start();
            messagingClusterServer.f.info(MessageJson.e((Object)"!L\u000fZ@g\u0005F\u0016Q\u0012\u0014#X\u0015G\u0014Q\u0012\u00143Q\u0012B\u0005F@G\u0014U\u0012@\u0005P@[\u000e\u0014\u0010[\u0012@Z\u0014\u001bI@\u0019@O\u001d"), (Object)messagingClusterServer.K.getInternalPort(), (Object)string);
            messagingClusterServer.B.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.k = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(ReplicationGroupJSON.e((Object)"R8`>u%o+!\ry#olR)s:d>!\u000fm9r8d>!\u001fd>w)slg-h d(!"), (Throwable)a2);
        }
    }

    public int getPhase() {
        return 50;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void e(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }
}

