/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.enterprise.cluster.NodeAllowsConnectionCheck;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.localstorage.file.AggregateWithoutSnapshotException;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private final ApplicationEventPublisher d;
    private final CommandDispatcher G;
    private final MeterFactory K;
    private final InstructionAckSource<SerializedCommandProviderInbound> B;
    private final ContextProvider A;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> L;
    private final Topology l;
    private final AxonServerRoutingConfiguration C;
    private final Logger k;
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> c;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int j;
    private final AuthenticationProvider D;
    private final ClientIdRegistry M;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> f;

    private /* synthetic */ boolean e(InstructionAck instructionAck) {
        CommandService a2 = instructionAck;
        CommandService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, SerializedCommandResponse serializedCommandResponse, StreamObserver<SerializedCommandResponse> streamObserver) {
        CommandService a22 = serializedCommandResponse;
        CommandService a3 = this;
        try {
            void a4;
            void v0 = a4;
            v0.onNext((Object)a22);
            v0.onCompleted();
            return;
        }
        catch (RuntimeException a22) {
            void a5;
            a3.k.debug(NodeAllowsConnectionCheck.e((Object)"Pqqdmzqq\"`m4axkql`\"o\u007f4dukxgp"), (Object)a5, (Object)a22);
            return;
        }
    }

    static {
        f = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.e(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
        L = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    }

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.c.values());
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)AggregateWithoutSnapshotException.e((Object)",\tk\u0007=\t+\u000f4H$\u001e*\b6\u00037\u0010 \u0014k\u00017\u0016&H&\t(\u000b$\b!H\u0006\t(\u000b$\b!5 \u00143\u000f&\u0003")).addMethod(L, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(f, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        CommandService a2 = clientStreamIdentification;
        CommandService a3 = this;
        if (a3.c.containsKey(a2)) {
            void a4;
            String string2 = "Command stream inactivity for " + a2.e();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcCommandDispatcherListener)a3.c.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            CommandService commandService = a3;
            commandService.k.debug(AggregateWithoutSnapshotException.e((Object)"\u0006\t(\u000b$\b!F\u0016\u00127\u0003$\u000be\u0005)\t6\u0003!F#\t7F&\n,\u0003+\u0012\u007fF>\u001b"), (Object)a2);
            commandService.d.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a2.j(), (String)a4, a2.e()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, StreamObserver streamObserver, SerializedCommandResponse serializedCommandResponse) {
        void a2;
        void a3;
        CommandService a4 = serializedCommandResponse;
        CommandService a5 = this;
        a5.e((String)a3, (SerializedCommandResponse)a4, (StreamObserver)a2);
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> streamObserver) {
        void a2;
        CommandService commandService = this;
        String string = commandService.A.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService2 = commandService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - void declaration
     */
    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> instructionAckSource, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void commandDispatcher2;
        void topology2;
        CommandService a2;
        CommandService commandService = commandService2;
        CommandService commandService2 = axonServerRoutingConfiguration;
        CommandService commandService3 = a2 = commandService;
        CommandService commandService4 = a2;
        CommandService commandService5 = a2;
        CommandService commandService6 = a2;
        CommandService commandService7 = a2;
        a2.k = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService8 = a2;
        a2.c = new ConcurrentHashMap();
        commandService7.j = 1;
        commandService7.l = topology2;
        commandService6.G = commandDispatcher2;
        commandService6.A = contextProvider2;
        commandService5.D = authenticationProvider2;
        commandService5.M = clientIdRegistry2;
        commandService4.K = meterFactory2;
        commandService4.d = eventPublisher;
        commandService3.B = instructionAckSource2;
        commandService3.C = commandService2;
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ByteString byteString, StreamObserver<SerializedCommandResponse> streamObserver) {
        void a2;
        CommandService a222 = byteString;
        CommandService a3 = this;
        a222 = new SerializedCommand((ByteString)a222);
        String string = a222.wrapped().getClientId();
        if (a3.k.isTraceEnabled()) {
            a3.k.trace(NodeAllowsConnectionCheck.e((Object)"yi84Pqaqkbgp\"wmyoulp84yi"), (Object)string, (Object)a222.wrapped().getName());
        }
        try {
            CommandService commandService = a3;
            commandService.G.dispatch(commandService.A.getContext(), (Authentication)a3.D.get(), (SerializedCommand)a222, arg_0 -> a3.e(string, (StreamObserver)a2, arg_0));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.k.warn(AggregateWithoutSnapshotException.e((Object)"\u0001\u000f6\u0016$\u0012&\u000e,\b\"F#\u0007,\n \u0002e\u0011,\u0012-F0\b \u001e5\u0003&\u0012 \u0002e\u00037\u0014*\u0014"), (Throwable)exception);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    @PreDestroy
    public void cleanup() {
        CommandService a2;
        a2.c.forEach((clientStreamIdentification, grpcCommandDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcCommandDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.c.clear();
    }
}

