/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.SendingStreamObserver;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.axoniq.axonserver.grpc.control.NodeInfo;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformInfo;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformServiceGrpc;
import io.axoniq.axonserver.grpc.control.RequestReconnect;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.util.StreamObserverUtils;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="PlatformService")
public class PlatformService
extends PlatformServiceGrpc.PlatformServiceImplBase
implements AxonServerClientService {
    private final ContextProvider K;
    private final ApplicationEventPublisher B;
    private final InstructionAckSource<PlatformOutboundInstruction> A;
    private final AuthenticationProvider L;
    private static final Logger l = LoggerFactory.getLogger(PlatformService.class);
    private final Map<ClientComponent, SendingStreamObserver<PlatformOutboundInstruction>> C;
    private final MeterFactory k;
    private final Map<String, Gauge> c;
    private final Topology j;
    private final Map<PlatformInboundInstruction.RequestCase, Deque<InstructionConsumer>> D;
    private final ClientIdRegistry M;
    public static final String f = "component";

    /*
     * WARNING - void declaration
     */
    public PlatformService(Topology topology, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, ApplicationEventPublisher applicationEventPublisher, MeterFactory meterFactory, @Qualifier(value="platformInstructionAckSource") InstructionAckSource<PlatformOutboundInstruction> instructionAckSource) {
        void meterFactory2;
        void eventPublisher;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void topology2;
        InstructionAckSource<PlatformOutboundInstruction> a2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource2 = instructionAckSource3;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource3 = instructionAckSource;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource4 = a2 = instructionAckSource2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource5 = a2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource6 = a2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource7 = a2;
        instructionAckSource7.C = new ConcurrentHashMap();
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource8 = a2;
        instructionAckSource6.c = new ConcurrentHashMap();
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource9 = a2;
        instructionAckSource6.D = new EnumMap(PlatformInboundInstruction.RequestCase.class);
        instructionAckSource6.j = topology2;
        instructionAckSource5.K = contextProvider2;
        instructionAckSource5.L = authenticationProvider2;
        instructionAckSource4.M = clientIdRegistry2;
        instructionAckSource4.B = eventPublisher;
        a2.k = meterFactory2;
        a2.A = instructionAckSource3;
        a2.onInboundInstruction(PlatformInboundInstruction.RequestCase.ACK, (clientComponent, platformInboundInstruction) -> {
            void a2;
            PlatformService a3 = platformInboundInstruction;
            PlatformService a4 = this;
            if (a4.e((InstructionAck)(a3 = a3.getAck()))) {
                void v0 = a2;
                l.warn(CommandResponseJson.e((Object)"\u000b;- .%1'*0:u7;-!, =!7:0u-00!~!1u*=;u=9700!~.#u13~61;*0&!~.#{"), (Object)v0.D, (Object)v0.M);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.D;
            objectArray[1] = a2.M;
            objectArray[2] = a3;
            l.trace(ProcessorEventPublisher.e((Object)"\u0005M4M>^2LwA9[#Z\"K#A8FwI4CwN%G:\b#@2\b4D>M9\\wS*\b8NwK8F#M/\\wS*\u0006wz2[\"D#\b,Uy"), objectArray);
        });
    }

    private /* synthetic */ boolean e(InstructionAck instructionAck) {
        PlatformService a2 = instructionAck;
        PlatformService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean requestReconnect(ClientComponent clientComponent, String string) {
        void a2;
        PlatformService a3 = clientComponent;
        PlatformService a4 = this;
        l.debug(CommandResponseJson.e((Object)"\f0/ ;&*u,0=:0;;6*o~.#usu%("), (Object)a3, (Object)a2);
        StreamObserver streamObserver = (StreamObserver)a4.C.get(a3);
        if (streamObserver != null) {
            PlatformService platformService = a3;
            a4.B.publishEvent((Object)new TopologyEvents.ApplicationReconnectRequested(platformService.M, platformService.j, a3.f, (String)a2));
            streamObserver.onNext((Object)PlatformOutboundInstruction.newBuilder().setRequestReconnect(RequestReconnect.newBuilder()).build());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(ClientComponent clientComponent, String string, SendingStreamObserver<PlatformOutboundInstruction> sendingStreamObserver) {
        void a2;
        void a3;
        PlatformService a4 = clientComponent;
        PlatformService a5 = this;
        l.debug(CommandResponseJson.e((Object)"\f09<-!;';1~62<;;*udu%("), (Object)a4);
        a5.C.put(a4, a3);
        PlatformService platformService = a4;
        PlatformService platformService2 = a4;
        a5.B.publishEvent((Object)new TopologyEvents.ApplicationConnected(platformService.M, platformService.f, platformService2.D, platformService2.j, (String)a2, null));
    }

    private static /* synthetic */ boolean c(String string, ClientComponent clientComponent) {
        String a2 = clientComponent;
        String a3 = string;
        return a2.getContext().equals(a3);
    }

    private /* synthetic */ long e(String string) {
        Object a2 = string;
        PlatformService a3 = this;
        return a3.C.keySet().stream().filter(arg_0 -> PlatformService.c((String)a2, arg_0)).count();
    }

    @EventListener
    public void on(TopologyEvents.RequestClientReconnect requestClientReconnect) {
        PlatformService a2 = requestClientReconnect;
        PlatformService a3 = this;
        a3.requestReconnect(a2.e(), ProcessorEventPublisher.e((Object)"\u0005M&]2[#M3\b5Qw]$M%"));
    }

    private static /* synthetic */ boolean c(String string, Map.Entry entry) {
        Map.Entry a2 = entry;
        String a3 = string;
        return ((ClientComponent)a2.getKey()).j.equals(a3);
    }

    private static /* synthetic */ boolean j(String string, Map.Entry entry) {
        Map.Entry a2 = entry;
        String a3 = string;
        return ((ClientComponent)a2.getKey()).M.equals(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Boolean e(String string, ClientComponent clientComponent) {
        void a2;
        PlatformService a3 = clientComponent;
        PlatformService a4 = this;
        return a4.requestReconnect((ClientComponent)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void onInboundInstruction(PlatformInboundInstruction.RequestCase requestCase, InstructionConsumer instructionConsumer) {
        void a3;
        PlatformService a4 = instructionConsumer;
        PlatformService a5 = this;
        a5.D.computeIfAbsent(a3, a2 -> new ArrayDeque()).add(a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, ClientComponent clientComponent) {
        void a2;
        PlatformService a3 = clientComponent;
        PlatformService a4 = this;
        a4.requestReconnect((ClientComponent)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void getPlatformServer(ClientIdentification clientIdentification, StreamObserver<PlatformInfo> streamObserver) {
        void a2;
        void a3;
        PlatformService platformService = this;
        String string = platformService.K.getContext();
        try {
            PlatformService a4 = platformService.j.findNodeForClient(a3.getClientId(), a3.getComponentName(), string, a3.getTagsMap());
            void v0 = a2;
            v0.onNext((Object)PlatformInfo.newBuilder().setSameConnection(a4.getName().equals(platformService.j.getName())).setPrimary(NodeInfo.newBuilder().setNodeName(a4.getName()).setHostName(a4.getHostName()).setGrpcPort(a4.getGrpcPort().intValue()).setHttpPort(a4.getHttpPort().intValue())).build());
            v0.onCompleted();
            return;
        }
        catch (MessagingPlatformException a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.getClientId();
            objectArray[1] = string;
            objectArray[2] = a4.getMessage();
            l.info(CommandResponseJson.e((Object)"\u0010,'1'~37;:<02~!?'90*u8:,u=9700!~.#z%(du%("), objectArray);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)a4));
            return;
        }
        catch (RuntimeException a4) {
            l.warn(ProcessorEventPublisher.e((Object)"m%Z8ZwX%G4M$[>F0\b4D>M9\\wZ2Y\"M$\\wS*"), (Object)a3, (Object)a4);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)a4));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendToClientStreamId(String string, PlatformOutboundInstruction platformOutboundInstruction) {
        void a2;
        PlatformService a3 = platformOutboundInstruction;
        PlatformService a4 = this;
        a4.C.entrySet().stream().filter(arg_0 -> PlatformService.e((String)a2, arg_0)).map(Map.Entry::getValue).collect(Collectors.toList()).forEach(arg_0 -> PlatformService.j((PlatformOutboundInstruction)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(ClientComponent clientComponent, long l2, String string) {
        PlatformService a2 = clientComponent;
        PlatformService a3 = this;
        l.debug(ProcessorEventPublisher.e((Object)"\u0013MzZ2O>[#M%M3\b4D>M9\\w\u0012wS*"), (Object)a2);
        if (a2 != null) {
            void a4;
            void a5;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2.getContext();
            stringArray[2] = f;
            stringArray[3] = a2.getComponent();
            Tags tags = Tags.of((String[])stringArray);
            a3.k.counter((MetricName)BaseMetricName.v, tags).increment();
            if (a5 > 0L) {
                a3.k.timer((MetricName)BaseMetricName.s, tags).record(System.currentTimeMillis() - a5, TimeUnit.MILLISECONDS);
            }
            if ((tags = (SendingStreamObserver)a3.C.remove(a2)) != null) {
                StreamObserverUtils.e((StreamObserver)tags);
            }
            a3.M.unregister(a2.D, ClientIdRegistry.ConnectionType.M);
            PlatformService platformService = a2;
            PlatformService platformService2 = a2;
            a3.B.publishEvent((Object)new TopologyEvents.ApplicationDisconnected(platformService.M, platformService.f, platformService2.D, platformService2.j, null, (String)a4));
        }
    }

    private static /* synthetic */ void j(PlatformOutboundInstruction platformOutboundInstruction, SendingStreamObserver sendingStreamObserver) {
        PlatformOutboundInstruction a2 = sendingStreamObserver;
        PlatformOutboundInstruction a3 = platformOutboundInstruction;
        a2.onNext((Object)a3);
    }

    /*
     * WARNING - void declaration
     */
    public void requestReconnectForContext(String string, String string2) {
        void a2;
        Object a3 = string2;
        PlatformService a4 = this;
        a4.C.keySet().stream().filter(arg_0 -> PlatformService.e((String)a2, arg_0)).collect(Collectors.toSet()).forEach(arg_0 -> a4.e((String)a3, arg_0));
    }

    public StreamObserver<PlatformInboundInstruction> openStream(StreamObserver<PlatformOutboundInstruction> streamObserver) {
        SendingStreamObserver a2;
        PlatformService platformService;
        PlatformService platformService2 = platformService = this;
        String string = platformService2.K.getContext();
        a2 = new SendingStreamObserver((StreamObserver)a2);
        PlatformService a3 = (Authentication)platformService2.L.get();
        if (l.isInfoEnabled()) {
            l.info(CommandResponseJson.e((Object)"\u001d:0;;6*<1;~:.000:u8:,u%("), (Object)a3.getName());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(ClientComponent clientComponent, Throwable throwable) {
        void a2;
        void a3;
        PlatformService platformService = this;
        PlatformService a4 = (SendingStreamObserver)platformService.C.remove(a3);
        if (a4 != null) {
            StreamObserverUtils.e((StreamObserver)a4, (Throwable)a2);
        }
        platformService.e((ClientComponent)a3, 0L, a2.getMessage());
    }

    private static /* synthetic */ boolean j(String string, ClientComponent clientComponent) {
        String a2 = clientComponent;
        String a3 = string;
        return ((ClientComponent)a2).j.equals(a3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean requestReconnect(String string, String string2) {
        void a2;
        Object a3 = string;
        PlatformService a4 = this;
        l.debug(ProcessorEventPublisher.e((Object)"\u0005M&]2[#\b%M4G9F2K#\u0012wS*"), a3);
        return a4.C.keySet().stream().filter(arg_0 -> PlatformService.j((String)a3, arg_0)).map(arg_0 -> a4.e((String)a2, arg_0)).findFirst().orElse(false);
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        void a2;
        PlatformService platformService = this;
        PlatformService a32 = (StreamObserver)platformService.C.remove(new ClientComponent(a2.c(), a2.j(), a2.F(), a2.E()));
        l.debug(CommandResponseJson.e((Object)"?%.976?!7:0u:<-61;00=!;1du%(ru=:0;;6*<1;du%("), (Object)a2.c(), (Object)a32);
        if (a32 != null) {
            try {
                a32.onCompleted();
                return;
            }
            catch (Exception a32) {
                l.debug(ProcessorEventPublisher.e((Object)"m%Z8Zw_?A;MwK;G$A9Ow\\%I4C>F0\b2^2F#\b'Z8K2[$G%\b4G9F2K#A8FwN%G:\b,Uw\u0005wS*"), (Object)a2.c(), (Object)a32.getMessage());
            }
        }
    }

    private static /* synthetic */ void e(PlatformOutboundInstruction platformOutboundInstruction, SendingStreamObserver sendingStreamObserver) {
        PlatformOutboundInstruction a2 = sendingStreamObserver;
        PlatformOutboundInstruction a3 = platformOutboundInstruction;
        a2.onNext((Object)a3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendToClient(String string, String string2, PlatformOutboundInstruction platformOutboundInstruction) {
        void a2;
        void a3;
        Object a4 = string;
        PlatformService a5 = this;
        a4 = a5.C.entrySet().stream().filter(arg_0 -> PlatformService.c((String)a3, arg_0)).filter(arg_0 -> PlatformService.j((String)a4, arg_0)).map(Map.Entry::getValue).toList();
        a4.forEach(arg_0 -> PlatformService.e((PlatformOutboundInstruction)a2, arg_0));
        if (!a4.isEmpty()) {
            return true;
        }
        return false;
    }

    @EventListener
    public void on(TopologyEvents.ApplicationInactivityTimeout applicationInactivityTimeout) {
        ClientComponent a2;
        PlatformService platformService = this;
        Object a3 = a2.e();
        a2 = new ClientComponent(a3.e(), a2.e().clientId(), a2.e(), a2.e().context());
        a3 = "Platform stream inactivity for " + a3.e();
        a3 = new ApplicationInactivityException((String)a3);
        platformService.e(a2, (Throwable)a3);
    }

    private static /* synthetic */ boolean e(String string, Map.Entry entry) {
        Map.Entry a2 = entry;
        String a3 = string;
        return a3.equals(((ClientComponent)a2.getKey()).D);
    }

    private static /* synthetic */ boolean e(String string, ClientComponent clientComponent) {
        String a2 = clientComponent;
        String a3 = string;
        return ((ClientComponent)a2).M.equals(a3);
    }

    public Set<ClientComponent> getConnectedClients() {
        PlatformService a2;
        return a2.C.keySet();
    }
}

