/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcFlowControlExecutorProvider;
import io.axoniq.axonserver.grpc.GrpcQueryDispatcherListener;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.QueryService;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.SubscriptionQueryRequestTarget;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryServiceGrpc;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryRequest;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryResponse;
import io.axoniq.axonserver.interceptor.SubscriptionQueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.rest.QueryRestController;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.transport.rest.v2.HealthRestControllerV2;
import io.axoniq.flowcontrol.producer.grpc.FlowControlledOutgoingStream;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Service(value="QueryService")
public class QueryService
extends QueryServiceGrpc.QueryServiceImplBase
implements AxonServerClientService {
    private final AxonServerRoutingConfiguration d;
    private final MeterFactory G;
    private final AuthenticationProvider K;
    private final SubscriptionQueryInterceptors B;
    private final ClientIdRegistry A;
    private final ContextProvider L;
    private final QueryDispatcher l;
    @Value(value="${axoniq.axonserver.query-threads:1}")
    private int C;
    private final GrpcFlowControlExecutorProvider k;
    private final InstructionAckSource<QueryProviderInbound> c;
    private final Topology j;
    private final ApplicationEventPublisher D;
    private final Map<ClientStreamIdentification, GrpcQueryDispatcherListener> M;
    private final Logger f;

    public Set<GrpcQueryDispatcherListener> listeners() {
        QueryService a2;
        return new HashSet<GrpcQueryDispatcherListener>(a2.M.values());
    }

    /*
     * WARNING - void declaration
     */
    public QueryService(Topology topology, QueryDispatcher queryDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, SubscriptionQueryInterceptors subscriptionQueryInterceptors, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="queryInstructionAckSource") InstructionAckSource<QueryProviderInbound> instructionAckSource, GrpcFlowControlExecutorProvider grpcFlowControlExecutorProvider, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void grpcFlowControlExecutorProvider2;
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void subscriptionQueryInterceptors2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void queryDispatcher2;
        void topology2;
        QueryService a2;
        QueryService queryService = queryService2;
        QueryService queryService2 = axonServerRoutingConfiguration;
        QueryService queryService3 = a2 = queryService;
        QueryService queryService4 = a2;
        QueryService queryService5 = a2;
        QueryService queryService6 = a2;
        QueryService queryService7 = a2;
        QueryService queryService8 = a2;
        a2.f = LoggerFactory.getLogger(QueryService.class);
        QueryService queryService9 = a2;
        a2.M = new ConcurrentHashMap();
        queryService8.C = 1;
        queryService8.j = topology2;
        queryService7.l = queryDispatcher2;
        queryService7.L = contextProvider2;
        queryService6.K = authenticationProvider2;
        queryService6.A = clientIdRegistry2;
        queryService5.B = subscriptionQueryInterceptors2;
        queryService5.G = meterFactory2;
        queryService4.D = eventPublisher;
        queryService4.c = instructionAckSource2;
        queryService3.k = grpcFlowControlExecutorProvider2;
        queryService3.d = queryService2;
    }

    private /* synthetic */ boolean e(InstructionAck instructionAck) {
        QueryService a2 = instructionAck;
        QueryService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(QueryRequest queryRequest, FluxSink fluxSink) {
        void a2;
        QueryService a3 = fluxSink;
        QueryService a4 = this;
        SerializedQuery serializedQuery = new SerializedQuery(a4.L.getContext(), (QueryRequest)a2);
        a4.l.query(serializedQuery, (Authentication)a4.K.get(), arg_0 -> ((FluxSink)a3).next(arg_0), arg_0 -> QueryService.e((FluxSink)a3, arg_0));
        a3.onRequest(arg_0 -> a4.e((QueryRequest)a2, arg_0));
    }

    private /* synthetic */ void e(QueryRequest queryRequest) {
        QueryService a2 = queryRequest;
        QueryService a3 = this;
        a3.l.cancel(a2.getMessageIdentifier());
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<QueryProviderOutbound> openStream(StreamObserver<QueryProviderInbound> streamObserver) {
        void a2;
        QueryService queryService = this;
        String string = queryService.L.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        QueryService queryService2 = queryService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static /* synthetic */ void e(FluxSink fluxSink, String string) {
        Object a2 = string;
        FluxSink a3 = fluxSink;
        a3.complete();
    }

    @PreDestroy
    public void cleanup() {
        QueryService a2;
        a2.M.forEach((clientStreamIdentification, grpcQueryDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcQueryDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.M.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        QueryService a2 = clientStreamIdentification;
        QueryService a3 = this;
        if (a3.M.containsKey(a2)) {
            void a4;
            String string2 = "Query stream inactivity for " + a2.e();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcQueryDispatcherListener)a3.M.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            QueryService queryService = a3;
            queryService.f.debug(QueryRestController.e((Object)"R\"f%zwP#q2b:#4o8p2gwe8qw`;j2m#9wx*"), (Object)a2);
            queryService.D.publishEvent((Object)new TopologyEvents.QueryHandlerDisconnected(a2.j(), (String)a4, a2.e()));
        }
    }

    public void query(QueryRequest queryRequest, StreamObserver<QueryResponse> streamObserver) {
        ServerCallStreamObserver a2;
        QueryService a3 = queryRequest;
        QueryService a4 = this;
        if (a4.f.isTraceEnabled()) {
            a4.f.trace(HealthRestControllerV2.e((Object)"\u000f;Nf&#\u0017#\u001d0\u0011\"T7\u0001#\u0006?Nf\u000f;"), (Object)a3.getClientId(), (Object)a3.getQuery());
        }
        a2 = a2;
        a2.setOnCancelHandler(() -> a4.e((QueryRequest)a3));
        new FlowControlledOutgoingStream((CallStreamObserver)new GrpcQueryResponseConsumer(a4, (CallStreamObserver)a2), a4.k.provide()).accept((Publisher)Flux.create(arg_0 -> a4.e((QueryRequest)a3, arg_0)).limitRate(32));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(QueryRequest queryRequest, long l2) {
        void a2;
        QueryService a3 = queryRequest;
        QueryService a4 = this;
        a4.l.flowControl(a3.getMessageIdentifier(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<SubscriptionQueryRequest> subscription(StreamObserver<SubscriptionQueryResponse> streamObserver) {
        void a2;
        QueryService queryService = this;
        Object a3 = queryService.L.getContext();
        QueryService queryService2 = queryService;
        return new SubscriptionQueryRequestTarget((String)a3, (Authentication)queryService.K.get(), (StreamObserver)a2, queryService2.B, queryService2.D);
    }

    @NotNull
    private /* synthetic */ QueryProviderInbound e(String string) {
        Object a2 = string;
        QueryService a3 = this;
        return QueryProviderInbound.newBuilder().setSubscriptionQueryRequest(SubscriptionQueryRequest.newBuilder().setUnsubscribe(SubscriptionQuery.newBuilder().setSubscriptionIdentifier((String)a2))).build();
    }
}

