/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.ContextClusterMetrics;
import io.axoniq.axonserver.message.command.CommandInformation;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final Publisher<PlatformOutboundInstruction> C;
    private final ApplicationEventPublisher k;
    private final Logger c;
    private final Map<ClientStreamIdentification, Instant> j;
    private final Map<ClientStreamIdentification, ClientInformation> D;
    private final long M;
    private final Clock f;

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.E(), a2.c());
        a3.j.remove(a2);
        a3.D.remove(a2);
        a3.c.debug(CommandInformation.e((Object)"R,n(!5n6h,n*h6fxi=`*u:d9uxg7sxb4h=o,!#|v"), (Object)a2);
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l2) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.e((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l2, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.c = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.D = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.j = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.c.trace(CommandInformation.e((Object)"I=`*u\u001ad9uxs=b=h.d<!>s7lxz%"), (Object)a3);
            heartbeatMonitor.j.put(a3, Instant.now(a2.f));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.f = a5;
        heartbeatMonitor5.k = a4;
        heartbeatMonitor4.M = a3;
        heartbeatMonitor4.C = a2;
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.C.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void e(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }

    private static /* synthetic */ void e(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.e((BiConsumer)a2, arg_0, arg_1));
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.c.debug(ContextClusterMetrics.e((Object)"\u000f\u001a)\u0011'\u001b\"\u0015l\u0011#\u001c\"\u0017/\u0006)\u0016l\u0011 \u001b)\u001c8\u0001l\u0013>\u0017l\u00018\u001b \u001el\u0013 \u001b:\u0017b\\b"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.f).minus(heartbeatMonitor3.M, ChronoUnit.MILLIS);
        heartbeatMonitor3.j.forEach((arg_0, arg_1) -> heartbeatMonitor.e((Instant)a2, arg_0, arg_1));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.j(), a2.d());
        a3.D.put(clientStreamIdentification, new ClientInformation(a2.E(), a2.e(), a2.j()));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.D.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.D.get(a4);
            String string = clientInformation.D;
            String string2 = clientInformation.f;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.M;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.c.info(ContextClusterMetrics.e((Object)"\u000f\u001e%\u0017\"\u0006l\u001b\"\u0013/\u0006%\u0004%\u00065R(\u00178\u0017/\u0006)\u0016l\u0014#\u0000l\u001f#\u0000)R8\u001a-\u001cl\t1R!\u001b \u001e%\u0001)\u0011#\u001c(\u0001bR\u000f\u001e%\u0017\"\u0006vR7\u000f`R \u0013?\u0006\r\u00118\u001b:\u001b8\u000bvR7\u000f`R8\u001b!\u0017#\u00078Hl\t1\\l"), objectArray);
            a5.k.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.M)));
        }
    }
}

