/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.l;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.metric.Metrics;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private final ConcurrentSkipListMap<FileVersion, l> I;
    private final String E;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> i;
    private final Counter h;
    private final Supplier<IndexManager> b;
    private final RemoteAggregateSequenceNumberResolver d;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> G;
    private final EventType K;
    private static final String B = "aggregateMap";
    protected final String A;
    private final MeterFactory.RateMeter L;
    protected final Supplier<StorageProperties> l;
    private static final ScheduledExecutorService C;
    private final ConcurrentNavigableMap<Long, Integer> k;
    private final Counter c;
    private ScheduledFuture<?> j;
    private final MeterFactory.RateMeter D;
    private static final Logger M;
    private final AtomicLong f;

    private static /* synthetic */ Integer e(FileVersion fileVersion, Long l2, Integer n) {
        Integer a2 = n;
        FileVersion a3 = fileVersion;
        return a2 == null ? a3.e() : Math.max(a3.e(), a2);
    }

    public long size() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        Integer n;
        void a2;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.l.get();
        if (standardIndexManager.i.remove((long)a2) == null && (n = (Integer)standardIndexManager.k.remove((long)a2)) != null) {
            FileVersion fileVersion;
            int a222;
            int n2 = a222 = 0;
            while (n2 < n) {
                fileVersion = new FileVersion((long)a2, a222);
                if (storageProperties.index(standardIndexManager.E, fileVersion).exists()) {
                    standardIndexManager.remove(fileVersion);
                }
                n2 = ++a222;
            }
            FileVersion a222 = new FileVersion((long)a2, n.intValue());
            fileVersion = (l)standardIndexManager.I.remove(a222);
            if (fileVersion != null) {
                fileVersion.close();
            }
            standardIndexManager.G.remove(a222);
        }
        if (FileUtils.e((File)storageProperties.index(standardIndexManager.E, (long)a2)) && FileUtils.e((File)storageProperties.bloomFilter(standardIndexManager.E, (long)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Long l3 : standardIndexManager.i.descendingKeySet()) {
            StandardIndexManager a4 = (IndexEntries)((Map)standardIndexManager.i.get(l3)).get(a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(new FileVersion(l3.longValue(), 0), standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.D.equals((Object)standardIndexManager.K)));
        }
        if (!standardIndexManager.k.isEmpty()) {
            return standardIndexManager.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, ((Long)standardIndexManager.k.keySet().first()).longValue());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono e(FileVersion fileVersion) {
        void a2;
        StandardIndexManager standardIndexManager = this;
        Object a3 = ((StorageProperties)standardIndexManager.l.get()).transformedIndex(standardIndexManager.E, (FileVersion)a2);
        return standardIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    static {
        M = LoggerFactory.getLogger(StandardIndexManager.class);
        C = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(RaftConfigServiceFactory.e((Object)"9\u00034\b(@=\f>\f7\b\"@")));
    }

    private /* synthetic */ l e(FileVersion fileVersion2) {
        StandardIndexManager a2 = fileVersion2;
        StandardIndexManager a3 = this;
        try {
            return a3.I.computeIfAbsent(a2, fileVersion -> {
                StandardIndexManager a2 = fileVersion;
                StandardIndexManager a3 = this;
                return new l(a3, (FileVersion)a2);
            }).e();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a2 = (l)a3.I.remove(a2);
            if (a2 != null) {
                a2.close();
            }
            throw indexNotFoundException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IndexEntries e(FileVersion fileVersion, String string) {
        int n;
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        if (standardIndexManager.e((FileVersion)a3, (String)a2)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                StandardIndexManager a4 = standardIndexManager.e((FileVersion)a3);
                return a4.e((String)a2);
            }
            catch (IndexNotFoundException a4) {
                return null;
            }
            catch (Exception a4) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a3.e() + " segment.", a4);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(Long l2, String string, List list) {
        void a3;
        void a4;
        Object a5 = list;
        StandardIndexManager a6 = this;
        a6.i.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a3, arg_0 -> StandardIndexManager.e((List)a5, arg_0)).addAll((List)a5);
    }

    private static /* synthetic */ Mono e(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.fromSupplier(() -> a3).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(file3 -> {
            File a2 = a2;
            File a3 = a3;
            return FileUtils.e((File)a3, (File)a2);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void j(FileVersion fileVersion, Map<String, IndexEntries> map) {
        void a2;
        StandardIndexManager a3 = this;
        StandardIndexManager a4 = fileVersion;
        if (a3.e((FileVersion)a4)) {
            a3.e((FileVersion)a4, (Map)a2);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a3.b.get();
        if (standardIndexManager != null) {
            standardIndexManager.j((FileVersion)a4, (Map)a2);
        }
    }

    public void addExistingIndex(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.k.put(a2.e(), a2.e());
        a3.e();
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Map.Entry entry : standardIndexManager.k.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            StandardIndexManager a4 = standardIndexManager.e(fileVersion, (String)a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(fileVersion, standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.D.equals((Object)standardIndexManager.K)));
        }
        IndexManager a5 = (IndexManager)standardIndexManager.b.get();
        if (a5 != null) {
            return a5.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, (Long)standardIndexManager.k.keySet().last() - 1L);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        StandardIndexManager a3;
        void a4;
        void a5;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntry;
        StandardIndexManager a6 = standardIndexManager;
        if (a6.k.containsKey((long)a5)) {
            throw new IndexNotFoundException((long)a5 + ": already completed");
        }
        a6.i.computeIfAbsent((long)a5, a2 -> new ConcurrentHashMap()).computeIfAbsent(a4, arg_0 -> StandardIndexManager.e((IndexEntry)a3, arg_0)).add((IndexEntry)a3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void e(Map map, String string2, List list) {
        void a2;
        List a3 = list;
        Map a4 = map;
        a4.computeIfAbsent(a2, string -> {
            String a2 = string;
            List a3 = a3;
            return new StandardIndexEntries(((IndexEntry)a3.get(0)).j());
        }).addAll(a3);
    }

    private /* synthetic */ void e() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.f.set(standardIndexManager.k.keySet().stream().skip(((StorageProperties)a2.l.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StandardIndexManager standardIndexManager;
        HTreeMap hTreeMap;
        Map<String, List> a2;
        FileVersion a222;
        StandardIndexManager standardIndexManager2;
        block12: {
            StandardIndexManager a3;
            block7: {
                StandardIndexManager standardIndexManager3;
                block11: {
                    block10: {
                        block9: {
                            void a222;
                            void a4;
                            standardIndexManager2 = this;
                            a222 = new FileVersion((long)a4, (int)a222);
                            if (a2 == null) {
                                a2 = Collections.emptyMap();
                            }
                            if (!FileUtils.e((File)(a4 = ((StorageProperties)standardIndexManager2.l.get()).transformedIndex(standardIndexManager2.E, a222)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a4);
                            }
                            a3 = DBMaker.fileDB((File)a4);
                            if (!((StorageProperties)standardIndexManager2.l.get()).isUseMmapIndex()) break block9;
                            a3.fileMmapEnable();
                            if (!((StorageProperties)standardIndexManager2.l.get()).isForceCleanMmapIndex()) break block10;
                            StandardIndexManager standardIndexManager4 = a3;
                            standardIndexManager3 = standardIndexManager4;
                            standardIndexManager4.cleanerHackEnable();
                            break block11;
                        }
                        a3.fileChannelEnable();
                    }
                    standardIndexManager3 = a3;
                }
                a3 = standardIndexManager3.make();
                hTreeMap = a3.hashMap(B, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.e()).createOrOpen();
                try {
                    a2.forEach((string, list) -> {
                        void a2;
                        int n;
                        List a3 = list;
                        HTreeMap a4 = hTreeMap;
                        IndexEntry indexEntry = (IndexEntry)a3.get(0);
                        Integer[] integerArray = new Integer[a3.size()];
                        int n2 = n = 0;
                        while (n2 < a3.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a3.get(n3)).e();
                            n2 = n;
                        }
                        a4.put((Object)a2, (Object)new StandardIndexEntries(indexEntry.j(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    standardIndexManager = a3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            standardIndexManager = a3;
        }
        standardIndexManager.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)standardIndexManager2.l.get()).bloomFilter(standardIndexManager2.E, a222).getAbsolutePath(), a2.keySet().size(), ((StorageProperties)standardIndexManager2.l.get()).getBloomIndexFpp());
        hTreeMap2.e();
        hTreeMap2.e(a2.keySet());
        hTreeMap2.j();
    }

    public void init() {
        int n;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.l.get();
        String[] stringArray = FileUtils.e((File)new File(standardIndexManager.E), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            StandardIndexManager a2 = FileUtils.e((String)stringArray[n]);
            if (storageProperties.dataFile(standardIndexManager.E, (FileVersion)a2).exists()) {
                standardIndexManager.k.compute(a2.e(), (arg_0, arg_1) -> StandardIndexManager.e((FileVersion)a2, arg_0, arg_1));
            } else {
                standardIndexManager.remove((FileVersion)a2);
            }
            n3 = ++n;
        }
        standardIndexManager.e();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean e(long l2, long l3, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!a4.isEmpty() && a3 >= a4.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> e(FileVersion fileVersion, File file) {
        void a3;
        StandardIndexManager a4 = fileVersion;
        StandardIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.e((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(arg_0 -> StandardIndexManager.e((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.e((FileVersion)a4, arg_0));
    }

    private static /* synthetic */ boolean e(long l2, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.l.get()).index(a3.E, (FileVersion)a2);
        fileArray[1] = ((StorageProperties)a3.l.get()).bloomFilter(a3.E, (FileVersion)a2);
        return Arrays.asList(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(FileVersion fileVersion, Map<String, IndexEntries> map) {
        DBMaker.Maker maker;
        void a2;
        File file;
        Map a3;
        StorageProperties storageProperties;
        StandardIndexManager standardIndexManager;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            standardIndexManager = this;
                            storageProperties = (StorageProperties)standardIndexManager.l.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.e((File)(file = storageProperties.indexTemp(standardIndexManager.E, a2.e())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                StandardIndexManager a4 = maker2.hashMap(B, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.e()).createOrOpen();
                try {
                    a4.putAll(a3);
                    if (a4 == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (a4 != null) {
                            try {
                                a4.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a4.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(standardIndexManager.E, (FileVersion)a2).toPath(), copyOptionArray);
        }
        catch (IOException a4) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(standardIndexManager.E, (FileVersion)a2), (Throwable)a4);
        }
        StandardIndexManager standardIndexManager2 = a4 = new PersistedBloomFilter(storageProperties.bloomFilter(standardIndexManager.E, (FileVersion)a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        standardIndexManager2.e();
        standardIndexManager2.e(a3.keySet());
        standardIndexManager2.j();
        standardIndexManager.G.put(a2, a4);
        standardIndexManager.k.put(a2.e(), a2.e());
        standardIndexManager.e((FileVersion)a2);
    }

    private static /* synthetic */ IndexEntries e(List list, String string) {
        String a2 = string;
        List a3 = list;
        return new StandardIndexEntries(((IndexEntry)a3.get(0)).j());
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory) {
        StandardIndexManager a2;
        void a3;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = meterFactory;
        StandardIndexManager a7 = standardIndexManager;
        a7((String)a6, (Supplier)a5, (String)a4, (EventType)a3, null, (MeterFactory)a2, () -> null);
    }

    private static /* synthetic */ IndexEntries e(IndexEntry indexEntry, String string) {
        Object a2 = string;
        IndexEntry a3 = indexEntry;
        return new StandardIndexEntries(a3.j());
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> e(String string, int n, long l2) {
        void a52222;
        void a52222;
        void a2;
        Map map;
        void a3;
        void a4;
        StandardIndexManager standardIndexManager = this;
        int n2 = 0;
        for (Long a52222 : standardIndexManager.i.descendingKeySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if (a52222 > a3 || (map = (Map)standardIndexManager.i.get(a52222)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n2;
        }
        for (Map.Entry a52222 : standardIndexManager.k.entrySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if ((Long)a52222.getKey() > a3) continue;
            map = standardIndexManager.e(new FileVersion(((Long)a52222.getKey()).longValue(), ((Integer)a52222.getValue()).intValue()), (String)a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n2;
        }
        Iterator<Object> iterator = (StandardIndexManager)standardIndexManager.b.get();
        Optional a52222 = Optional.empty();
        if (iterator != null) {
            Optional a52222 = iterator.e((String)a2, (int)(a4 - n2), (long)a3);
        }
        if (a52222.isEmpty() && standardIndexManager.d != null && n2 < a4 && !standardIndexManager.k.isEmpty()) {
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            Optional a52222 = standardIndexManager2.d.getLastSequenceNumber(standardIndexManager2.A, (String)a2, (int)(a4 - n2), (Long)standardIndexManager.k.keySet().last() - 1L);
        }
        return a52222;
    }

    public boolean remove(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        l l2 = (l)a3.I.remove(a2);
        if (l2 != null) {
            l2.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.G.remove(a2);
        if (FileUtils.e((File)((StorageProperties)standardIndexManager.l.get()).index(a3.E, (FileVersion)a2)) && FileUtils.e((File)((StorageProperties)a3.l.get()).bloomFilter(a3.E, (FileVersion)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager standardIndexManager = object;
        Object object = supplier2;
        StandardIndexManager a8 = standardIndexManager;
        a8((String)a7, (Supplier)a6, (String)a5, (EventType)a4, null, (MeterFactory)a3, (Supplier)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean e(FileVersion fileVersion2, String string) {
        void a2;
        StandardIndexManager a3 = fileVersion2;
        StandardIndexManager a4 = this;
        if ((a3 = a4.G.computeIfAbsent(a3, fileVersion -> {
            StandardIndexManager a2 = fileVersion;
            StandardIndexManager a3 = this;
            M.debug(RaftConfigServiceFactory.e((Object)"+\u0010jM?\u001d5\u0003p\u000f<\u0002?\u0000p\u000b9\u0001$\b\"M6\u0002\"M+\u0010"), (Object)a3.A, (Object)a2.e());
            StorageProperties storageProperties = (StorageProperties)a3.l.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.E, (FileVersion)a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.e()) {
                return null;
            }
            a3.h.increment();
            StandardIndexManager standardIndexManager = a2;
            standardIndexManager.c();
            return standardIndexManager;
        })) != null && !a3.e((String)a2)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int e(long l2, long l3, SortedMap<FileVersion, IndexEntries> sortedMap, FileVersion fileVersion, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!(a4 = a4.range((long)a3, (long)a2, EventType.D.equals((Object)a5.K))).isEmpty()) {
            void a6;
            void a7;
            a7.put(a6, a4);
        }
        return a4.size();
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> map) {
        void a2;
        Object a3 = l2;
        StandardIndexManager a4 = this;
        if (a4.k.containsKey(a3)) {
            throw new IndexNotFoundException((Long)a3 + ": already completed");
        }
        a2.forEach((arg_0, arg_1) -> a4.e((Long)a3, arg_0, arg_1));
    }

    private /* synthetic */ boolean e(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.l.get()).dataFile(a3.E, (FileVersion)a2).exists();
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        void a2;
        void a3;
        StandardIndexManager a222 = searchHint;
        StandardIndexManager a4 = this;
        int a222 = a222.equals((Object)EventStorageEngine.SearchHint.f) ? ((StorageProperties)a4.l.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a4.e((String)a3, a222, (long)a2);
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return a3.e((FileVersion)a2).e();
    }

    private static /* synthetic */ void e(Map.Entry a2) {
        ((l)a2.getValue()).close();
    }

    private /* synthetic */ File e(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.l.get()).index(a3.E, (FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        StandardIndexManager standardIndexManager;
        StandardIndexManager standardIndexManager2 = standardIndexManager = this;
        standardIndexManager2.i.clear();
        standardIndexManager2.G.clear();
        standardIndexManager2.I.forEach((fileVersion, l2) -> {
            FileVersion a2 = l2;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        StandardIndexManager standardIndexManager3 = standardIndexManager;
        standardIndexManager3.I.clear();
        if (standardIndexManager3.j != null && !standardIndexManager.j.isDone()) {
            standardIndexManager.j.cancel(true);
        }
        if (a2 != false) {
            standardIndexManager.k.keySet().forEach(arg_0 -> standardIndexManager.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager4 = standardIndexManager;
        standardIndexManager4.k.clear();
        StandardIndexManager a3 = (IndexManager)standardIndexManager4.b.get();
        if (a3 != null) {
            a3.cleanup((boolean)a2);
        }
    }

    public void complete(FileVersion fileVersion) {
        StandardIndexManager a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager standardIndexManager = a2 = this;
        standardIndexManager.e((FileVersion)a3, (Map)standardIndexManager.i.get(a3.e()));
        a2.i.remove(a3.e());
        a2.e();
    }

    private /* synthetic */ void e(FileVersion fileVersion, Void void_) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.k.put(a2.e(), a2.e());
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager a4 = this;
        if (a4.k.containsKey(a3.e())) {
            return a4.e((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.b.get();
        if (indexManager != null) {
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5) {
        void a2;
        void a3;
        Iterator iterator;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        Object[] objectArray = new Object[4];
        objectArray[0] = standardIndexManager.A;
        objectArray[1] = a6;
        objectArray[2] = (long)a5;
        objectArray[3] = (long)a4;
        M.debug(Metrics.e((Object)")zh'>h=l'w\u0013`5u7`3s7')zrj;i\u0001b#r7i1b\u001cr?e7ur|/+rk3t&T7v'b<d7I'j0b ')z"), objectArray);
        long l6 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = standardIndexManager.i.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l7 = (Long)iterator.next();
            if (l6 < a3) {
                return a7;
            }
            IndexEntries indexEntries = (IndexEntries)standardIndexManager.i.getOrDefault(l7, Collections.emptyMap()).get(a6);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.e((long)a5, (long)a4, (SortedMap)a7, new FileVersion(l7.longValue(), 0), indexEntries);
                if (standardIndexManager2.e((long)a5, (long)(a2 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            l6 = l7;
            iterator2 = iterator;
        }
        TreeMap treeMap = a7;
        treeMap.putAll(standardIndexManager.lookupAggregateInClosedSegments((String)a6, (long)a5, (long)a4, (long)a2, (long)a3, l6));
        return treeMap;
    }

    /*
     * WARNING - void declaration
     */
    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        Object a4 = new HashMap();
        a3.forEach((arg_0, arg_1) -> StandardIndexManager.e((Map)a4, arg_0, arg_1));
        standardIndexManager.j((FileVersion)a2, (Map)a4);
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        void a3;
        void a4;
        void a5;
        long a6;
        IndexManager indexManager;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        IndexManager indexManager2 = indexManager = standardIndexManager.k.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a6 < a5) {
                return a7;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = standardIndexManager.e(fileVersion, (String)a4);
            Object[] objectArray = new Object[4];
            objectArray[0] = standardIndexManager.A;
            objectArray[1] = a4;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            M.debug(Metrics.e((Object)"|/=rk=h9r\"F5` b5f&br|/';irt7`?b<sr|/'4h'i6')z"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.e((long)a3, (long)a2, (SortedMap)a7, fileVersion, indexEntries);
                if (standardIndexManager2.e((long)a3, (long)(a8 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            a6 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)standardIndexManager.b.get();
        if (indexManager != null) {
            void a8;
            a7.putAll(indexManager.lookupAggregateInClosedSegments((String)a4, (long)a3, (long)a2, (long)a8, (long)a5, a6));
        }
        return a7;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Stream e(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        StandardIndexManager a4 = this;
        File[] fileArray = new File[2];
        fileArray[0] = a2.index(a4.E, ((Long)a3.getKey()).longValue());
        fileArray[1] = a2.bloomFilter(a4.E, ((Long)a3.getKey()).longValue());
        return Stream.of(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        StandardIndexManager a4 = (StorageProperties)standardIndexManager.l.get();
        return standardIndexManager.k.entrySet().stream().filter(arg_0 -> StandardIndexManager.e((long)a3, (int)a2, arg_0)).flatMap(arg_0 -> standardIndexManager.e((StorageProperties)a4, arg_0));
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return Mono.defer(() -> a3.e((FileVersion)a2));
    }

    public boolean validIndex(FileVersion fileVersion) {
        block3: {
            boolean bl;
            StandardIndexManager a2;
            block4: {
                a2 = fileVersion;
                StandardIndexManager a3 = this;
                if (!a3.k.containsKey(a2.e()) || ((Integer)a3.k.get(a2.e())).intValue() != a2.e()) break block3;
                if (a3.e((FileVersion)a2) == null || a3.e((FileVersion)a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                M.warn(RaftConfigServiceFactory.e((Object)"\u0016\f9\u00015\tp\u0019?M&\f<\u00044\f$\bp\u0004>\t5\u0015p\u000b?\u001fp\u001e5\n=\b>\u0019jM+\u0010"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, RemoteAggregateSequenceNumberResolver remoteAggregateSequenceNumberResolver, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager a8;
        Object a9 = string;
        StandardIndexManager standardIndexManager = a8 = this;
        StandardIndexManager standardIndexManager2 = a8;
        StandardIndexManager standardIndexManager3 = a8;
        StandardIndexManager standardIndexManager4 = a8;
        a8.i = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a8;
        standardIndexManager4.G = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a8;
        a8.I = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a8;
        standardIndexManager3.k = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a8;
        standardIndexManager3.f = new AtomicLong();
        standardIndexManager3.l = a7;
        standardIndexManager2.E = a6;
        standardIndexManager2.A = a9;
        standardIndexManager.K = a5;
        standardIndexManager.d = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a9;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a9 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a8;
        void v10 = a3;
        a8.D = a3.rateMeter((MetricName)BaseMetricName.J, (Tags)a9);
        a8.L = v10.rateMeter((MetricName)BaseMetricName.aa, (Tags)a9);
        standardIndexManager9.h = v10.counter((MetricName)BaseMetricName.Y, (Tags)a9);
        standardIndexManager9.c = a3.counter((MetricName)BaseMetricName.e, (Tags)a9);
        C.scheduleAtFixedRate(() -> {
            Object a2;
            StandardIndexManager standardIndexManager = this;
            StorageProperties storageProperties = (StorageProperties)standardIndexManager.l.get();
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            while (standardIndexManager2.I.size() > storageProperties.getMaxIndexesInMemory()) {
                a2 = standardIndexManager.I.pollFirstEntry();
                M.debug(RaftConfigServiceFactory.e((Object)"+\u0010jM\u0013\u0001?\u001e9\u00037M9\u00034\b(M+\u0010"), (Object)standardIndexManager.A, a2.getKey());
                standardIndexManager.j = C.schedule(() -> StandardIndexManager.e((Map.Entry)a2), 2L, TimeUnit.SECONDS);
                standardIndexManager2 = standardIndexManager;
            }
            StandardIndexManager standardIndexManager3 = standardIndexManager;
            while (standardIndexManager3.G.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager4 = standardIndexManager;
                standardIndexManager3 = standardIndexManager4;
                a2 = standardIndexManager4.G.pollFirstEntry();
                StandardIndexManager standardIndexManager5 = standardIndexManager;
                M.debug(Metrics.e((Object)"|/=rU7j=q7cre>h=jra;k&b '4h ')zra h?'?b?h ~"), (Object)standardIndexManager5.A, a2.getKey());
                standardIndexManager5.c.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a8.b = a2;
    }
}

