/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.localstorage.AggregateReader;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.multitier.MultiTierInformationProvider;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties
implements Cloneable,
Serializable {
    private int validationSegments;
    private int segmentsForSequenceNumberCheck;
    private int eventsPerSegmentPrefetch;
    private String sksAggregateIdEncoder;
    private int maxIndexesInMemory;
    private int maxBloomFiltersInMemory;
    private String sksPositionIndexFileSuffix;
    private int readBufferSize;
    private int sksRocksdbCacheSize;
    private boolean useMmapIndex;
    private GlobalIndexPreload globalIndexPreload;
    private static final String FILE_WITH_VERSION_FORMAT = "%020d_%05d%s";
    private Boolean forceCleanMmapIndex;
    private Long minFreeSpace;
    private String storage;
    private int globalIndexSegmentsCheck;
    private int sksMaxOpenedPositionIndexFiles;
    private Long warnFreeSpace;
    private int flags;
    public static final String PRIMARY_STORAGE_KEY = "primary";
    private static final String TEMP_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.temp";
    private Duration[] retentionTime;
    private String eventsSuffix;
    private String indexSuffix;
    private Boolean forceClean;
    private int primaryCleanupDelay;
    private static final String FILE_FORMAT = "%020d%s";
    private static final String TRANSFORMED_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.transformed";
    private final SystemInfoProvider systemInfoProvider;
    private int segmentSize;
    private long syncInterval;
    private static final String PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s";
    private boolean keepOldVersions;
    private int memoryMappedSegments;
    private Duration globalIndexPreloadTimeout;
    private String bloomIndexSuffix;
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    private String globalIndexSuffix;
    private int entriesPerSegment;
    private String indexFormat;
    private Map<String, String> storages;
    public static final String TRANSFORMED_SUFFIX = ".transformed";
    private boolean bulkIndexAllowParallel;
    private int secondaryCleanupDelay;
    private long forceInterval;
    private String newIndexSuffix;
    private float bloomIndexFpp;
    private static final String OLD_PATH_FORMAT = "%s/%014d%s";
    private static final String PATH_FORMAT = "%s/%020d%s";
    private static final String TEMP_PATH_FORMAT = "%s/%020d%s.temp";

    public void setSegmentSize(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)MultiTierInformationProvider.e((Object)"\u001ab.j,i=':n3bij<t='+bik,t:'=o(ii5x3~3q4\u007f3~"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)AggregateReader.e((Object)"y\u0000M\bO\u000b^EY\fP\u0000\n\b_\u0016^EH\u0000\n\u0002X\u0000K\u0011O\u0017\n\u0011B\u0004DE\u001a"));
        a3.segmentSize = (int)a2.toBytes();
    }

    public void setPrimaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.primaryCleanupDelay = a2;
    }

    public int getMemoryMappedSegments() {
        StorageProperties a2;
        return a2.memoryMappedSegments;
    }

    public String getSksPositionIndexFileSuffix() {
        StorageProperties a2;
        return a2.sksPositionIndexFileSuffix;
    }

    public void setIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexFormat = a2;
    }

    public void setSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.segmentsForSequenceNumberCheck = a2;
    }

    public long warnFreeSpace() {
        StorageProperties a2;
        if (a2.warnFreeSpace == null) {
            return (long)((double)a2.minFreeSpace() * 1.25);
        }
        return a2.warnFreeSpace;
    }

    public boolean isBulkIndexAllowParallel() {
        StorageProperties a2;
        return a2.bulkIndexAllowParallel;
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        return a2.useMmapIndex;
    }

    public String getGlobalIndexSuffix() {
        StorageProperties a2;
        return a2.globalIndexSuffix;
    }

    private /* synthetic */ StorageProperties e() {
        StorageProperties storageProperties = this;
        try {
            return (StorageProperties)storageProperties.clone();
        }
        catch (CloneNotSupportedException a2) {
            throw new RuntimeException(a2.getMessage(), a2);
        }
    }

    public StorageProperties withGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.e().globalIndexPreloadTimeout = a2;
        return a3.e();
    }

    public String getBloomIndexSuffix() {
        StorageProperties a2;
        return a2.bloomIndexSuffix;
    }

    public Boolean getForceClean() {
        StorageProperties a2;
        return a2.forceClean;
    }

    public boolean isCleanRequired() {
        StorageProperties a2;
        if (Boolean.TRUE.equals(a2.forceClean) || a2.systemInfoProvider.javaOnWindows()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public StorageProperties(SystemInfoProvider systemInfoProvider, String string, String string2, String string3, String string4, String string5, String string6) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        StorageProperties a9;
        StorageProperties storageProperties = object;
        Object object = string6;
        StorageProperties storageProperties2 = a9 = storageProperties;
        StorageProperties storageProperties3 = a9;
        StorageProperties storageProperties4 = a9;
        a9((SystemInfoProvider)a8);
        storageProperties4.eventsSuffix = a7;
        storageProperties4.indexSuffix = a6;
        storageProperties3.bloomIndexSuffix = a5;
        storageProperties3.globalIndexSuffix = a4;
        storageProperties2.newIndexSuffix = a3;
        storageProperties2.sksPositionIndexFileSuffix = a2;
    }

    public void setBloomIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.bloomIndexSuffix = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public StorageProperties withRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.e().retentionTime = a2;
        return a3.e();
    }

    public int getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    public int getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public String dataFile(long a2) {
        StorageProperties a3;
        Object[] objectArray = new Object[2];
        objectArray[0] = a2;
        objectArray[1] = a3.eventsSuffix;
        return String.format(FILE_FORMAT, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.e() == 0) {
            return a4.newIndexTemp((String)a2, a3.e());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties withForceClean(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.e().forceClean = a2;
        return a3.e();
    }

    public void setWarnFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.warnFreeSpace = a2 == null ? null : Long.valueOf(a2.toBytes());
    }

    public long getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public StorageProperties withSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.e().sksMaxOpenedPositionIndexFiles = a2;
        return a3.e();
    }

    public void setGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.globalIndexPreload = a2;
    }

    public void setNewIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.newIndexSuffix = a2;
    }

    public StorageProperties withSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.e().sksRocksdbCacheSize = a2;
        return a3.e();
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File oldIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public void setMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxIndexesInMemory = a2;
    }

    public String getSksAggregateIdEncoder() {
        StorageProperties a2;
        return a2.sksAggregateIdEncoder;
    }

    public void setEventsSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.eventsSuffix = a2;
    }

    public StorageProperties withSegmentSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.e().segmentSize = a2;
        return a3.e();
    }

    public String getIndexFormat() {
        StorageProperties a2;
        return a2.indexFormat;
    }

    public int segmentsForSequenceNumberCheck() {
        StorageProperties a2;
        return a2.segmentsForSequenceNumberCheck;
    }

    public String dataFile(FileVersion fileVersion) {
        StorageProperties a2 = fileVersion;
        StorageProperties a3 = this;
        if (a2.e() == 0) {
            return a3.dataFile(a2.e());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.e();
        objectArray[1] = a2.e();
        objectArray[2] = a3.eventsSuffix;
        return String.format(FILE_WITH_VERSION_FORMAT, objectArray);
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    public void setSyncInterval(long a2) {
        a.syncInterval = a2;
    }

    public void setFlags(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.flags = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.e() == 0) {
            return a4.transformedIndex((String)a2, a3.e());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File newTransformedIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.e() == 0) {
            return a4.transformedIndex((String)a2, a3.e());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties withGlobalIndexPreload(GlobalIndexPreload globalIndexPreload) {
        StorageProperties a2 = globalIndexPreload;
        StorageProperties a3 = this;
        a3.e().globalIndexPreload = a2;
        return a3.e();
    }

    public float getBloomIndexFpp() {
        StorageProperties a2;
        return a2.bloomIndexFpp;
    }

    public StorageProperties(SystemInfoProvider systemInfoProvider) {
        StorageProperties a2;
        StorageProperties a3 = systemInfoProvider;
        StorageProperties storageProperties = a2 = this;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        StorageProperties storageProperties8 = a2;
        StorageProperties storageProperties9 = a2;
        StorageProperties storageProperties10 = a2;
        StorageProperties storageProperties11 = a2;
        a2.eventsSuffix = ".events";
        storageProperties11.indexSuffix = ".index";
        storageProperties11.newIndexSuffix = ".nindex";
        storageProperties10.globalIndexSuffix = ".xref";
        storageProperties10.bloomIndexSuffix = ".bloom";
        storageProperties9.segmentSize = 0x10000000;
        storageProperties9.storage = "./data";
        StorageProperties storageProperties12 = a2;
        storageProperties9.storages = new HashMap();
        storageProperties8.bloomIndexFpp = 0.03f;
        storageProperties8.forceInterval = 1000L;
        storageProperties7.validationSegments = 10;
        storageProperties7.memoryMappedSegments = 5;
        storageProperties6.primaryCleanupDelay = 0;
        storageProperties6.secondaryCleanupDelay = 0;
        storageProperties5.maxIndexesInMemory = 50;
        storageProperties5.maxBloomFiltersInMemory = 100;
        storageProperties4.syncInterval = 1000L;
        storageProperties4.useMmapIndex = true;
        storageProperties3.forceCleanMmapIndex = true;
        storageProperties3.eventsPerSegmentPrefetch = 10;
        storageProperties2.globalIndexSegmentsCheck = Integer.MAX_VALUE;
        storageProperties2.readBufferSize = 32768;
        storageProperties.keepOldVersions = false;
        Duration[] durationArray = new Duration[1];
        durationArray[0] = Duration.ofDays(7L);
        storageProperties.retentionTime = durationArray;
        StorageProperties storageProperties13 = a2;
        StorageProperties storageProperties14 = a2;
        StorageProperties storageProperties15 = a2;
        StorageProperties storageProperties16 = a2;
        StorageProperties storageProperties17 = a2;
        storageProperties17.segmentsForSequenceNumberCheck = 10;
        storageProperties17.entriesPerSegment = 1000000;
        storageProperties16.globalIndexPreload = GlobalIndexPreload.D;
        storageProperties16.globalIndexPreloadTimeout = Duration.ofSeconds(10L);
        storageProperties15.sksPositionIndexFileSuffix = ".rindex";
        storageProperties15.sksAggregateIdEncoder = "plain";
        storageProperties14.sksMaxOpenedPositionIndexFiles = 100;
        storageProperties14.sksRocksdbCacheSize = (int)DataSize.ofMegabytes((long)512L).toBytes();
        storageProperties13.bulkIndexAllowParallel = false;
        storageProperties13.systemInfoProvider = a3;
    }

    /*
     * WARNING - void declaration
     */
    public File dataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        return new File((String)a2 + File.separator + a4.dataFile((FileVersion)a3));
    }

    public long getRetentionTime(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        if (a2 < 0 || a2 >= a3.retentionTime.length) {
            return System.currentTimeMillis();
        }
        return a3.retentionTime[a2].toMillis();
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setSecondaryCleanupDelay(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.secondaryCleanupDelay = a2;
    }

    public void setForceInterval(long a2) {
        a.forceInterval = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndex(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.e() == 0) {
            return a4.newIndex((String)a2, a3.e());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public int getSksRocksdbCacheSize() {
        StorageProperties a2;
        return a2.sksRocksdbCacheSize;
    }

    public void setGlobalIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.globalIndexSuffix = a2;
    }

    public long minFreeSpace() {
        StorageProperties a2;
        if (a2.minFreeSpace == null) {
            return (long)a2.segmentSize * 2L;
        }
        return a2.minFreeSpace;
    }

    /*
     * WARNING - void declaration
     */
    public File oldDataFile(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.eventsSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public void setMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.maxBloomFiltersInMemory = a2;
    }

    public String getStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        String string2 = (String)a3.storages.get(a2);
        if (string2 == null) {
            if (PRIMARY_STORAGE_KEY.equals(a2)) {
                return a3.storage;
            }
            Object object = a2;
            throw new IllegalStateException("Storage " + (String)object + " not defined on this node.To define storage set property: axoniq.axonserver.event.storages." + (String)object);
        }
        return string2;
    }

    public String getPrimaryStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3.storages.getOrDefault(PRIMARY_STORAGE_KEY, a3.storage);
        objectArray[1] = a2;
        return String.format(AggregateReader.e((Object)"\u000f\u0016\u0005@Y"), objectArray);
    }

    public String getEventsSuffix() {
        StorageProperties a2;
        return a2.eventsSuffix;
    }

    public int getEntriesPerSegment() {
        StorageProperties a2;
        return a2.entriesPerSegment;
    }

    public void setStorages(Map<String, String> map) {
        Object a2 = map;
        StorageProperties a3 = this;
        if (a3.storages != null && a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
            a3.storages.putAll(a2);
            return;
        }
        a3.storages = a2;
    }

    public Duration getGlobalIndexPreloadTimeout() {
        StorageProperties a2;
        return a2.globalIndexPreloadTimeout;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return a2.systemInfoProvider.javaOnWindows();
    }

    /*
     * WARNING - void declaration
     */
    public File index(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.e() == 0) {
            return a4.index((String)a2, a3.e());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setUseMmapIndex(Boolean bl) {
        Boolean a2 = bl;
        StorageProperties a3 = this;
        a3.useMmapIndex = a2;
    }

    public StorageProperties withMaxBloomFiltersInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.e().maxBloomFiltersInMemory = a2;
        return a3.e();
    }

    public void setForceCleanMmapIndex(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceCleanMmapIndex = a2;
    }

    public Map<String, String> getAvailableStorages() {
        StorageProperties a2;
        return a2.storages;
    }

    public void setValidationSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.validationSegments = a2;
    }

    public void setSksMaxOpenedPositionIndexFiles(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksMaxOpenedPositionIndexFiles = a2;
    }

    public void setEntriesPerSegment(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.entriesPerSegment = a2;
    }

    public void setRetentionTime(Duration[] durationArray) {
        Duration[] a2 = durationArray;
        Duration[] a3 = this;
        a3.retentionTime = a2;
    }

    public StorageProperties withIndexFormat(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.e().indexFormat = a2;
        return a3.e();
    }

    public StorageProperties withSegmentsForSequenceNumberCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.e().segmentsForSequenceNumberCheck = a2;
        return a3.e();
    }

    public String getNewIndexSuffix() {
        StorageProperties a2;
        return a2.newIndexSuffix;
    }

    public void setGlobalIndexPreloadTimeout(Duration duration) {
        Object a2 = duration;
        StorageProperties a3 = this;
        a3.globalIndexPreloadTimeout = a2;
    }

    public int getSksMaxOpenedPositionIndexFiles() {
        StorageProperties a2;
        return a2.sksMaxOpenedPositionIndexFiles;
    }

    public void setSksRocksdbCacheSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.sksRocksdbCacheSize = a2;
    }

    public void setSksPositionIndexFileSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksPositionIndexFileSuffix = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File oldBloomFilter(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public int getReadBufferSize() {
        StorageProperties a2;
        return a2.readBufferSize;
    }

    public boolean isKeepOldVersions() {
        StorageProperties a2;
        return a2.keepOldVersions;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public void setStorage(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.storage = a2;
        if (a3.storages != null) {
            if (!a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
                a3.storages.put(PRIMARY_STORAGE_KEY, a2);
                return;
            }
        } else {
            a3.storages = new HashMap();
            a3.storages.put(PRIMARY_STORAGE_KEY, a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setIndexSuffix(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.indexSuffix = a2;
    }

    public void setKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.keepOldVersions = a2;
    }

    public void setBloomIndexFpp(float f2) {
        float a2 = f2;
        StorageProperties a3 = this;
        a3.bloomIndexFpp = a2;
    }

    public void setGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.globalIndexSegmentsCheck = a2;
    }

    public void setEventsPerSegmentPrefetch(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.eventsPerSegmentPrefetch = a2;
    }

    public StorageProperties withGlobalIndexSegmentsCheck(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.e().globalIndexSegmentsCheck = a2;
        return a3.e();
    }

    public StorageProperties withSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.e().sksAggregateIdEncoder = a2;
        return a3.e();
    }

    /*
     * WARNING - void declaration
     */
    public File bloomFilter(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.e() == 0) {
            return a4.bloomFilter((String)a2, a3.e());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public int getMaxBloomFiltersInMemory() {
        StorageProperties a2;
        return a2.maxBloomFiltersInMemory;
    }

    /*
     * WARNING - void declaration
     */
    public File transformedDataFile(String string, FileVersion fileVersion) {
        void a2;
        StorageProperties a3 = fileVersion;
        StorageProperties a4 = this;
        if (a3.e() == 0) {
            throw new RuntimeException(MultiTierInformationProvider.e((Object)"*f'i&sis;f't/h;jis&'?b;t h''y"));
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.e();
        objectArray[2] = a3.e();
        objectArray[3] = a4.eventsSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setSksAggregateIdEncoder(String string) {
        Object a2 = string;
        StorageProperties a3 = this;
        a3.sksAggregateIdEncoder = a2;
    }

    public StorageProperties withMaxIndexesInMemory(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.e().maxIndexesInMemory = a2;
        return a3.e();
    }

    public int getEventsPerSegmentPrefetch() {
        StorageProperties a2;
        return a2.eventsPerSegmentPrefetch;
    }

    public GlobalIndexPreload getGlobalIndexPreload() {
        StorageProperties a2;
        return a2.globalIndexPreload;
    }

    /*
     * WARNING - void declaration
     */
    public String getStorage(String string, String string2) {
        void a2;
        Object a3 = string2;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[2];
        objectArray[0] = a4.getStorage((String)a2);
        objectArray[1] = a3;
        return String.format(MultiTierInformationProvider.e((Object)"ltf\":"), objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public File transformedIndex(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public void setBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.bulkIndexAllowParallel = a2;
    }

    public void setMemoryMappedSegments(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.memoryMappedSegments = a2;
    }

    /*
     * WARNING - void declaration
     */
    public File newIndexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public File indexTemp(String string, long l2) {
        void a2;
        Object a3 = string;
        StorageProperties a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = (long)a2;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public StorageProperties withBulkIndexAllowParallel(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.e().bulkIndexAllowParallel = a2;
        return a3.e();
    }

    public void setMinFreeSpace(DataSize dataSize) {
        StorageProperties a2 = dataSize;
        StorageProperties a3 = this;
        a3.minFreeSpace = a2 == null ? null : Long.valueOf(a2.toBytes());
    }

    public void setReadBufferSize(int n) {
        int a2 = n;
        StorageProperties a3 = this;
        a3.readBufferSize = a2;
    }

    public StorageProperties withKeepOldVersions(boolean bl) {
        boolean a2 = bl;
        StorageProperties a3 = this;
        a3.e().keepOldVersions = a2;
        return a3.e();
    }

    public int globalIndexSegmentsCheck() {
        StorageProperties a2;
        return a2.globalIndexSegmentsCheck;
    }

    public void setForceClean(Boolean bl) {
        Object a2 = bl;
        StorageProperties a3 = this;
        a3.forceClean = a2;
    }
}

