/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.SnapshotReader;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.E;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final EventTransformer L;
    protected final AtomicLong l;
    private final MeterFactory C;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> k;
    private final Synchronizer c;
    protected final AtomicReference<WritePosition> j;
    private Path D;
    private static final Logger I = LoggerFactory.getLogger(WritableFileStorageTier.class);
    private final FileSystemMonitor M;
    private final Gauge f;

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.k.get(a2);
        if (a3 != null) {
            return a3.e();
        }
        return (Integer)writableFileStorageTier.e(arg_0 -> WritableFileStorageTier.e((Long)a2, arg_0), (Object)0);
    }

    private /* synthetic */ void e(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        I.warn(SnapshotReader.e((Object)"35rh\n=$#e+:-)<!&/h!&,-0h-&<:!-;h.':h35h;-/%-&<;"), (Object)a3.F, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.l.canBatchIndexParallel() && ((StorageProperties)a3.G.get()).isBulkIndexAllowParallel()) {
            I.info(MessageJson.e((Object)"O\u001d\u000e@}\u000eP\u0005L\tZ\u0007\u0014\u0017]\u0014\\@D\u0001F\u0001X\fQ\f\u0014\u0013A\u0010D\u000fF\u0014"), (Object)a3.F);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.e(arg_0 -> WritableFileStorageTier.e((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.e());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.e();
                        if (!eventInformation.e()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.e().getAggregateSequenceNumber(), eventInformation.e(), eventInformation.e());
                        hashMap.computeIfAbsent(eventInformation.e().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.l.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.F;
            objectArray[1] = a3.l.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.G.get()).isBulkIndexAllowParallel();
            I.info(SnapshotReader.e((Object)"35rh\u0001&,-0!&/h;-9=-&<!)$$1h`\r>)$=)<!'&h'.h8):)$$-$h!&,-0!&/rh!&,-0\u000b)8)*!$!<!-;r35hnnh+'&<-0<\u001b-<<!&/;r35a"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.e(arg_0 -> WritableFileStorageTier.e((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.e());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.e();
                        if (!eventInformation.e()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.e().getAggregateSequenceNumber(), eventInformation.e(), eventInformation.e());
                        hashMap.computeIfAbsent(eventInformation.e().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.l.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        I.warn(MessageJson.e((Object)"\u001bIZ\u0014\"A\f_MW\u0012Q\u0001@\tZ\u0007\u0014\tZ\u0004Q\u0018\u0014\u0014[\u000f_@O\u001d"), (Object)a3.F, (Object)Duration.between(instant, Instant.now()));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.e((long)a2, a3.intValue());
    }

    private static /* synthetic */ Flux e(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    public long c() {
        WritableFileStorageTier a2;
        return a2.l.get();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition e(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(SnapshotReader.e((Object)"\u0001$$-/)$h<:)&;)+<!'&h;!2-rhm,"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.j.getAndUpdate(arg_0 -> WritableFileStorageTier.e((int)a3, n4, (int)a2, arg_0))).j(n4) && !a4.c((int)a2)) continue;
            I.debug(MessageJson.e((Object)"\u001bIZ\u0014#F\u0005U\u0014]\u000eS@Z\u0005C@G\u0005S\rQ\u000e@@O\u001d"), (Object)a5.F, (Object)a4.c);
            WritePosition writePosition = a4;
            writePosition.j.e(writePosition.l, -1);
            WritableEventSource writableEventSource = a5.e(new FileVersion(a4.c, (int)a2), n4 + 5 + 4, true);
            a5.j.set(a4.e(writableEventSource, (int)a2));
        } while (!a4.e(n4) || a4.c((int)a2));
        return a4;
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    private static /* synthetic */ Stream j(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    private static /* synthetic */ Boolean e(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction e(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.L);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.e((List)a3);
        WritePosition a22 = writableFileStorageTier.e(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    public long j() {
        WritableFileStorageTier a3;
        return (Long)a3.e((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    private static /* synthetic */ Optional j(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.e(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.e(a5.e());
                a5 = writableFileStorageTier3.e(a5, (StorageProperties)a4);
                writableFileStorageTier3.e((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.e());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.j();
                a4 = writableFileStorageTier4.e(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.l.remove(a5);
                a6 = a5.e();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.e();
                        if (eventInformation.e()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.e().getAggregateSequenceNumber(), eventInformation.e(), a6);
                            a222.computeIfAbsent(eventInformation.e().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.e();
                writableFileStorageTier2.l.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.l.addToActiveSegment(Long.valueOf(a5.e()), a222);
        a4.e(n, 0);
        a3 = new WritePosition(a6, n, a5.e(), a4, Long.valueOf(a5.e()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.j.set(a3);
        writableFileStorageTier6.c.e((WritePosition)a3);
        I.info(SnapshotReader.e((Object)"35rh\u001b-/%-&<;h!&!<!)$!2-,"), (Object)writableFileStorageTier2.F);
    }

    public void initSegments(long a2) {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition e(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.e(a5, (int)a3, (int)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.j.e((List)a3, writableFileStorageTier.l, writableFileStorageTier.c, (arg_0, arg_1, arg_2) -> a5.e((Map)a2, arg_0, arg_1, arg_2));
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.j = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.l = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.k = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.C = a6;
        writableFileStorageTier3.M = a4;
        writableFileStorageTier3.L = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.c = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.l.complete(new FileVersion(a3.C.longValue(), 0));
            writableFileStorageTier.e(arg_0 -> writableFileStorageTier.e((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.e();
        stringArray[2] = "type";
        stringArray[3] = a10.e().name();
        a11.f = a6.gauge((MetricName)BaseMetricName.f, Tags.of((String[])stringArray), (Object)a11.c, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.l.get() - (double)a2.e();
        });
    }

    private /* synthetic */ String e() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.F + "-" + writableFileStorageTier.F.e().name().toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.e(arg_0 -> WritableFileStorageTier.e((long)a2, a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void e(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.G.get();
        File file = new File(writableFileStorageTier.B);
        FileUtils.e((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.l.init();
        writableFileStorageTier2.e((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.D = file.toPath();
        writableFileStorageTier2.M.registerPath(writableFileStorageTier.e(), writableFileStorageTier.D, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    protected Optional<EventSource> e(long a2) {
        WritableFileStorageTier a3;
        if (a3.k.containsKey(a2)) {
            return Optional.of((EventSource)a3.k.get(a2));
        }
        return Optional.empty();
    }

    private static /* synthetic */ Optional e(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.B);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.M.unregisterPath(writableFileStorageTier2.e());
        writableFileStorageTier.C.remove((Meter)a3.f);
        writableFileStorageTier2.c.e();
        writableFileStorageTier.k.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.e(0L);
            if (a2 != false) {
                void a5;
                a4.j(a5.longValue());
            }
        });
        a3.e((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.l.cleanup(bl2);
        if (bl2) {
            FileUtils.e((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> e(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.k.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.e((File)a3.j(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).e())));
            }), (Stream)a5.e(arg_0 -> WritableFileStorageTier.e((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.e(arg_0 -> WritableFileStorageTier.j((long)a2, a4, arg_0), Stream.empty());
    }

    private static /* synthetic */ boolean e(long a2, FileVersion a3) {
        if (a3.e() < a2) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ Stream e(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.k.values().stream().mapToLong(a2 -> a2.j.capacity()).sum() + (Long)a3.e(StorageTier::size, (Object)0L);
    }

    private /* synthetic */ int e(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.F + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    /*
     * WARNING - void declaration
     */
    public void c(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.k.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.k.firstKey()).longValue()) {
            I.info(SnapshotReader.e((Object)"35rh\u000e':+!&/h&-0<h;-/%-&<h<'h*-h+:-)<-,"), (Object)writableFileStorageTier.F);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.G.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.j.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.e(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.j(a22.getSegmentSize())) {
                I.debug(MessageJson.e((Object)"\u001bIZ\u0014#F\u0005U\u0014]\u000eS@Z\u0005C@G\u0005S\rQ\u000e@@O\u001d"), (Object)writableFileStorageTier.F, (Object)writePosition2.c);
                WritePosition writePosition3 = writePosition2;
                writePosition3.j.e(writePosition3.l, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.e(new FileVersion(writePosition2.c, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.j.set(writePosition2.e((WritableEventSource)a3, 0));
                writableFileStorageTier2.c.j(new WritePosition(writePosition2.c, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.c), writePosition2.k));
            }
        }
        writableFileStorageTier.e();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void j(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.k.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.e();
            byteBufferEventSource2.e(0L);
        }
        writableFileStorageTier.e((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.e((long)a2, arg_0));
    }

    private /* synthetic */ void j() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.e((SortedSet)a2);
        }
        I.info(MessageJson.e((Object)"\u001bIZ\u0014)Z\u0004Q\u0018\u0014\u000fZ@P\tG\u000b\u0014\tG@A\u0010\u0014\u0014[@P\u0001@\u0005"), (Object)writableFileStorageTier.F);
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.e(arg_0 -> WritableFileStorageTier.e((String)a2, arg_0), (Object)Flux.empty());
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.e(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.e((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    private static /* synthetic */ void e(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.e((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.e(arg_0 -> WritableFileStorageTier.e((long)a2, arg_0), Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.k.containsKey((long)a2)) {
            return a4.e((long)a2, a3);
        }
        return (Boolean)a4.e(arg_0 -> WritableFileStorageTier.e((long)a2, a3, arg_0), (Object)true);
    }

    private static /* synthetic */ Optional e(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    private /* synthetic */ void e() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.k.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.F + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion e(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.e((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::e).filter(arg_0 -> WritableFileStorageTier.e((long)a3, arg_0)).max(FileVersion::e).orElse((FileVersion)a2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource e(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.G.get();
            File file = storageProperties.dataFile(writableFileStorageTier.B, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.k.remove(a4.e());
                    if (object != null) {
                        object.e(0L);
                    }
                    FileUtils.e((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.e() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.B, new FileVersion(a4.e(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.k.remove(a4.e());
                    if (a32222 != null) {
                        a32222.e(0L);
                    }
                    FileUtils.e((File)object);
                }
            }
            object = new RandomAccessFile(file, SnapshotReader.e((Object)":?"));
            a32222 = ((RandomAccessFile)object).getChannel();
            I.info(MessageJson.e((Object)"\u001bIZ\u0014/D\u0005Z\tZ\u0007\u0014\u0006]\fQ@O\u001d"), (Object)writableFileStorageTier.F, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.e(), a4.e(), writableFileStorageTier.L, storageProperties);
            writableFileStorageTier.k.put(a4.e(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.F + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    protected Optional<EventSource> e(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.e(a2.e());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new E(a4, (WritePosition)a3), () -> a4.j((WritePosition)a3));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean e(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.k.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.e(0L);
        }
        if (a4.l.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.e((File)a4.j(a3))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void j(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.k.remove(a2.C);
        I.debug(SnapshotReader.e((Object)"\u0000)&,-,h'>-:h35dh:-%)!&!&/h;-/%-&<;rh35"), (Object)a2.C, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.e((long)((StorageProperties)writableFileStorageTier.G.get()).getPrimaryCleanupDelay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion e(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.l.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.e((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.e();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.e());
            try {
                while (a42222.hasNext()) {
                    a42222.e();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.k.remove(a3.e());
            a2.e(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.k.remove(a3.e());
        a2.e(0L);
        return new FileVersion(l2, 0);
    }

    public int e() {
        WritableFileStorageTier a2;
        return a2.k.size();
    }

    private static /* synthetic */ Integer e(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.k.keySet();
    }

    public long e(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.M.checkFreeSpace(writableFileStorageTier2.D);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.e((List)a2, a222);
        WritePosition a222 = a2.e();
        writableFileStorageTier2.e(a222, a2.e(), hashMap);
        writableFileStorageTier.l.addToActiveSegment(a222.C, hashMap);
        writableFileStorageTier.l.set(a222.c + (long)a2.e().size() - 1L);
        writableFileStorageTier.c.j(a222);
        return a222.c;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.e((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.e(arg_0 -> WritableFileStorageTier.j((FileVersion)a2, arg_0), Optional.empty());
    }

    public long e() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.j.get()).c;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }
}

