/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file.xref;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.SnapshotReader;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.sks.RocksDBIndexKey;
import io.axoniq.axonserver.localstorage.file.xref.E;
import io.axoniq.axonserver.localstorage.file.xref.Index;
import io.axoniq.axonserver.localstorage.file.xref.JumpSkipIndexEntries;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ReadOnlyJumpSkipIndexManager
implements IndexManager {
    protected final String E;
    protected final AtomicBoolean i;
    protected final AtomicLong h;
    protected final ConcurrentNavigableMap<Long, Integer> b;
    protected final MeterFactory.RateMeter d;
    protected final ConcurrentSkipListMap<FileVersion, Index> G;
    private static final Logger K = LoggerFactory.getLogger(ReadOnlyJumpSkipIndexManager.class);
    protected final String B;
    protected final Supplier<StorageProperties> A;
    protected static final Serializer<JumpSkipIndexEntries> L = new E();
    protected final EventType l;
    protected static final ScheduledExecutorService C = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(RocksDBIndexKey.e((Object)"\u0018:_ \u001c-\u00171_$\u0013'\u0013.\u0017;_")));
    protected ScheduledFuture<?> k;
    protected final Supplier<IndexManager> c;
    protected final AtomicLong j;
    protected final String D;
    public static final String M = "index";
    protected final MeterFactory.RateMeter f;

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return a3.j((FileVersion)a2).e();
    }

    private static /* synthetic */ boolean e(long l2, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Collections.singletonList(((StorageProperties)a3.A.get()).newIndex(a3.D, (FileVersion)a2));
    }

    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l2) {
        ReadOnlyJumpSkipIndexManager a2 = searchHint;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public Index e(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        K.debug(SnapshotReader.e((Object)"\u0004''#!&/h.':h35dh!&,-0-;rh35"), (Object)((long)a2), (Object)readOnlyJumpSkipIndexManager.b);
        Object a3 = (Integer)readOnlyJumpSkipIndexManager.b.get((long)a2);
        if (a3 != null) {
            return readOnlyJumpSkipIndexManager.j(new FileVersion((long)a2, ((Integer)a3).intValue()));
        }
        a3 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.c.get();
        if (a3 != null) {
            K.debug(RocksDBIndexKey.e((Object)"2\u000fsR/\u001b'\u0016i\u001b'\u0016,\ni\u0014&\u0000i\t4R \u001ci\u001c,\n=R=\u001b,\u0000"), (Object)readOnlyJumpSkipIndexManager.B, (Object)((long)a2));
            return a3.e((long)a2);
        }
        throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.B + ": Index not found: " + (long)a2);
    }

    public SegmentIndexEntries lastIndexEntries(String string, long l2) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(SnapshotReader.e((Object)"\u00078-:)<!'&h'&$1h;=88':<-,h.':h8:!%):1h!&,-0h%)&)/-:"));
    }

    private /* synthetic */ void e(FileVersion fileVersion, File file) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        K.debug(SnapshotReader.e((Object)"35rh\t+<!>)<!&/h!&,-0h.':h.!$->-:;!'&h35"), (Object)a3.B, (Object)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected FileVersion e(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        NavigableSet<Long> a3 = readOnlyJumpSkipIndexManager.b.keySet().tailSet((long)a2, true);
        if (a3.isEmpty()) {
            throw new IndexNotFoundException(readOnlyJumpSkipIndexManager.B + ": Index for token not found: " + (long)a2);
        }
        return new FileVersion(((Long)a3.first()).longValue(), ((Integer)readOnlyJumpSkipIndexManager.b.get(a3.first())).intValue());
    }

    /*
     * WARNING - void declaration
     */
    protected File e(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        void a2;
        File a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2;
        block9: {
            ReadOnlyJumpSkipIndexManager a222;
            block7: {
                readOnlyJumpSkipIndexManager2 = this;
                a222 = (StorageProperties)readOnlyJumpSkipIndexManager2.A.get();
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = a222.newIndex(readOnlyJumpSkipIndexManager2.D, (FileVersion)a3);
                objectArray[2] = a2.keySet();
                K.debug(SnapshotReader.e((Object)"35rh+:-)<-h35dh#-1;h35"), objectArray);
                a3 = a222.newIndexTemp(readOnlyJumpSkipIndexManager2.D, a3.e());
                try {
                    Files.deleteIfExists(a3.toPath());
                }
                catch (IOException a222) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, RocksDBIndexKey.e((Object)"4(\u001b%\u0017-R=\u001di\u0016,\u001e,\u0006,R=\u0017$\u0002&\u0000(\u00000R \u001c-\u00171R/\u001b%\u0017"), (Throwable)a222);
                }
                a222 = DBMaker.fileDB((File)a3).fileMmapEnable().cleanerHackEnable().make();
                HTreeMap hTreeMap = a222.hashMap(M, (Serializer)Serializer.STRING, L).create();
                try {
                    hTreeMap.putAll((Map)a2);
                    a222.commit();
                    if (hTreeMap == null) break block7;
                    readOnlyJumpSkipIndexManager = a222;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block9;
            }
            readOnlyJumpSkipIndexManager = a222;
        }
        readOnlyJumpSkipIndexManager.close();
        File file = a3;
        readOnlyJumpSkipIndexManager2.e(file, a2.size());
        return file;
    }

    protected void j() {
        ReadOnlyJumpSkipIndexManager a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a2;
        readOnlyJumpSkipIndexManager.j.set(readOnlyJumpSkipIndexManager.b.keySet().stream().skip(((StorageProperties)a2.A.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l2, int n, Map<String, List<IndexEntry>> map) {
        StorageProperties storageProperties;
        block10: {
            StorageProperties storageProperties2;
            block8: {
                Map<String, List> a2;
                void a3;
                int a2222 = n;
                ReadOnlyJumpSkipIndexManager a4 = this;
                storageProperties2 = (StorageProperties)a4.A.get();
                Object a2222 = new FileVersion((long)a3, a2222);
                if (a2 == null) {
                    a2 = Collections.emptyMap();
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = a2222;
                objectArray[1] = storageProperties2.newIndex(a4.D, (long)a3);
                objectArray[2] = a2.keySet();
                K.debug(SnapshotReader.e((Object)"35rh+:-)<-h35dh#-1;h35"), objectArray);
                a2222 = storageProperties2.newTransformedIndex(a4.D, (FileVersion)a2222);
                try {
                    Files.deleteIfExists(((File)a2222).toPath());
                }
                catch (IOException iOException) {
                    throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, RocksDBIndexKey.e((Object)"4(\u001b%\u0017-R=\u001di\u0016,\u001e,\u0006,R=\u0000(\u001c:\u0014&\u0000$\u0017-R \u001c-\u00171R/\u001b%\u0017"), (Throwable)iOException);
                }
                storageProperties2 = DBMaker.fileDB((File)a2222).fileMmapEnable().cleanerHackEnable().make();
                a2222 = storageProperties2.hashMap(M, (Serializer)Serializer.STRING, L).createOrOpen();
                try {
                    Index index = a4.e((long)a3);
                    a2.forEach((arg_0, arg_1) -> ReadOnlyJumpSkipIndexManager.e(index, (HTreeMap)a2222, arg_0, arg_1));
                    if (a2222 == null) break block8;
                    storageProperties = storageProperties2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a2222 != null) {
                            try {
                                a2222.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable a2222) {
                                throwable.addSuppressed(a2222);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a2222.close();
                break block10;
            }
            storageProperties = storageProperties2;
        }
        storageProperties.close();
    }

    public void addToActiveSegment(Long l2, Map<String, List<IndexEntry>> readOnlyJumpSkipIndexManager) {
        Object a2 = readOnlyJumpSkipIndexManager;
        readOnlyJumpSkipIndexManager = this;
    }

    public void init() {
        File[] fileArray = this;
        if (!fileArray.i.get()) {
            int n2;
            File[] a2 = new File(fileArray.D).listFiles(file -> {
                File a2 = file;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return a2.getName().endsWith(a3.E);
            });
            if (a2 == null) {
                return;
            }
            int n3 = a2.length;
            int n4 = n2 = 0;
            while (n4 < n3) {
                File file2 = a2[n2];
                FileVersion fileVersion = FileUtils.e((String)file2.getName());
                fileArray.b.compute(fileVersion.e(), (l2, n) -> {
                    Integer a2 = n;
                    FileVersion a3 = fileVersion;
                    return a2 == null ? a3.e() : Math.max(a3.e(), a2);
                });
                fileArray.h.addAndGet(file2.length());
                n4 = ++n2;
            }
            fileArray.j();
            fileArray.i.set(true);
        }
    }

    private static /* synthetic */ File e(File a2) {
        return a2;
    }

    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        Object a2 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(RocksDBIndexKey.e((Object)"+&\u0007i\u0011(\u001ci\u001d'\u001e0R*\u0000,\u0013=\u0017i\u0013'R \u001c-\u00171R/\u0000&\u001fi\u0006!\u0017i\";\u001b$\u0013;\u000b\u0003\u0007$\u0002\u001a\u0019 \u0002\u0000\u001c-\u00171?(\u001c(\u0015,\u0000"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> e(FileVersion fileVersion, File file) {
        void a3;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        ReadOnlyJumpSkipIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.e((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).doOnNext(arg_0 -> a5.e((FileVersion)a4, arg_0)).flatMap(arg_0 -> a5.e((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.e((FileVersion)a4, arg_0)).doOnError(a2 -> a2.printStackTrace());
    }

    /*
     * WARNING - void declaration
     */
    protected Index j(FileVersion fileVersion2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            return readOnlyJumpSkipIndexManager.G.computeIfAbsent(a2, fileVersion -> {
                ReadOnlyJumpSkipIndexManager a2 = fileVersion;
                ReadOnlyJumpSkipIndexManager a3 = this;
                return new Index(a3, (FileVersion)a2);
            }).e();
        }
        catch (IndexNotFoundException a3) {
            readOnlyJumpSkipIndexManager.G.remove(a2);
            throw a3;
        }
    }

    MeterFactory.RateMeter e() {
        ReadOnlyJumpSkipIndexManager a2;
        return a2.f;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean e(long l2, long l3, IndexEntries indexEntries) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3;
        void a4;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntries;
        ReadOnlyJumpSkipIndexManager a5 = readOnlyJumpSkipIndexManager;
        if (a4 >= a3.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    protected void e() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager = this;
        while (readOnlyJumpSkipIndexManager2.G.size() > ((StorageProperties)readOnlyJumpSkipIndexManager.A.get()).getMaxIndexesInMemory()) {
            Map.Entry a2 = readOnlyJumpSkipIndexManager.G.pollFirstEntry();
            K.debug(SnapshotReader.e((Object)"35rh\u000b$';!&/h!&,-0h35"), (Object)readOnlyJumpSkipIndexManager.B, a2.getKey());
            readOnlyJumpSkipIndexManager.k = C.schedule(() -> ((Index)a2.getValue()).close(), 2L, TimeUnit.SECONDS);
            readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
        }
    }

    public boolean remove(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a22 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Index index = (Index)a3.G.remove(a22);
        if (index != null) {
            K.debug(SnapshotReader.e((Object)"\u000b$';-h!&,-0h35"), (Object)a22);
            index.close();
        }
        a3.b.remove(a22.e(), a22.e());
        if (K.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.hashCode();
            objectArray[1] = a22;
            objectArray[2] = a3.b.keySet();
            K.debug(RocksDBIndexKey.e((Object)"\t4Hi6,\u001e,\u0006,\u0016i\u0001,\u0015$\u0017'\u0006i\t4^i\u0000,\u001f(\u001b'\u001b'\u0015i\u0001,\u0015$\u0017'\u0006:R2\u000f"), objectArray);
        }
        File file = ((StorageProperties)a3.A.get()).newIndex(a3.D, (FileVersion)a22);
        long l2 = file.length();
        boolean a22 = FileUtils.e((File)file);
        if (a22) {
            a3.h.addAndGet(-l2);
        }
        return a22;
    }

    public long size() {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a2 = (ReadOnlyJumpSkipIndexManager)readOnlyJumpSkipIndexManager.c.get();
        if (a2 != null) {
            return readOnlyJumpSkipIndexManager.h.get() + a2.size();
        }
        return readOnlyJumpSkipIndexManager.h.get();
    }

    private /* synthetic */ File e(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.A.get()).newIndex(a3.D, (FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = fileVersion;
        ReadOnlyJumpSkipIndexManager a4 = this;
        if (a4.b.containsKey(a3.e())) {
            return a4.e((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.c.get();
        if (indexManager != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.B;
            objectArray[1] = a3.e();
            objectArray[2] = a3.e();
            K.debug(SnapshotReader.e((Object)"35rh)+<!>)<-h35h.':h35h!&h&-0<h<!-:"), objectArray);
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l2, long l3) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        try {
            void a2;
            void a3;
            ReadOnlyJumpSkipIndexManager a4;
            long a5;
            long l4 = a5 = a5;
            while (l4 >= (Long)readOnlyJumpSkipIndexManager.b.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a4 = readOnlyJumpSkipIndexManager2.e(a5);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.j((FileVersion)a4).e((String)a3);
                if (jumpSkipIndexEntries == null) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = readOnlyJumpSkipIndexManager.B;
                    objectArray[1] = a3;
                    objectArray[2] = a4;
                    K.debug(RocksDBIndexKey.e((Object)"2\u000fsR,\u001c=\u0000 \u0017:R/\u001d;R2\u000fi\u001c&\u0006i\u0014&\u0007'\u0016i\u001b'R:\u0017.\u001f,\u001c=R2\u000f"), objectArray);
                    return null;
                }
                if (jumpSkipIndexEntries.firstSequenceNumber() < a2) {
                    JumpSkipIndexEntries jumpSkipIndexEntries2 = jumpSkipIndexEntries;
                    return new SegmentIndexEntries((FileVersion)a4, jumpSkipIndexEntries2.range(jumpSkipIndexEntries2.firstSequenceNumber(), (long)a2, EventType.D.equals((Object)readOnlyJumpSkipIndexManager.l)));
                }
                l4 = jumpSkipIndexEntries.e();
            }
            a4 = (IndexManager)readOnlyJumpSkipIndexManager.c.get();
            if (a4 == null) return null;
            return a4.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, a5);
        }
        catch (IndexNotFoundException a5) {
            K.debug(SnapshotReader.e((Object)"35rh!&,-0h&'<h.'=&,"), (Object)readOnlyJumpSkipIndexManager.B, (Object)a5);
        }
        return null;
    }

    public void addExistingIndex(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.b.put(a2.e(), a2.e());
        a3.j();
    }

    private /* synthetic */ boolean e(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return ((StorageProperties)a3.A.get()).dataFile(a3.D, (FileVersion)a2).exists();
    }

    /*
     * WARNING - void declaration
     */
    public ReadOnlyJumpSkipIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        ReadOnlyJumpSkipIndexManager a7;
        Object a8 = string;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = a7 = this;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = a7;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager3 = a7;
        a7.G = new ConcurrentSkipListMap();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager4 = a7;
        readOnlyJumpSkipIndexManager3.b = new ConcurrentSkipListMap(Comparator.reverseOrder());
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager5 = a7;
        a7.j = new AtomicLong();
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager6 = a7;
        a7.i = new AtomicBoolean(false);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager7 = a7;
        a7.h = new AtomicLong();
        readOnlyJumpSkipIndexManager2.B = a8;
        readOnlyJumpSkipIndexManager2.A = a6;
        readOnlyJumpSkipIndexManager.D = a5;
        readOnlyJumpSkipIndexManager.l = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a8;
        stringArray[2] = "type";
        stringArray[3] = a4.name();
        a8 = Tags.of((String[])stringArray);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager8 = a7;
        readOnlyJumpSkipIndexManager8.f = a3.rateMeter((MetricName)BaseMetricName.J, (Tags)a8);
        readOnlyJumpSkipIndexManager8.d = a3.rateMeter((MetricName)BaseMetricName.aa, (Tags)a8);
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager9 = a7;
        readOnlyJumpSkipIndexManager9.c = a2;
        readOnlyJumpSkipIndexManager9.E = ((StorageProperties)a6.get()).getNewIndexSuffix();
        C.scheduleAtFixedRate(() -> a7.e(), 10L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void j(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        Object a222 = map;
        ReadOnlyJumpSkipIndexManager a3 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a3.B;
        objectArray[1] = a3.l;
        objectArray[2] = a2;
        K.info(RocksDBIndexKey.e((Object)"2\u000fsR*\u0000,\u0013=\u0017i\t4R \u001c-\u00171R/\u001d;R2\u000f"), objectArray);
        StorageProperties storageProperties = (StorageProperties)a3.A.get();
        Object object = a222 == null ? Collections.emptyMap() : a222;
        a222 = a3.e((FileVersion)a2, (Map)object);
        object = storageProperties.newIndex(a3.D, (FileVersion)a2);
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(((File)a222).toPath(), ((File)object).toPath(), copyOptionArray);
            a3.h.addAndGet(((File)object).length());
            a3.b.put(a2.e(), a2.e());
            return;
        }
        catch (IOException a222) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a3.D, (FileVersion)a2), (Throwable)a222);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono e(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        Object a3 = ((StorageProperties)readOnlyJumpSkipIndexManager.A.get()).newTransformedIndex(readOnlyJumpSkipIndexManager.D, (FileVersion)a2);
        return readOnlyJumpSkipIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void e(Index index, HTreeMap hTreeMap, String string, List list) {
        void a2;
        int n;
        void a3;
        List a4 = list;
        Index a5 = index;
        JumpSkipIndexEntries jumpSkipIndexEntries = a5.e((String)a3);
        IndexEntry indexEntry = (IndexEntry)a4.get(0);
        Integer[] integerArray = new Integer[a4.size()];
        int n2 = n = 0;
        while (n2 < a4.size()) {
            int n3 = n++;
            integerArray[n3] = ((IndexEntry)a4.get(n3)).e();
            n2 = n;
        }
        a2.put((Object)a3, (Object)new JumpSkipIndexEntries(jumpSkipIndexEntries.e(), indexEntry.j(), integerArray));
    }

    private /* synthetic */ void e(FileVersion fileVersion, Void void_) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        a3.b.put(a2.e(), a2.e());
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        ReadOnlyJumpSkipIndexManager a3 = this;
        return Mono.defer(() -> a3.e((FileVersion)a2));
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l2, long l3, long l4, long l5) {
        Object a2 = string;
        ReadOnlyJumpSkipIndexManager a3 = this;
        throw new UnsupportedOperationException(SnapshotReader.e((Object)"\u00078-:)<!'&h'&$1h;=88':<-,h'&h8:!%):1h!&,-0h%)&)/-:"));
    }

    /*
     * WARNING - void declaration
     */
    public boolean validIndex(FileVersion fileVersion) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        boolean a3 = false;
        try {
            StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.A.get();
            a3 = storageProperties.newIndex(readOnlyJumpSkipIndexManager.D, (FileVersion)a2).exists();
            return a3;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = readOnlyJumpSkipIndexManager.B;
            objectArray[1] = a2;
            objectArray[2] = exception;
            K.warn(RocksDBIndexKey.e((Object)"2\u000fsR\u000f\u0013 \u001e,\u0016i\u0006&R?\u0013%\u001b-\u0013=\u0017i\u001b'\u0016,\ni\u0014&\u0000i\u0001,\u0015$\u0017'\u0006sR2\u000f"), objectArray);
            return a3;
        }
    }

    public void addToActiveSegment(long l2, String string, IndexEntry indexEntry) {
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = readOnlyJumpSkipIndexManager2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = indexEntry;
        ReadOnlyJumpSkipIndexManager a2 = readOnlyJumpSkipIndexManager;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ File e(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return a2.newIndex(a4.D, new FileVersion(((Long)a3.getKey()).longValue(), ((Integer)a3.getValue()).intValue()));
    }

    public void complete(FileVersion fileVersion) {
        ReadOnlyJumpSkipIndexManager a2 = fileVersion;
        fileVersion = this;
    }

    private static /* synthetic */ Mono e(File file, File file2, File file3) {
        File a2 = file2;
        File a3 = file;
        return FileUtils.e((File)a3, (File)a2);
    }

    /*
     * Exception decompiling
     */
    protected void e(File var1_2, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l2) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)readOnlyJumpSkipIndexManager.A.get();
        Integer n = (Integer)readOnlyJumpSkipIndexManager.b.remove((long)a2);
        if (n != null) {
            int a3;
            int n2 = a3 = 0;
            while (n2 < n) {
                FileVersion fileVersion = new FileVersion((long)a2, a3);
                if (storageProperties.newIndex(readOnlyJumpSkipIndexManager.D, fileVersion).exists()) {
                    readOnlyJumpSkipIndexManager.remove(fileVersion);
                }
                n2 = ++a3;
            }
            return readOnlyJumpSkipIndexManager.remove(new FileVersion((long)a2, n.intValue()));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        readOnlyJumpSkipIndexManager.G.forEach((fileVersion, index) -> {
            FileVersion a2 = index;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        readOnlyJumpSkipIndexManager.G.clear();
        if (a2 != false) {
            readOnlyJumpSkipIndexManager.b.keySet().forEach(arg_0 -> readOnlyJumpSkipIndexManager.removeAllVersions(arg_0));
        }
        if (readOnlyJumpSkipIndexManager.k != null && !readOnlyJumpSkipIndexManager.k.isDone()) {
            readOnlyJumpSkipIndexManager.k.cancel(true);
        }
        try {
            ReadOnlyJumpSkipIndexManager a3 = (IndexManager)readOnlyJumpSkipIndexManager.c.get();
            if (a3 != null) {
                a3.cleanup((boolean)a2);
                return;
            }
        }
        catch (Exception a3) {
            K.info(SnapshotReader.e((Object)"35rh\u000b$-)&=8h'.h!&,-0h.)!$-,"), (Object)readOnlyJumpSkipIndexManager.B, (Object)a3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(File file, File file2) {
        void a2;
        File a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.B;
        objectArray[1] = a3.getAbsolutePath();
        objectArray[2] = a2.getAbsolutePath();
        K.debug(RocksDBIndexKey.e((Object)"\t4Hi ,\u001c(\u001f \u001c.R=\u001a,R=\u0017$\u0002&\u0000(\u00000R \u001c-\u00171R2\u000fi\u0006&R2\u000f"), objectArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l2, long l3, long l4, long l5, long l6) {
        void a2;
        long a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        try {
            void a4;
            void a5;
            void a6;
            ReadOnlyJumpSkipIndexManager a7;
            void a8;
            while (a3 >= a8 && a3 >= (Long)readOnlyJumpSkipIndexManager.b.lastKey()) {
                ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager2 = readOnlyJumpSkipIndexManager;
                a7 = readOnlyJumpSkipIndexManager2.e(a3);
                JumpSkipIndexEntries jumpSkipIndexEntries = readOnlyJumpSkipIndexManager2.j((FileVersion)a7).e((String)a2);
                if (jumpSkipIndexEntries != null) {
                    IndexEntries indexEntries = jumpSkipIndexEntries.range((long)a6, (long)a5, EventType.D.equals((Object)readOnlyJumpSkipIndexManager.l));
                    if (!indexEntries.isEmpty()) {
                        treeMap.put((FileVersion)a7, indexEntries);
                        if (readOnlyJumpSkipIndexManager.e((long)a6, (long)(a4 -= (long)indexEntries.size()), (IndexEntries)jumpSkipIndexEntries)) {
                            return treeMap;
                        }
                    }
                    if (jumpSkipIndexEntries.e() >= a7.e()) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = readOnlyJumpSkipIndexManager.B;
                        objectArray[1] = readOnlyJumpSkipIndexManager.l;
                        objectArray[2] = a2;
                        objectArray[3] = a7;
                        throw new MessagingPlatformException(ErrorCode.INDEX_READ_ERROR, String.format(RocksDBIndexKey.e((Object)"W:Hi;'\u0004(\u001e \u0016i\u001b'\u0016,\ni\u0017'\u0006;\u000bi\u0014&\u0000iW:Rl\u0001i\u001b'R:\u0017.\u001f,\u001c=Rl\u0001eR%\u001b'\u0019:R=\u001di\u001c,\u0005,\u0000i\u0006&\u0019,\u001c"), objectArray));
                    }
                    a3 = jumpSkipIndexEntries.e();
                    continue;
                }
                Object[] objectArray = new Object[3];
                objectArray[0] = readOnlyJumpSkipIndexManager.B;
                objectArray[1] = a2;
                objectArray[2] = a7;
                K.warn(SnapshotReader.e((Object)"35rh!&>)$!,h8:->!'=;h<'#-&h? !$-h:-),!&/h->-&<;h.':h35dh)//:-/)<-h&'<h.'=&,h!&h;-/%-&<h35dh+'&<!&=-h!&h8:->!'=;h;-/%-&<"), objectArray);
                a3 = a7.e() - 1L;
            }
            a7 = (IndexManager)readOnlyJumpSkipIndexManager.c.get();
            if (a7 == null) return treeMap;
            treeMap.putAll(((IndexManager)readOnlyJumpSkipIndexManager.c.get()).lookupAggregateInClosedSegments((String)a2, (long)a6, (long)a5, (long)a4, (long)a8, a3));
            return treeMap;
        }
        catch (IndexNotFoundException a7) {
            Object[] objectArray = new Object[4];
            objectArray[0] = readOnlyJumpSkipIndexManager.B;
            objectArray[1] = a2;
            objectArray[2] = a3;
            objectArray[3] = readOnlyJumpSkipIndexManager.b;
            K.warn(RocksDBIndexKey.e((Object)"2\u000fsR,\u0000;\u001d;R;\u0017(\u0016 \u001c.R,\u0004,\u001c=\u0001i\u0014&\u0000i\t4^i\u0002;\u0017?\u001b&\u0007:R=\u001d\"\u0017'R2\u000feR \u001c-\u00171\u0017:R2\u000f"), objectArray);
        }
        return treeMap;
    }

    /*
     * WARNING - void declaration
     */
    public void e(FileVersion fileVersion, Map<String, JumpSkipIndexEntries> map) {
        void a2;
        ReadOnlyJumpSkipIndexManager a3 = this;
        ReadOnlyJumpSkipIndexManager a4 = fileVersion;
        if (a3.e((FileVersion)a4)) {
            a3.j((FileVersion)a4, (Map)a2);
            return;
        }
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = (ReadOnlyJumpSkipIndexManager)a3.c.get();
        if (readOnlyJumpSkipIndexManager != null) {
            readOnlyJumpSkipIndexManager.e((FileVersion)a4, (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l2, int n) {
        void a2;
        void a3;
        ReadOnlyJumpSkipIndexManager readOnlyJumpSkipIndexManager = this;
        ReadOnlyJumpSkipIndexManager a4 = (StorageProperties)readOnlyJumpSkipIndexManager.A.get();
        return readOnlyJumpSkipIndexManager.b.entrySet().stream().filter(arg_0 -> ReadOnlyJumpSkipIndexManager.e((long)a3, (int)a2, arg_0)).map(arg_0 -> readOnlyJumpSkipIndexManager.e((StorageProperties)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono e(File file, File file2) {
        void a2;
        Object a3 = file2;
        ReadOnlyJumpSkipIndexManager a4 = this;
        return Mono.fromSupplier(() -> ReadOnlyJumpSkipIndexManager.e((File)a2)).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).doOnNext(arg_0 -> a4.e((File)a3, arg_0)).flatMap(arg_0 -> ReadOnlyJumpSkipIndexManager.e((File)a2, (File)a3, arg_0));
    }
}

