/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.query.result;

import com.fasterxml.jackson.annotation.JsonValue;
import io.axoniq.axonserver.localstorage.query.ExpressionResult;
import io.axoniq.axonserver.localstorage.query.result.StringExpressionResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class NumericExpressionResult
implements ExpressionResult {
    private final BigDecimal f;

    public NumericExpressionResult(BigDecimal bigDecimal) {
        Object a2 = bigDecimal;
        NumericExpressionResult a3 = this;
        a3.f = a2;
    }

    public ExpressionResult divide(ExpressionResult expressionResult) {
        NumericExpressionResult a2 = expressionResult;
        NumericExpressionResult a3 = this;
        if (a2 instanceof NumericExpressionResult) {
            return new NumericExpressionResult(a3.f.divide(a2.f, RoundingMode.HALF_UP));
        }
        throw new IllegalArgumentException("Invalid second parameter for divide: " + a2.getClass().getSimpleName());
    }

    public boolean isNonNull() {
        NumericExpressionResult a2;
        if (a2.f != null) {
            return true;
        }
        return false;
    }

    public boolean isNumeric() {
        return true;
    }

    public boolean equals(Object object) {
        NumericExpressionResult a2 = this;
        Object a3 = object;
        if (a2 == a3) {
            return true;
        }
        if (!(a3 instanceof ExpressionResult)) {
            return false;
        }
        a3 = (ExpressionResult)a3;
        return Objects.equals(a2.f, a3.getValue());
    }

    public int hashCode() {
        NumericExpressionResult a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = a2.f;
        return Objects.hash(objectArray);
    }

    public ExpressionResult subtract(ExpressionResult expressionResult) {
        NumericExpressionResult a2 = expressionResult;
        NumericExpressionResult a3 = this;
        if (a2 instanceof NumericExpressionResult) {
            return new NumericExpressionResult(a3.f.subtract(a2.f));
        }
        throw new IllegalArgumentException("Invalid second parameter for subtract: " + a2.getClass().getSimpleName());
    }

    public int e(@NotNull ExpressionResult expressionResult) {
        NumericExpressionResult numericExpressionResult = numericExpressionResult2;
        NumericExpressionResult numericExpressionResult2 = expressionResult;
        NumericExpressionResult a2 = numericExpressionResult;
        if (a2.f == null) {
            if (numericExpressionResult2.isNonNull()) {
                return -1;
            }
            return 0;
        }
        if (numericExpressionResult2 instanceof NumericExpressionResult) {
            return Double.compare(a2.f.doubleValue(), numericExpressionResult2.f.doubleValue());
        }
        if (numericExpressionResult2 instanceof StringExpressionResult) {
            return String.valueOf(a2.f).compareTo(String.valueOf(numericExpressionResult2.getValue()));
        }
        return 0;
    }

    public String toString() {
        NumericExpressionResult a2;
        return String.valueOf(a2.f);
    }

    public NumericExpressionResult(String string) {
        Object a2 = string;
        NumericExpressionResult a3 = this;
        a3(new BigDecimal((String)a2));
    }

    @JsonValue
    public Object getValue() {
        NumericExpressionResult a2;
        return a2.f;
    }

    public ExpressionResult multiply(ExpressionResult expressionResult) {
        NumericExpressionResult a2 = expressionResult;
        NumericExpressionResult a3 = this;
        if (a2 instanceof NumericExpressionResult) {
            return new NumericExpressionResult(a3.f.multiply(a2.f));
        }
        throw new IllegalArgumentException("Invalid second parameter for multiply: " + a2.getClass().getSimpleName());
    }

    public boolean isNull() {
        NumericExpressionResult a2;
        if (a2.f == null) {
            return true;
        }
        return false;
    }

    public ExpressionResult modulo(ExpressionResult expressionResult) {
        NumericExpressionResult a2 = expressionResult;
        NumericExpressionResult a3 = this;
        if (a2 instanceof NumericExpressionResult) {
            return new NumericExpressionResult(a3.f.longValue() % a2.getNumericValue().longValue());
        }
        throw new IllegalArgumentException("Invalid second parameter for modulo: " + a2.getClass().getSimpleName());
    }

    public NumericExpressionResult(double a2) {
        a3(BigDecimal.valueOf(a2));
        NumericExpressionResult a3;
    }

    public NumericExpressionResult(long a2) {
        a3(new BigDecimal(a2));
        NumericExpressionResult a3;
    }

    public ExpressionResult add(ExpressionResult expressionResult) {
        NumericExpressionResult a2 = expressionResult;
        NumericExpressionResult a3 = this;
        if (a2 instanceof NumericExpressionResult) {
            return new NumericExpressionResult(a3.f.add(a2.f));
        }
        throw new IllegalArgumentException("Invalid second parameter for add: " + a2.getClass().getSimpleName());
    }
}

