/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.logging.E;
import io.axoniq.axonserver.message.ContextClusterMetrics;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger f = AuditLog.getLogger();

    @EventListener
    public void on(AbstractAuthenticationEvent abstractAuthenticationEvent) {
        AuditLog a2 = abstractAuthenticationEvent;
        AuditLog a3 = this;
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (f.isDebugEnabled()) {
            f.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            f.info(RaftConfigServiceFactory.e((Object)"!?\n9\u0003p\u001a9\u00198M%\u001e5\u001f>\f=\bpO+\u0010rC"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            f.error(ContextClusterMetrics.e((Object)"\u0000\u001d+\u001b\"R;\u001b8\u001al\u0007?\u0017>\u001c-\u001f)Rn\t1Pl4\r;\u00007\bHl\t1"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return ContextClusterMetrics.e((Object)"p\u0013\"\u001d\"\u000b!\u001d9\u0001r");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted adminUserDeleted) {
        AuditLog a2 = adminUserDeleted;
        AuditLog a3 = this;
        if (f.isDebugEnabled()) {
            f.debug(a2.toString());
        }
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated adminUserUpdated) {
        AuditLog a2 = adminUserUpdated;
        AuditLog a3 = this;
        if (f.isDebugEnabled()) {
            f.debug(a2.toString());
        }
    }

    public static String username(String a2) {
        if (a2 == null) {
            return RaftConfigServiceFactory.e((Object)"Q1\u0003?\u0003)\u0000?\u0018#S");
        }
        return StringUtils.sanitize((String)a2);
    }

    public AuditLog() {
        AuditLog a2;
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + E.f.e()[2].getName()));
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return RaftConfigServiceFactory.e((Object)"(\u001e,\u0012!\u0015)");
        }
        return ContextClusterMetrics.e((Object)"6\u0005!\r0\u00007\b");
    }
}

