/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.localstorage.file.multitier.MultiTierInformationProvider;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.transport.rest.v2.SubscriptionQueriesRestControllerV2;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final QueryRegistrationCache l;
    private final Map<String, AtomicInteger> C;
    private final NonReplacingConstraintCache<String, ActiveQuery> k;
    private final DispatchQueueMetrics c;
    private final FlowControlQueues<QueryInstruction> j;
    private final QueryMetricsRegistry D;
    private final Logger M;
    private final QueryInterceptors f;

    /*
     * WARNING - void declaration
     */
    public void handleResponse(QueryResponse queryResponse, String string, String string2) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = a3.getRequestIdentifier();
        if ((a4 = queryDispatcher.e((String)a2, (String)a4)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a4.d(), (String)a2);
            long l2 = System.currentTimeMillis() - a4.e();
            if (a4.e()) {
                void a5;
                queryDispatcher.D.addEndToEndResponseTime(a4.e(), a4.e(), (String)a5, clientStreamIdentification.j(), a4.j(), l2);
            }
            if (a4.e((QueryResponse)a3, (String)a2) && a4.j()) {
                a4.e((String)a2);
                return;
            }
        } else {
            queryDispatcher.M.debug(SubscriptionQueriesRestControllerV2.e((Object)"PJ>\rsJl@7\u0005wKxJlH\u007fQwJp\u0005xJl\u0005eX"), (Object)a3.getRequestIdentifier());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void flowControl(String string, long l2) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.k.get(a2)) != null) {
            void a4;
            a2.e().forEach(arg_0 -> a3.e((ActiveQuery)a2, (long)a4, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, ActiveQuery activeQuery) {
        void a2;
        QueryDispatcher queryDispatcher = this;
        try {
            queryDispatcher.M.trace(SubscriptionQueriesRestControllerV2.e((Object)"awVnDjFvLpB>Tk@l\\>^c\u000b0\u000b"), (Object)a2.j());
            a2.j();
            return;
        }
        catch (MessagingPlatformException a3) {
            void a4;
            QueryDispatcher queryDispatcher2 = queryDispatcher;
            queryDispatcher2.M.debug(MultiTierInformationProvider.e((Object)"B;u&uic<u i.'-n:w(s*o i.'&aiv<b;~i|4)iD(i*b%k i.'>n=oib;u&ug"), (Object)a2.j(), (Object)a3);
            a2.e(a3.getErrorCode(), a3.getMessage());
            queryDispatcher2.k.remove((Object)a4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String e(String string, String string2) {
        void a2;
        Object a3 = string2;
        QueryDispatcher a4 = this;
        return (String)a2 + "/" + (String)a3;
    }

    public MeterFactory.RateMeter queryRate(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        return a3.D.rateMeter((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(DefaultExecutionContext defaultExecutionContext, Consumer consumer, QueryResponse queryResponse) {
        void a2;
        void a3;
        QueryDispatcher a4 = queryResponse;
        QueryDispatcher a5 = this;
        a5.e((DefaultExecutionContext)a3, (QueryResponse)a4, (Consumer)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(Consumer consumer, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryDispatcher a5 = this;
        a3.accept(a4);
        ((AtomicInteger)a5.C.get(a2)).decrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    public void cancelProxied(String string, String string2) {
        void a2;
        QueryDispatcher a3;
        Object a4 = string2;
        QueryDispatcher queryDispatcher = a3 = this;
        queryDispatcher.cancel(queryDispatcher.e((String)a2, (String)a4));
    }

    /*
     * WARNING - void declaration
     */
    public void query(SerializedQuery serializedQuery, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        Consumer<String> a3;
        Consumer<QueryResponse> a4;
        void a5;
        QueryDispatcher queryDispatcher = this;
        Object a6 = a5.context();
        a4 = arg_0 -> queryDispatcher.e(a4, (SerializedQuery)a5, (String)a6, arg_0);
        a3 = arg_0 -> queryDispatcher.e(a3, (String)a6, arg_0);
        QueryDispatcher queryDispatcher2 = queryDispatcher;
        queryDispatcher2.queryRate((String)a6).e();
        queryDispatcher2.C.computeIfAbsent(a6, string -> {
            void a2;
            QueryDispatcher queryDispatcher = this;
            Object a3 = new AtomicInteger();
            queryDispatcher.D.gauge((MetricName)BaseMetricName.Ca, Tags.of((String)"context", (String)a2), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        queryDispatcher.e((SerializedQuery)a5, (String)a6, (Authentication)a2, a4, a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ActiveQuery e(String string, String string2) {
        Object a2 = string2;
        QueryDispatcher a3 = this;
        ActiveQuery activeQuery = (ActiveQuery)a3.k.get(a2);
        if (activeQuery == null) {
            void a4;
            a2 = (String)a2 + "/" + (String)a4;
            activeQuery = (ActiveQuery)a3.k.get(a2);
        }
        return activeQuery;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(SerializedQuery serializedQuery, String string, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        Set set;
        QueryDispatcher a2;
        QueryDispatcher queryDispatcher;
        block5: {
            void a3;
            SerializedQuery serializedQuery2;
            void a4;
            Consumer<QueryResponse> consumer3;
            void a5;
            block4: {
                DefaultExecutionContext a6;
                void a7;
                queryDispatcher = this;
                a6 = new DefaultExecutionContext((String)a7, (Authentication)a6);
                consumer3 = arg_0 -> queryDispatcher.e(a6, (Consumer)a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher2 = queryDispatcher;
                    serializedQuery2 = queryDispatcher2.f.queryRequest((SerializedQuery)a4, (ExecutionContext)a6);
                    a2 = serializedQuery2.query();
                    set = queryDispatcher2.e((String)a7, (QueryRequest)a2);
                    if (!set.isEmpty()) break block4;
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.e((String)("No handler for query: " + a2.getQuery()))).build());
                    a3.accept(MultiTierInformationProvider.e((Object)"I&D%n,i="));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a7;
                    objectArray[1] = a4.query().getQuery();
                    objectArray[2] = exception;
                    queryDispatcher.M.warn(SubscriptionQueriesRestControllerV2.e((Object)"^c\u001f>C\u007fLr@z\u0005jJ>AwVnDjFv\u0005oP{Wg\u0005eX"), objectArray);
                    a2 = ErrorCode.fromException((Throwable)exception);
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(a2.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.e((String)StringUtils.getOrDefault((String)a2.getCode(), (String)exception.getClass().getName()))).build());
                    a3.accept(MultiTierInformationProvider.e((Object)"A(n%b-"));
                    a6.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(a2.getMessageIdentifier(), serializedQuery2, true, consumer3, (Consumer)a3, set, queryDispatcher.e((QueryRequest)a2));
            if (queryDispatcher.k.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.e((String)SubscriptionQueriesRestControllerV2.e((Object)"OP{Wg\u0005iLjM>VkUnIw@z\u0005Wa>DrW{Dz\\>Ul@m@pQ"))).build());
            a3.accept(MultiTierInformationProvider.e((Object)"\rr9k d(s,N-"));
            return;
        }
        queryDispatcher.e(a2.getMessageIdentifier(), (ActiveQuery)set);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(ActiveQuery activeQuery, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        QueryDispatcher a4 = activeQuery;
        QueryDispatcher a5 = this;
        a5.e((QueryHandler)a3, a4.j(), a4.c(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(DefaultExecutionContext defaultExecutionContext, QueryResponse queryResponse, Consumer<QueryResponse> consumer) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher queryDispatcher = this;
        try {
            a4.accept(queryDispatcher.f.queryResponse((QueryResponse)a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception a5) {
            queryDispatcher.M.warn(SubscriptionQueriesRestControllerV2.e((Object)"^c\u001f>`fF{UjLqK>Lp\u0005l@mUqKm@>LpQ{W}@nQqW"), (Object)a2.contextName(), (Object)a5);
            Exception exception = a5;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.e((String)exception.getMessage())).build());
            a2.compensate((Throwable)exception);
            return;
        }
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.j;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void j(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryHandler a5 = queryHandler;
        a5.e((String)a3, (String)a4, (long)a2);
    }

    public void deleteMetrics(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        a3.C.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.D.remove((MetricName)BaseMetricName.Ca, (String)a2);
        queryDispatcher.D.removeForContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Set<QueryHandler> e(String string, QueryRequest queryRequest) {
        void a2;
        QueryHandler queryHandler;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = ProcessingInstructionHelper.e((List)a3.getProcessingInstructionsList()) == 1 ? ((queryHandler = queryDispatcher.l.findOne((String)a2, (QueryRequest)a3)) == null ? Set.of() : Set.of(queryHandler)) : queryDispatcher.l.find((String)a2, (QueryRequest)a3);
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, String string2, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryHandler;
        QueryDispatcher a6 = queryDispatcher;
        a6.e((QueryHandler)a5, (String)a4, (String)a3, (long)a2);
    }

    private /* synthetic */ boolean e(QueryRequest queryRequest) {
        QueryDispatcher a2 = queryRequest;
        QueryDispatcher a3 = this;
        return ProcessingInstructionHelper.e((List)a2.getProcessingInstructionsList());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(Consumer consumer, SerializedQuery serializedQuery, String string, QueryResponse queryResponse) {
        void a2;
        QueryDispatcher a3;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryResponse;
        QueryDispatcher a4 = queryDispatcher;
        QueryDispatcher queryDispatcher3 = a3;
        a2.accept(queryDispatcher3);
        if (a4.e((QueryResponse)queryDispatcher3)) {
            void a5;
            void a6;
            a4.D.error(a6.query().getQuery(), (String)a5, a3.getErrorCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2, boolean bl) {
        void a22;
        void a3;
        void a4;
        void a322;
        QueryDispatcher queryDispatcher = this;
        void v0 = a322;
        QueryRequest queryRequest = v0.query();
        String string = v0.context();
        Object a5 = v0.clientStreamId();
        if ((string = queryDispatcher.l.find(string, queryRequest, (String)a5)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a5;
            objectArray[1] = queryRequest.getQuery();
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.e((String)String.format(MultiTierInformationProvider.e((Object)"D%n,i='ltii&sia&r'cip!n%biw;h*b:t i.=i\":"), objectArray))).build());
            a3.accept(a5);
            return;
        }
        a5 = queryDispatcher.e(queryRequest.getMessageIdentifier(), a322.clientStreamId());
        ActiveQuery a22 = new ActiveQuery((String)a5, (SerializedQuery)a322, false, (Consumer)a4, (Consumer)a3, Collections.singleton(string), a22 != false && queryDispatcher.e(queryRequest));
        try {
            if (queryDispatcher.k.putIfAbsent(a5, (Object)a22) != null) {
                a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a322.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.e((String)SubscriptionQueriesRestControllerV2.e((Object)"OP{Wg\u0005iLjM>VkUnIw@z\u0005Wa>DrW{Dz\\>Ul@m@pQ"))).build());
                a3.accept(MultiTierInformationProvider.e((Object)"\rr9k d(s,N-"));
                return;
            }
            queryDispatcher.e((String)a5, a22);
            return;
        }
        catch (InsufficientBufferCapacityException a322) {
            a22.e(string.c(), ErrorCode.QUERY_DISPATCH_ERROR, a322.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void completeWithError(String string, String string2, ErrorCode errorCode, String string3) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        QueryDispatcher a6 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = a5;
        objectArray[2] = a3.getCode();
        objectArray[3] = a2;
        a6.M.debug(SubscriptionQueriesRestControllerV2.e((Object)"fqHnI{QwKy\u0005iLjM>@lWqW>Qv@>FqHsPpL}DjLqK>RwQv\u0005\u007f\u0005mU{FwCwF>M\u007fKzI{W>~}Iw@pQMQl@\u007fHWA#^cx2\u0005xJl\u0005jM{\u0005oP{Wg\u0005ELz\u0018eXC\u000b>`lWqW>FqA{\u001f>^c\u000b>`lWqWS@mV\u007fB{\u001f>^c\u000b"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.k.get(a5);
        if (activeQuery != null && activeQuery.e((String)a4, (ErrorCode)a3, (String)a2)) {
            a6.k.remove(a5);
        }
    }

    private /* synthetic */ boolean e(QueryResponse queryResponse) {
        QueryDispatcher a2 = queryResponse;
        QueryDispatcher a3 = this;
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5 = queryHandler;
        QueryDispatcher a6 = this;
        void v0 = a4;
        a6.e((String)v0, a5.c(), () -> QueryDispatcher.j((QueryHandler)a5, (String)v0, (String)a3, (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    public void flowControlProxied(String string, String string2, long l2, String string3, String string4) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string2;
        QueryDispatcher a7 = this;
        a7.e((String)a5, (String)a6, (String)a4, arg_0 -> a7.e((String)a3, (String)a6, (long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, String string2, String string3, Consumer<QueryHandler> consumer) {
        void a2;
        void a3;
        Object a4 = string;
        QueryDispatcher a5 = this;
        a4 = new QueryDefinition((String)a4, (String)a3);
        if ((a4 = a5.l.find((QueryDefinition)a4, (String)a2)) != null) {
            void a6;
            a6.accept(a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        void a3;
        Object a4 = consumer2;
        QueryDispatcher a5 = this;
        a5.dispatchProxied((SerializedQuery)a3, (Consumer)a2, (Consumer)a4, true);
    }

    /*
     * WARNING - void declaration
     */
    public QueryDispatcher(QueryRegistrationCache queryRegistrationCache, NonReplacingConstraintCache<String, ActiveQuery> nonReplacingConstraintCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int n) {
        void a2;
        void clientIdRegistry2;
        void meterFactory2;
        void queryInterceptors2;
        void queryCache;
        void registrationCache;
        QueryDispatcher queryMetricsRegistry2;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryMetricsRegistry;
        QueryDispatcher queryDispatcher3 = queryMetricsRegistry2 = queryDispatcher;
        QueryDispatcher queryDispatcher4 = queryMetricsRegistry2;
        queryMetricsRegistry2.M = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher5 = queryMetricsRegistry2;
        queryMetricsRegistry2.C = new ConcurrentHashMap();
        queryDispatcher4.l = registrationCache;
        queryDispatcher4.D = queryDispatcher2;
        queryDispatcher3.k = queryCache;
        queryDispatcher3.f = queryInterceptors2;
        QueryDispatcher queryDispatcher6 = queryMetricsRegistry2;
        queryDispatcher3.c = new DispatchQueueMetrics((MeterFactory)meterFactory2, (MetricName)BaseMetricName.W, (MetricName)BaseMetricName.ea, (ClientIdRegistry)clientIdRegistry2);
        QueryDispatcher queryDispatcher7 = queryMetricsRegistry2;
        queryDispatcher6.j = new FlowControlQueues(Comparator.comparing(QueryInstruction::e).reversed(), (int)a2, (QueueMetrics)queryMetricsRegistry2.c, ErrorCode.TOO_MANY_REQUESTS);
        queryDispatcher2.gauge((MetricName)BaseMetricName.Ma, (Object)queryCache, ConstraintCache::size);
    }

    /*
     * WARNING - void declaration
     */
    public void handleComplete(String string, String string2, String string3) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher a4 = queryDispatcher.e((String)a3, (String)a2);
        if (a4 != null) {
            if (a4.j((String)a3)) {
                queryDispatcher.k.remove((Object)a4.j());
            }
            long l2 = System.currentTimeMillis() - a4.e();
            if (a4.e()) {
                void a5;
                queryDispatcher.D.addHandlerResponseTime(a4.e(), a4.e(), (String)a5, a4.d(), l2);
                return;
            }
        } else {
            queryDispatcher.M.debug(MultiTierInformationProvider.e((Object)"\u0007hi/$h;b`' i/h;j(s h''/h;'2zih''*h$w%b=b-"), (Object)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(String string, String string2, Runnable runnable) {
        Runnable a22 = runnable;
        QueryDispatcher a3 = this;
        try {
            a22.run();
            return;
        }
        catch (MessagingPlatformException a22) {
            void a4;
            void a5;
            QueryDispatcher queryDispatcher = a3;
            queryDispatcher.M.debug(SubscriptionQueriesRestControllerV2.e((Object)"[WlJl\u0005zLmU\u007fQ}MwKy\u0005xIqR>Tk@l\\>LpVjWkFjLqK>Qq\u0005jDlB{Q>FrL{Kj\u0005eX"), (Object)a5);
            queryDispatcher.completeWithError((String)a4, (String)a5, a22.getErrorCode(), a22.getMessage());
            return;
        }
    }

    public void cancel(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.k.remove(a2)) != null) {
            a2.e();
        }
    }
}

