/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.AxonServerEnterpriseConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ApplicationEventPublisher B;
    public static final String A = "_none";
    private final Predicate<String> L;
    private final RaftConfigServiceFactory l;
    private final ClusterTopology C;
    private final ClusterTemplateController k;
    private final ClusterController c;
    private final FeatureChecker j;
    private static final Logger D = AuditLog.getLogger();
    private static final Logger M = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DistributeLicenseService f;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void e(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        D.info(AxonServerEnterpriseConfiguration.e((Object)"xz^\\\u0003SFpVdPu\u0003mJbFoPd\u0003tSeBuF/"), (Object)AuditLog.username((Principal)a2));
        M.info(MessageJson.e((Object)"z\u0005C@X\tW\u0005Z\u0013Q@A\u0010X\u000fU\u0004Q\u0004\u0018@D\u0005F\u0006[\u0012Y\tZ\u0007\u0014\f]\u0003Q\u000eG\u0005\u0014\u0015D\u0004U\u0014QN\u001aN"));
        try {
            void licenseFile;
            clusterRestController.f.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, AxonServerEnterpriseConfiguration.e((Object)"OL!OdBeFs\u0003gLs\u0003^BeNhM/\u0003DMrVsF!WiBu\u0003uKd\u0003^BeNhM!QdSmJbBuJnM!DsLtS!Jr\u0003bQdBuFe\u0003cFgLsF!VqOnBeJoD!B!Oh@dMrF/"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @GetMapping
    public List<JsonClusterNode> e(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        D.info(AxonServerEnterpriseConfiguration.e((Object)"ZX|~!qdRtFrW!Wn\u0003mJrW!MnGdP/"), (Object)AuditLog.username((Principal)object));
        return a2.c.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.c.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    @PostMapping
    public ResponseEntity<RestResponse> e(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        D.info(AxonServerEnterpriseConfiguration.e((Object)"xz^\\\u0003SFpVdPu\u0003uL!InJo\u0003bOtPuFs\u0003`W!X|\u0019z^/"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.c.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, MessageJson.e((Object)"#U\u000eZ\u000f@@W\u000fY\u0002]\u000eQ@^\u000f]\u000e]\u000eS@W\u000fZ\u0014Q\u0018@@C\t@\b\u0014\u000e[#[\u000e@\u0005L\u0014GN"));
            }
            if (!RaftAdminGroup.e((String)string) && !jsonClusterNode.L.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            M.debug(AxonServerEnterpriseConfiguration.e((Object)"BeG)\n;\u0003SFfJrWdQhMf\u0003lZrFmE!BoG!BeGhMf\u0003lF!Wn\u0003bLoWd[u\u0003#X|\u0001/"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            M.debug(MessageJson.e((Object)"\u0001P\u0004\u001cI\u000e@f\u0005S\tG\u0014Q\u0012]\u000eS@Y\u0019G\u0005X\u0006\u0014\u0001Z\u0004\u0014\u0001P\u0004]\u000eS@Y\u0005\u0014\u0014[@Z\u000f\u0014\u0003[\u000e@\u0005L\u0014GN"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            M.debug(AxonServerEnterpriseConfiguration.e((Object)"BeG)\n;\u0003SFfJrWdQhMf\u0003lZrFmE!BoG!BeGhMf\u0003lF!Wn\u0003`Om\u0003bLoWd[uP/"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.c.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, MessageJson.e((Object)"z\u000fP\u0005\u0014\u0001X\u0012Q\u0001P\u0019\u0014\u0012Q\u0007]\u0013@\u0005F\u0005P@]\u000e\u0014\u0001\u0014\u0003X\u0015G\u0014Q\u0012")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.l.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.B.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, AxonServerEnterpriseConfiguration.e((Object)"bb@dSuFe\u0003kLhM!QdRtFrW-\u0003lBx\u0003uBjF!B!TiJmF!Wn\u0003qQn@dPr")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.L = new ContextNameValidation();
        a9.c = a8;
        clusterRestController5.l = a7;
        clusterRestController5.j = a6;
        clusterRestController4.f = a5;
        clusterRestController4.B = a4;
        clusterRestController3.C = a3;
        clusterRestController3.k = a2;
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode e(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        D.info(MessageJson.e((Object)";O\u001di@f\u0005E\u0015Q\u0013@@Z\u000fP\u0005\u0014\u0004Q\u0014U\tX\u0013\u0014\u0006[\u0012\u0014\u001bIN"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.c.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.c.isActive((String)object));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void e(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        D.info(MessageJson.e((Object)";O\u001di@f\u0005E\u0015Q\u0013@@@\u000f\u0014\u0004Q\fQ\u0014Q@Z\u000fP\u0005\u0014\u001bIN"), (Object)AuditLog.username((Principal)a2), object);
        name.l.getRaftConfigService().deleteNode((String)object);
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void e(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        D.info(MessageJson.e((Object)";O\u001di@f\u0005E\u0015Q\u0013@@W\fA\u0013@\u0005F@@\u0005Y\u0010X\u0001@\u0005\u0014\u0004[\u0017Z\f[\u0001PN"), (Object)AuditLog.username((Principal)object));
        if (a2.C.isAdminNode()) {
            ServletOutputStream resp;
            object = AxonServerEnterpriseConfiguration.e((Object)"@mVrWdQ,WdNqO`Wd\rxNm");
            String string = a2.k.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(MessageJson.e((Object)"\u0014Q\u0018@OD\fU\tZ[\u0014\u0003\\\u0001F\u0013Q\u0014\t\u0015@\u0006\u0019X"));
            v1.addHeader(AxonServerEnterpriseConfiguration.e((Object)"BLoWdMu\u000eEJrSnPhWhLo"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(MessageJson.e((Object)"9[\u0015\u0014\u0003U\u000e\u0014\u0015G\u0005\u0014\u0014\\\tG@R\u0015Z\u0003@\t[\u000eU\f]\u0014M@[\u000eX\u0019\u0014\u0006F\u000fY@U\u0004Y\tZ@Z\u000fP\u0005"));
    }
}

