/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.AggregateReader;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private static final Logger k = AuditLog.getLogger();
    private final PluginController c;
    public static final String j = "Plugins disabled";
    private final FeatureChecker D;
    private final Logger M;
    private final boolean f;

    @GetMapping
    public Iterable<PluginInfo> e(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        k.info(AggregateReader.e((Object)">Q\u0018wEx\u0000[\u0010O\u0016^E^\n\n\tC\u0016^EI\u0010X\u0017O\u000b^EZ\t_\u0002C\u000bYK\n"), (Object)AuditLog.username((Principal)object));
        return a2.c.listPlugins();
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey e(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.f || !a2.D.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, j);
            }
            k.info(AggregateReader.e((Object)"q\u001eW8\n7O\u0014_\u0000Y\u0011\n\u0011EEC\u000bY\u0011K\tFEZ\t_\u0002C\u000b\n\u001eWK\n"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.e(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.c.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.M = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.f = a3.isPluginsEnabled();
        pluginsRestController.c = a2;
        pluginsRestController.D = a5;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void e(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        k.info(ProcessorEventPublisher.e((Object)"s,U\n\b\u0005M&]2[#\b#Gw]9A9[#I;DwX;]0A9\b,UxS*\u0006w"), objectArray);
        version.c.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void e(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.f || !active.D.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, j);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? ProcessorEventPublisher.e((Object)"$\\6Z#") : AggregateReader.e((Object)"\u0016^\nZ");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        k.info(AggregateReader.e((Object)"q\u001eW8\n7O\u0014_\u0000Y\u0011\n\u0011EEQ\u0018\n\u0015F\u0010M\fDEQ\u0018\u0005\u001eWK\n"), objectArray);
        active.c.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> e(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.f || !pluginsRestController.D.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, j);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        k.info(AggregateReader.e((Object)"q\u001eW8\n7O\u0014_\u0000Y\u0011\n\u0003E\u0017\n\u0006E\u000bL\fM\u0010X\u0004^\fE\u000b\n\nLEQ\u0018\u0005\u001eWK\n"), objectArray);
        try {
            void context;
            return pluginsRestController.c.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.M.warn(ProcessorEventPublisher.e((Object)"\u0011I>D2Lw\\8\b%M#Z>M!MwX%G'M%\\>M$\b1G%\b,UmS*"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void e(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.f || !context.D.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, j);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        k.info(ProcessorEventPublisher.e((Object)"\fS*uwz2Y\"M$\\w\\8\b\"F%M0A$\\2ZwX;]0A9\b,UxS*\b1G%\b4G9\\2P#\b,Uy"), objectArray);
        context.c.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    private /* synthetic */ String e(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ProcessorEventPublisher.e((Object)"f8\b'D\"O>FwX6K<I0MwX%G!A3M3"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, AggregateReader.e((Object)"l\fF\u0000D\u0004G\u0000\n\u0016B\n_\tNED\n^EI\nD\u0011K\fDEN\fX\u0000I\u0011E\u0017SEY\u0000Z\u0004X\u0004^\nX"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void e(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.f || !configurationJSON.D.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, j);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        k.info(ProcessorEventPublisher.e((Object)"\fS*uwz2Y\"M$\\w\\8\b\"X3I#MwK8F1A0]%I#A8FwG1\b,UxS*\u0006w"), objectArray);
        configurationJSON.c.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }
}

