/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.taskscheduler;

import io.axoniq.axonserver.configuration.runtime.Task;
import io.axoniq.axonserver.configuration.runtime.Tasks;
import io.axoniq.axonserver.enterprise.context.RequestReconnectController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.TaskStatus;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.taskscheduler.ScheduledTaskExecutor;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.websocket.ClusterUpdatesListener;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseTaskManager
implements SmartLifecycle {
    protected static final Logger I;
    protected final Predicate<String> E;
    protected final Map<String, Map<String, ScheduledFuture<?>>> i;
    protected final Tasks h;
    private static final String b = "replicationGroup";
    protected final AtomicLong d;
    protected static final long G;
    private final MeterFactory K;
    private boolean B;
    private static final String A = "true";
    private final Map<String, Gauge> L;
    protected final Clock l;
    private final long C;
    protected final ScheduledExecutorService k;
    private static final String c = "false";
    protected final PlatformTransactionManager j;
    private static final String D = "transient";
    protected final Supplier<Set<String>> M;
    protected final ScheduledTaskExecutor f;

    protected abstract CompletableFuture<Void> processResult(String var1, String var2, TaskStatus var3, long var4, long var6, String var8);

    private /* synthetic */ Number j(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.e((String)a2);
    }

    private /* synthetic */ void j(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.e((Task)a2);
    }

    protected void saveAndSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.L.computeIfAbsent(a2.getReplicationGroup(), string -> {
            Object a2 = string;
            BaseTaskManager a3 = this;
            return a3.K.gauge((MetricName)BaseMetricName.A, Tags.of((String)b, (String)a2), () -> a3.j((String)a2));
        });
        new TransactionTemplate(a3.j).execute(arg_0 -> a3.e((Task)a2, arg_0));
        I.debug(ClusterUpdatesListener.e((Object)"R_\u0013\u0002}CZI\tQJJLF\\NLF\tYT"), (Object)a2.getReplicationGroup(), (Object)a2.getTaskId());
        a3.doScheduleTask((Task)a2);
    }

    protected boolean isTransient(Throwable throwable) {
        Throwable a2 = throwable;
        BaseTaskManager a3 = this;
        if (a2 == null) {
            return false;
        }
        if (a2 instanceof TransientException) {
            return true;
        }
        return a3.isTransient(a2.getCause());
    }

    /*
     * WARNING - void declaration
     */
    public BaseTaskManager(ScheduledTaskExecutor scheduledTaskExecutor, Tasks tasks, Supplier<Set<String>> supplier, Predicate<String> predicate, PlatformTransactionManager platformTransactionManager, @Qualifier(value="taskScheduler") ScheduledExecutorService scheduledExecutorService, MeterFactory meterFactory, Clock clock) {
        void meterFactory2;
        void scheduler;
        void platformTransactionManager2;
        void raftLeaderTest;
        void leaderForGroupProvider;
        void taskRepository;
        void taskExecutor;
        BaseTaskManager a2;
        BaseTaskManager baseTaskManager = object;
        Object object = clock;
        BaseTaskManager baseTaskManager2 = a2 = baseTaskManager;
        BaseTaskManager baseTaskManager3 = a2;
        BaseTaskManager baseTaskManager4 = a2;
        BaseTaskManager baseTaskManager5 = a2;
        BaseTaskManager baseTaskManager6 = a2;
        BaseTaskManager baseTaskManager7 = a2;
        a2.i = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager8 = a2;
        baseTaskManager7.L = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager9 = a2;
        baseTaskManager6.d = new AtomicLong();
        baseTaskManager6.C = Duration.ofMinutes(5L).toMillis();
        baseTaskManager5.f = taskExecutor;
        baseTaskManager5.h = taskRepository;
        baseTaskManager4.M = leaderForGroupProvider;
        baseTaskManager4.E = raftLeaderTest;
        baseTaskManager3.j = platformTransactionManager2;
        baseTaskManager3.k = scheduler;
        baseTaskManager2.K = meterFactory2;
        baseTaskManager2.l = object;
    }

    /*
     * WARNING - void declaration
     */
    protected void error(Task task, Throwable throwable) {
        CompletableFuture completableFuture;
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        if (a4.isTransient((Throwable)a2)) {
            BaseTaskManager baseTaskManager;
            BaseTaskManager baseTaskManager2 = a3;
            long l2 = Math.min(baseTaskManager2.getRetryInterval() * 2L, G);
            if (baseTaskManager2.getRetryInterval() < G) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getPayload().getType();
                objectArray[2] = l2;
                I.info(ClusterUpdatesListener.e((Object)"YT\u0018\tdHKEGM\u0002]M\tGQGJW]G\tVHQB\u0002\u000eYT\u0005\u0007\u0002\tpLV[[@LN\u0002@L\tYT\u0002DQ\u0007\f\u0007"), objectArray);
                baseTaskManager = a4;
            } else {
                Object[] objectArray = new Object[5];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getTaskId();
                objectArray[2] = a3.getTaskExecutor();
                objectArray[3] = a2.getMessage();
                objectArray[4] = l2;
                I.warn(RequestReconnectController.e((Object)"q50hL)c$o,*<eho0o+\u007f<oh~)y#*3wr*3wh'hq5$hX-~:s!d/*!dhq5*%yf$f"), objectArray);
                baseTaskManager = a4;
            }
            CompletableFuture completableFuture2 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.SCHEDULED, a4.newSchedule((Task)a3), l2, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = b;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = D;
            stringArray[5] = A;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            a4.K.counter((MetricName)BaseMetricName.z, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture2;
        } else {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2;
            I.warn(ClusterUpdatesListener.e((Object)"R_\u0013\u0002oC@NLF\tVF\u0002LZLA\\VL\u0002]CZI\tYT\u0018\tYT"), objectArray);
            BaseTaskManager baseTaskManager = a4;
            CompletableFuture completableFuture3 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.FAILED, a4.l.millis(), 0L, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = b;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = D;
            stringArray[5] = c;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            baseTaskManager.K.counter((MetricName)BaseMetricName.z, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture3;
        }
        completableFuture.exceptionally(arg_0 -> BaseTaskManager.j((Task)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void c(Task task, Throwable throwable) {
        void a2;
        Object a3 = throwable;
        BaseTaskManager a4 = this;
        a4.error((Task)a2, (Throwable)a3);
        return null;
    }

    public void start() {
        BaseTaskManager a2;
        a2.B = true;
        a2.e();
    }

    public boolean isRunning() {
        BaseTaskManager a2;
        return a2.B;
    }

    private /* synthetic */ void e(Task task) {
        BaseTaskManager a2;
        BaseTaskManager a3 = task;
        BaseTaskManager baseTaskManager = a2 = this;
        long l2 = baseTaskManager.l.millis();
        baseTaskManager.i.getOrDefault(a3.getReplicationGroup(), Collections.emptyMap()).remove(a3.getTaskId());
        if (I.isDebugEnabled()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2.l.millis() - a3.getTimestamp();
            I.debug(RequestReconnectController.e((Object)"q50hO0o+\u007f<oh~)y#*3wr*3whz$k&d-nho0o+\u007f<c'dhq5g;*)m'"), objectArray);
        }
        try {
            ((CompletableFuture)a2.f.executeTask((Task)a3).thenAccept(arg_0 -> a2.e((Task)a3, l2, arg_0))).exceptionally(arg_0 -> a2.c((Task)a3, arg_0));
            return;
        }
        catch (Exception exception) {
            a2.error((Task)a3, (Throwable)exception);
            return;
        }
    }

    protected void schedule(Task task) {
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.i.computeIfAbsent(a3.getReplicationGroup(), a2 -> new ConcurrentHashMap()).computeIfAbsent(a3.getTaskId(), arg_0 -> a4.e((Task)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(Task task, long l2, Void void_) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.completed((Task)a3, (long)a2);
    }

    private /* synthetic */ ScheduledFuture e(Task task, String string) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.k.schedule(() -> a3.j((Task)a2), a3.e((Task)a2), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    protected void unschedule(String string, String string2) {
        void a2;
        Object a3 = string;
        BaseTaskManager a4 = this;
        if ((a3 = (ScheduledFuture)a4.i.getOrDefault(a3, Collections.emptyMap()).remove(a2)) != null) {
            a3.cancel(false);
        }
    }

    protected long newSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.l.millis() + Math.min(a2.getRetryInterval(), G);
    }

    static {
        G = TimeUnit.MINUTES.toMillis(1L);
        I = LoggerFactory.getLogger(BaseTaskManager.class);
    }

    private static /* synthetic */ Void j(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        I.warn(ClusterUpdatesListener.e((Object)"YT\u0018\tdHKEGM\u0002]M\tR[MJGZQ\tPLQ\\N]\u0002OM[\u0002]CZI\tYT\u0018\tYT"), objectArray);
        return null;
    }

    private /* synthetic */ Task e(Task task, TransactionStatus transactionStatus) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.h.save((Task)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected void completed(Task task, long l2) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.COMPLETED, a4.l.millis(), 0L, null).exceptionally(arg_0 -> BaseTaskManager.e((Task)a3, arg_0));
        String[] stringArray = new String[4];
        stringArray[0] = b;
        stringArray[1] = a3.getReplicationGroup();
        stringArray[2] = "request";
        stringArray[3] = a3.getTaskExecutor();
        a4.K.timer((MetricName)BaseMetricName.za, Tags.of((String[])stringArray)).record(a4.l.millis() - a2, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        BaseTaskManager a2;
        a2.B = false;
        I.info(ClusterUpdatesListener.e((Object)"q]MY\u0002}CZIdCGCNG["));
        a2.k.shutdown();
    }

    protected String asString(Throwable throwable) {
        Object a2 = throwable;
        BaseTaskManager a3 = this;
        return MessagingPlatformException.create((Throwable)a2).getMessage();
    }

    private /* synthetic */ long e(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a2.getTimestamp() - a3.l.millis();
    }

    private /* synthetic */ Number e(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.h.countByContext((String)a2);
    }

    private static /* synthetic */ Void e(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        I.warn(RequestReconnectController.e((Object)"q50hL)c$o,*<ehz:e+o;yhx-y=f<*.e:*+e%z$o<o,*<k;ahq50hq5"), objectArray);
        return null;
    }

    protected void doScheduleTask(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        if (a3.E.test(a2.getReplicationGroup()) && a2.getTimestamp() < a3.d.get() && TaskStatus.SCHEDULED.equals((Object)a2.getStatus())) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTimestamp();
            objectArray[2] = a3.d;
            I.debug(RequestReconnectController.e((Object)"q50hk,n!d/*<k;ah~'*;i o,\u007f$o:*<c%ohq5**o.e:ohq5"), objectArray);
            a3.schedule((Task)a2);
        }
    }

    private /* synthetic */ void e() {
        BaseTaskManager a2;
        I.debug(RequestReconnectController.e((Object)"\u0001d!~hl-~+b\u001ck;a\u001a\u007f&d-xd*?c&n'}h7hq5"), (Object)a2.C);
        a2.k.scheduleWithFixedDelay(() -> {
            BaseTaskManager a2;
            if (!a2.B) {
                return;
            }
            try {
                BaseTaskManager baseTaskManager = a2;
                long l2 = baseTaskManager.d.getAndSet(baseTaskManager.l.millis() + a2.C);
                ((Set)baseTaskManager.M.get()).forEach(string -> {
                    void a2;
                    void a3;
                    BaseTaskManager baseTaskManager = this;
                    List a4 = baseTaskManager.h.findScheduled((String)a3, (long)a2, baseTaskManager.d.get());
                    Object[] objectArray = new Object[4];
                    objectArray[0] = a3;
                    objectArray[1] = a4.size();
                    objectArray[2] = (long)a2;
                    objectArray[3] = baseTaskManager.d.get();
                    I.debug(RequestReconnectController.e((Object)"3wr*;i o,\u007f$c&mhq5*<k;a;**o<}-o&*3whk&nhq5"), objectArray);
                    a4.forEach(arg_0 -> baseTaskManager.schedule(arg_0));
                });
                return;
            }
            catch (Exception exception) {
                I.warn(ClusterUpdatesListener.e((Object)"gQALR]KFL\tDLVJJ@LN\u0002ZAAGMWEGM\u0002]CZIZ\u000e\tU@NE\u0002]PP\u0002HEHKG\u0002EC]G["), (Throwable)exception);
                return;
            }
        }, 0L, a2.C, TimeUnit.MILLISECONDS);
    }
}

