/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.NodeTool;
import io.axoniq.tools.http.json.ClusterNode;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class Cluster {
    private Cluster() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void run(String[] args) throws Throwable {
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.TOKEN});
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        if (AxonIQCliUtil.jsonOutput((CommandLine)commandLine)) {
            ToolResult result = NodeTool.listNodesRaw((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.println((String)result.getSuccessValue());
            return;
        } else {
            ToolResult result = NodeTool.listNodes((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.printf("%-40s %-40s %10s %10s %s%n", "Name", "Hostname", "gRPC Port", "HTTP Port", "Connected");
            ((List)result.getSuccessValue()).stream().sorted(Comparator.comparing(ClusterNode::getName)).forEach(node -> System.out.printf("%-40s %-40s %10d %10d %s%n", node.getName(), node.getHostName(), node.getGrpcPort(), node.getHttpPort(), node.isConnected() ? "*" : ""));
        }
    }
}

