/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.config.AxonServerEnterpriseConfiguration;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.grpc.GrpcFlowControlledDispatcherListener;
import io.axoniq.axonserver.version.VersionInfoProvider;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableAsync
@EnableScheduling
public class AxonServer {
    private final VersionInfoProvider K;
    private static final Logger I = LoggerFactory.getLogger(AxonServer.class);

    public AxonServer(VersionInfoProvider versionInfoProvider) {
        AxonServer a2 = versionInfoProvider;
        AxonServer a3 = this;
        a3.K = a2;
    }

    @Bean
    public LogReplicationService logReplicationService(GrpcRaftController grpcRaftController) {
        AxonServer a2 = grpcRaftController;
        AxonServer a3 = this;
        return new LogReplicationService((RaftGroupManager)a2);
    }

    @PreDestroy
    public void D() {
        GrpcFlowControlledDispatcherListener.shutdown();
    }

    @PostConstruct
    public void l() {
        AxonServer axonServer = this;
        AxonServer a2 = axonServer.K.get();
        if (a2 != null) {
            I.info(AxonServerEnterpriseConfiguration.l((Object)"kc0hulcw\u007fp0em"), (Object)a2.getProductName(), (Object)a2.getVersion());
        }
    }

    public static void main(String[] a2) {
        System.setProperty(ProcessorEventPublisher.l((Object)"\u001be\u001a|\u0006rFv\u0007{\u000e|\u000f;\u0006t\u0005p"), "axonserver");
        SpringApplication.run(AxonServer.class, (String[])a2);
    }

    @Bean
    public LeaderElectionService leaderElectionService(GrpcRaftController grpcRaftController) {
        AxonServer a2 = grpcRaftController;
        AxonServer a3 = this;
        return new LeaderElectionService((RaftGroupManager)a2);
    }
}

