/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import db.callback.CleanupRepairs;
import db.callback.MigrateControlDB;
import db.callback.SeMigration;
import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.component.instance.Clients;
import io.axoniq.axonserver.config.ClusterTemplate;
import io.axoniq.axonserver.config.F;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.HealthBasedNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.MatchingTagsNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.NodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.SubscriptionCountBasedNodeSelectionStrategy;
import io.axoniq.axonserver.enterprise.cluster.internal.ClusterHealth;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.DefaultInstructionAckSource;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.command.CommandProviderInbound;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.localstorage.DefaultEventDecorator;
import io.axoniq.axonserver.localstorage.EventDecorator;
import io.axoniq.axonserver.localstorage.transformation.DefaultEventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.replication.ReplicationGroupProvider;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.flywaydb.core.api.callback.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
public class AxonServerStandardConfiguration {
    private final Logger I = LoggerFactory.getLogger(AxonServerStandardConfiguration.class);

    @Bean
    @Qualifier(value="commandInstructionAckSource")
    public InstructionAckSource<SerializedCommandProviderInbound> commandInstructionAckSource() {
        return new DefaultInstructionAckSource(a2 -> new SerializedCommandProviderInbound(CommandProviderInbound.newBuilder().setAck(a2).build()));
    }

    @Bean
    public FlywayConfigurationCustomizer flywayConfigurationCustomizer() {
        return a2 -> {
            Callback[] callbackArray = new Callback[3];
            callbackArray[0] = new CleanupRepairs();
            callbackArray[1] = new SeMigration();
            callbackArray[2] = new MigrateControlDB();
            a2.callbacks(callbackArray);
        };
    }

    @Bean
    @Qualifier(value="queryInstructionAckSource")
    public InstructionAckSource<QueryProviderInbound> queryInstructionAckSource() {
        return new DefaultInstructionAckSource(a2 -> QueryProviderInbound.newBuilder().setAck(a2).build());
    }

    @Bean
    public FlywayMigrationStrategy cleanMigrateStrategy() {
        return a2 -> {
            a2.repair();
            a2.migrate();
        };
    }

    @Bean
    public DiskSpaceHealthIndicator diskSpaceHealthIndicator() {
        return null;
    }

    @Bean
    @ConditionalOnMissingBean(value={EventDecorator.class})
    public EventDecorator eventDecorator() {
        return new DefaultEventDecorator();
    }

    @Bean
    @Qualifier(value="platformInstructionAckSource")
    public InstructionAckSource<PlatformOutboundInstruction> platformInstructionAckSource() {
        return new DefaultInstructionAckSource(a2 -> PlatformOutboundInstruction.newBuilder().setAck(a2).build());
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @Qualifier(value="taskScheduler")
    public ScheduledExecutorService scheduler() {
        return Executors.newScheduledThreadPool(10, (ThreadFactory)new DaemonThreadFactory(ClusterTemplate.l((Object)"8~?tal/w){9s)m")));
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public NodeSelectionStrategy nodeSelectionStrategy(CommandRegistrationCache commandRegistrationCache, QueryRegistrationCache queryRegistrationCache, ClientIdRegistry clientIdRegistry, Clients clients, MessagingPlatformConfiguration messagingPlatformConfiguration, ClusterTagsCache clusterTagsCache, FeatureChecker featureChecker, ClusterHealth clusterHealth, ReplicationGroupProvider replicationGroupProvider) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        AxonServerStandardConfiguration a10 = commandRegistrationCache;
        AxonServerStandardConfiguration a11 = this;
        a10 = new SubscriptionCountBasedNodeSelectionStrategy((CommandRegistrationCache)a10, (QueryRegistrationCache)a9, (ClientIdRegistry)a8, (Clients)a7, (MessagingPlatformConfiguration)a6);
        a10 = new MatchingTagsNodeSelectionStrategy((ClusterTagsCache)a5, (MessagingPlatformConfiguration)a6, (FeatureChecker)a4, (NodeSelectionStrategy)a10);
        return new HealthBasedNodeSelectionStrategy((ClusterHealth)a3, arg_0 -> ((ReplicationGroupProvider)a2).replicationGroup(arg_0), (NodeSelectionStrategy)a10, a6.getName());
    }

    @Bean
    @ConditionalOnMissingBean(value={EventTransformerFactory.class})
    public EventTransformerFactory eventTransformerFactory() {
        return new DefaultEventTransformerFactory();
    }

    @Bean
    public ApplicationEventMulticaster applicationEventMulticaster() {
        AxonServerStandardConfiguration a2;
        return new F(a2);
    }

    public AxonServerStandardConfiguration() {
        AxonServerStandardConfiguration a2;
    }

    @Bean
    public Clock clock() {
        return Clock.systemUTC();
    }
}

