/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.admin.application.api.SegmentStatus;
import io.axoniq.axonserver.config.B;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.HealthStatus;
import io.axoniq.axonserver.config.MaintenanceExecutors;
import io.axoniq.axonserver.exception.InsufficientDiskSpaceException;
import io.axoniq.axonserver.message.ContextClusterMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.system.DiskSpaceMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.system.DiskSpaceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.context.annotation.Configuration;

@Configuration(value="diskSpace")
public class FileSystemMonitor
extends DiskSpaceHealthIndicator {
    private final MeterRegistry f;
    private final Logger l;
    public static final String C = "ROOT";
    private final Map<Path, B> K;
    private final Map<Path, Path> I;

    private /* synthetic */ long l(Path path) {
        Object a22 = path;
        FileSystemMonitor a3 = this;
        try {
            a22 = Files.getFileStore((Path)a22);
            return a22.getUsableSpace();
        }
        catch (IOException a22) {
            throw new RuntimeException(a22);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerPath(String string, Path path, long l, long l2) {
        void a2;
        void a3;
        void a4;
        FileSystemMonitor a5;
        Object a6 = path;
        FileSystemMonitor fileSystemMonitor = a5 = this;
        fileSystemMonitor.l.info(ContextClusterMetrics.l((Object)"\u0019m:k m&k:etd=n1\"'v;p1\"sy)%tc \"$c jt%/\u007fs"), (Object)a4, a6);
        fileSystemMonitor.l((String)a4, (Path)a6, (long)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ B l(long l, long l2, Path path) {
        void a2;
        void a3;
        Object a4;
        FileSystemMonitor fileSystemMonitor = object;
        Object object = path;
        FileSystemMonitor a5 = fileSystemMonitor;
        a5.l((Path)a4);
        return new B(Collections.emptySet(), a5.l((Path)a4), System.currentTimeMillis(), (long)a3, (long)a2);
    }

    public void unregisterPath(String string) {
        FileSystemMonitor a2;
        Object a3 = string;
        FileSystemMonitor fileSystemMonitor = a2 = this;
        fileSystemMonitor.l.info(SegmentStatus.l((Object)"#m\u001fi\u0000|\u00149\u001dv\u001ep\u0004v\u0002p\u001e~P\u007f\u0019u\u00159\u0003m\u001fk\u00159Wb\r>"), a3);
        fileSystemMonitor.K.entrySet().stream().filter(arg_0 -> FileSystemMonitor.l((String)a3, arg_0)).findFirst().ifPresent(arg_0 -> a2.l((String)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(String string, Path path, long l, long l2) {
        void a2;
        void a3;
        void a4;
        void a5;
        FileSystemMonitor fileSystemMonitor;
        FileSystemMonitor fileSystemMonitor2 = fileSystemMonitor = this;
        Object a6 = fileSystemMonitor2.l((Path)a5);
        B b2 = fileSystemMonitor2.K.computeIfAbsent(a6, arg_0 -> fileSystemMonitor.l((long)a4, (long)a3, arg_0));
        fileSystemMonitor.K.put(a6, b2.l((String)a2, (long)a4, (long)a3));
        fileSystemMonitor.I.put(a5, a6);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ B l(Path path, B b2, long l, Path path2, B b3) {
        void a2;
        void a3;
        void a4;
        FileSystemMonitor a5;
        FileSystemMonitor fileSystemMonitor = fileSystemMonitor2;
        FileSystemMonitor fileSystemMonitor2 = b3;
        FileSystemMonitor a6 = fileSystemMonitor;
        if (a5 == null) {
            return null;
        }
        long l2 = a6.l((Path)a4);
        if (l2 < a3.K) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = l2;
            objectArray[2] = a3.K;
            a6.l.error(ContextClusterMetrics.l((Object)"y)8td&g1\"'r5a1\"|y)+t`1n;uto=l=o!otd&g1\"'r5a1\"|y)+z"), objectArray);
        } else if (l2 < a3.l) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = l2;
            objectArray[2] = a3.l;
            a6.l.warn(SegmentStatus.l((Object)"\u000bdJ9\u0016k\u0015|Pj\u0000x\u0013|P1\u000bdY9\u0012|\u001cv\u00079\u0007x\u0002w\u0019w\u00179\u0004q\u0002|\u0003q\u001fu\u00149\u0016v\u00029\u0016k\u0015|Pj\u0000x\u0013|P1\u000bdY7"), objectArray);
        }
        return new B(a5.I, l2, (long)a2, a5.K, a5.l);
    }

    protected void doHealthCheck(Health.Builder builder) {
        FileSystemMonitor a2 = builder;
        FileSystemMonitor a3 = this;
        a2.up();
        a3.K.forEach((arg_0, arg_1) -> a3.l((Health.Builder)a2, arg_0, arg_1));
    }

    private static /* synthetic */ boolean l(String string, Map.Entry entry) {
        Map.Entry a2 = entry;
        String a3 = string;
        return ((B)a2.getValue()).I.contains(a3);
    }

    private /* synthetic */ Path l(Path path) {
        Path path2;
        Object a22 = path;
        FileSystemMonitor a3 = this;
        try {
            Path path3;
            Object object = a22;
            a22 = Files.getFileStore((Path)object);
            Path path4 = path2 = (path3 = object.toAbsolutePath());
            while ((path3 = path4.getParent()) != null && a22.equals(Files.getFileStore(path3))) {
                path4 = path3;
            }
        }
        catch (IOException a22) {
            throw new RuntimeException(a22);
        }
        return path2.normalize();
    }

    public List<Details> paths() {
        FileSystemMonitor a2;
        return a2.K.entrySet().stream().map(entry -> {
            Map.Entry entry2 = entry;
            try {
                FileStore a2 = Files.getFileStore((Path)entry2.getKey());
                return new Details(((Path)entry2.getKey()).toString(), ((Path)entry2.getKey()).toString(), a2.getUsableSpace(), a2.getTotalSpace(), ((B)entry2.getValue()).K, ((B)entry2.getValue()).l);
            }
            catch (IOException a2) {
                throw new RuntimeException(a2);
            }
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(String string, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        FileSystemMonitor a4 = this;
        a4.K.put((Path)a3.getKey(), ((B)a3.getValue()).l((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    public FileSystemMonitor(DiskSpaceHealthIndicatorProperties diskSpaceHealthIndicatorProperties, MaintenanceExecutors maintenanceExecutors, MeterRegistry meterRegistry) {
        void a2;
        void a3;
        FileSystemMonitor a4 = meterRegistry;
        FileSystemMonitor a5 = this;
        super(null, null);
        a5.l = LoggerFactory.getLogger(FileSystemMonitor.class);
        FileSystemMonitor fileSystemMonitor = a5;
        a5.K = new ConcurrentHashMap();
        FileSystemMonitor fileSystemMonitor2 = a5;
        fileSystemMonitor.I = new ConcurrentHashMap();
        a5.f = a4;
        long l = a3.getThreshold().toBytes();
        long l2 = l;
        a5.l(C, Paths.get("", new String[0]), l2, (long)((double)l2 * 1.25));
        a2.get().scheduleAtFixedRate(() -> {
            FileSystemMonitor a2;
            long l = System.currentTimeMillis();
            a2.K.forEach((path, b2) -> {
                void a2;
                FileSystemMonitor a3;
                FileSystemMonitor fileSystemMonitor = fileSystemMonitor2;
                FileSystemMonitor fileSystemMonitor2 = b2;
                FileSystemMonitor a4 = fileSystemMonitor;
                if (a3.C < a3.l || a2 - a3.f > 60000L) {
                    void a5;
                    void v1 = a5;
                    a4.K.compute(v1, (arg_0, arg_1) -> a4.l((Path)v1, (B)a3, (long)a2, arg_0, arg_1));
                }
            });
        }, 15L, 15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(Health.Builder builder, Path path, B b2) {
        void a2;
        void a3;
        FileSystemMonitor a4 = b2;
        FileSystemMonitor a5 = this;
        try {
            FileStore fileStore = Files.getFileStore((Path)a3);
            long l = fileStore.getUsableSpace();
            if (l < a4.K) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = l;
                objectArray[2] = a4.K;
                a5.l.error(String.format(ContextClusterMetrics.l((Object)"D&g1\"0k'itq$c7gtc \"$c jt%qqs\"=qt`1n;utv<p1q<m8fz\"\u0015t5k8c6n18t'0\"6{ g'\"|v<p1q<m8fn\"qq}"), objectArray));
                a2.down();
            }
            if (l < a4.l) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = l;
                objectArray[2] = a4.l;
                a5.l.warn(String.format(SegmentStatus.l((Object)"6k\u0015|P}\u0019j\u001b9\u0003i\u0011z\u00159\u0011mPi\u0011m\u00189W<\u0003>Pp\u00039\u0012|\u001cv\u00079\u0007x\u0002w\u0019w\u00179\u0004q\u0002|\u0003q\u001fu\u00147PX\u0006x\u0019u\u0011{\u001c|J9U}P{\tm\u0015jP1\u0004q\u0002|\u0003q\u001fu\u0014#P<\u00030"), objectArray));
                a2.status(HealthStatus.I);
            }
            a2.withDetail(a3.toString(), (Object)new Details(a4.I.toString(), a3.toString(), fileStore.getUsableSpace(), fileStore.getTotalSpace(), a4.K, a4.l));
            return;
        }
        catch (Exception exception) {
            a5.l.error(ContextClusterMetrics.l((Object)"D5k8g0\" mtp1v&k1t1\"2k8gtq m&gtd;pty)"), (Object)a3, (Object)exception);
            a2.down();
            a2.withDetail(SegmentStatus.l((Object)"\u0000x\u0004q"), (Object)a3.toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkFreeSpace(Path path) {
        void a2;
        FileSystemMonitor fileSystemMonitor = this;
        Object a3 = (Path)fileSystemMonitor.I.get(a2);
        if ((a3 = (B)fileSystemMonitor.K.get(a3)) != null && a3.C < a3.K) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2;
            objectArray[1] = a3.C;
            objectArray[2] = a3.K;
            throw new InsufficientDiskSpaceException(String.format(SegmentStatus.l((Object)"<\u0003#PP\u001ej\u0005\u007f\u0016p\u0013p\u0015w\u00049\u0014p\u0003rPj\u0000x\u0013|Pm\u001f9\u0013v\u001di\u001c|\u0004|Pm\u0018|Pk\u0015h\u0005|\u0003mP1U}_<\u00140"), objectArray));
        }
    }

    private /* synthetic */ void l(Path path) {
        Object a22 = path;
        FileSystemMonitor a3 = this;
        try {
            a22 = new File(a22.toString());
            new DiskSpaceMetrics((File)a22).bindTo(a3.f);
            return;
        }
        catch (Exception a22) {
            a3.l.error(ContextClusterMetrics.l((Object)"D5k8g0\" mt`=l0\"0k'ito1v&k7qu"), (Throwable)a22);
            return;
        }
    }
}

