/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.configuration.admin.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.jpa.AdminReplicationGroupJpa;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@Entity(name="Context")
@Table(name="adm_context")
class AdminContextJpa
implements Serializable,
AdminContext {
    @Column(name="CHANGE_PENDING")
    private Boolean changePending;
    @ManyToOne
    @JoinColumn(name="replication_group_id")
    private AdminReplicationGroupJpa replicationGroup;
    @Column(name="PENDING_SINCE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date pendingSince;
    @Id
    private String name;
    @Column(name="META_DATA")
    @Lob
    private String metaData;

    public int hashCode() {
        AdminContextJpa a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = a2.name;
        return Objects.hash(objectArray);
    }

    public boolean equals(Object object) {
        Object a2 = this;
        Object a3 = object;
        if (a2 == a3) {
            return true;
        }
        if (a3 == null || a2.getClass() != a3.getClass()) {
            return false;
        }
        a3 = (AdminContextJpa)a3;
        return Objects.equals(a2.name, ((AdminContextJpa)a3).name);
    }

    public void setName(String string) {
        Object a2 = string;
        AdminContextJpa a3 = this;
        a3.name = a2;
    }

    public void setMetaData(String string) {
        Object a2 = string;
        AdminContextJpa a3 = this;
        a3.metaData = a2;
    }

    protected AdminContextJpa() {
        AdminContextJpa a2;
    }

    public String toString() {
        AdminContextJpa a2;
        return "Context{name='" + a2.name + "'}";
    }

    public String getMetaData() {
        AdminContextJpa a2;
        return a2.metaData;
    }

    public String getName() {
        AdminContextJpa a2;
        return a2.name;
    }

    public void changePending(Boolean bl) {
        Boolean a2 = bl;
        AdminContextJpa a3 = this;
        a3.changePending = a2;
        if (a3.changePending != null && a2.booleanValue()) {
            AdminContextJpa adminContextJpa = a3;
            adminContextJpa.pendingSince = new Date();
            return;
        }
        a3.pendingSince = null;
    }

    public Date getPendingSince() {
        AdminContextJpa a2;
        return a2.pendingSince;
    }

    public boolean isChangePending() {
        AdminContextJpa a2;
        if (a2.changePending != null && a2.changePending.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setReplicationGroup(AdminReplicationGroup adminReplicationGroup) {
        AdminContextJpa a2 = adminReplicationGroup;
        AdminContextJpa a3 = this;
        a3.replicationGroup = (AdminReplicationGroupJpa)a2;
    }

    public Map<String, String> getMetaDataMap() {
        AdminContextJpa adminContextJpa = this;
        if (adminContextJpa.metaData == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)new ObjectMapper().readValue(adminContextJpa.metaData, Map.class);
        }
        catch (IOException a2) {
            a2.printStackTrace();
            return Collections.emptyMap();
        }
    }

    AdminContextJpa(String string) {
        Object a2 = string;
        AdminContextJpa a3 = this;
        a3.name = a2;
    }

    public void setMetaDataMap(Map<String, String> map) {
        Object a22 = map;
        AdminContextJpa a3 = this;
        a3.metaData = null;
        try {
            a3.metaData = new ObjectMapper().writeValueAsString(a22);
            return;
        }
        catch (JsonProcessingException a22) {
            a22.printStackTrace();
            return;
        }
    }

    public AdminReplicationGroup getReplicationGroup() {
        AdminContextJpa a2;
        return a2.replicationGroup;
    }
}

