/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.ClusterTemplate;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.metric.Metrics;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final AdminNodes L;
    private final AdminConfigurationFactory H;
    private volatile boolean F;
    private final CurrentNodeProvider a;
    private final ApplicationEventPublisher e;
    private final Limits f;
    private final ClusterTagsCache l;
    private final RemoteConnections C;
    private final MessagingPlatformConfiguration K;
    private final Logger I;

    public int getPhase() {
        return 50;
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    private /* synthetic */ void l(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.L.deleteById((String)a2);
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.C.nodes();
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.C.disconnect((String)a2);
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.l(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.K.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.I.info(Metrics.l((Object)"\u0010D=_*QdB+\u0016.Y-XdA-B,\u0016'C6D!X0\u0016*Y SdX%[!\fdM9"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.K.getInternalHostname()) && a2.getGrpcInternalPort() == a3.K.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, ClusterTemplate.l((Object)"\u000f~\"q#klu#v\"?/s9l8z>?;v8wll-r)?$p?k\"~!zl~\"{lv\"k)m\"~ ?<p>k"));
        }
        ClusterNode clusterNode = a3.L.findById(a2.getNodeName()).orElseGet(() -> a3.l((NodeInfo)a2));
        if (!a3.C.contains(a2.getNodeName())) {
            a3.l((NodeInfo)a2);
        }
        return clusterNode;
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.F;
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.K.getName()) || a3.C.get(a2) != null && a3.C.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void l(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.C.contains((String)a2) || a3.K.getName().equals(a2)) {
            return;
        }
        a3.f.getMaxClusterSize().ifPresent(arg_0 -> a3.l((String)a2, arg_0));
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.e.publishEvent(a2);
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.a.isAdmin();
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.C.connections();
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.L.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.l.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.L.deleteAllByNameNot(clusterController.getName());
        clusterController.C.sync();
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.C.activeConnections();
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.C.get((String)a2));
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.l();
        a2.F = true;
    }

    private /* synthetic */ ClusterNode l(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.I.info(Metrics.l((Object)"\u0005R \u0016*Y SdM9"), (Object)a3);
        a3 = clusterController.H.clusterNode((NodeInfo)a3);
        return clusterController.L.save((ClusterNode)a3);
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.l((ClusterNode)clusterController.a.get());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.C.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.I.info(ClusterTemplate.l((Object)"[)s)k)?\"p(zv?7b"), a3);
        clusterController2.e.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.K.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.L.deleteAllByNameNot((String)a3);
            clusterController3.C.closeAll();
        } else {
            a2.L.findById((String)a3).ifPresent(arg_0 -> a2.l((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.e.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.C.sync();
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.I = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.K = messagingPlatformConfiguration2;
        clusterController6.L = clusterNodeRepository;
        clusterController5.H = adminConfigurationFactory2;
        clusterController5.l = clusterTagsCache2;
        clusterController4.e = applicationEventPublisher2;
        clusterController4.f = limits2;
        clusterController3.C = remoteConnections2;
        clusterController3.a = clusterController2;
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    private /* synthetic */ void l() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.L.findById(clusterController2.K.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.L.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.K.getName();
                a2 = String.format(Metrics.l((Object)"u1D6S*BdX+R!\u0016*W)Sd^%EdU,W*Q!Rh\u0016*S3\u0016*W)Sd\u00137\u0018de0W6Bdw<Y*e!D2S6\u00163_0^dD!U+@!D=\u0016\"_(Sj"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.H.clusterNode(clusterController3.K.getName(), clusterController.K.getFullyQualifiedHostname(), clusterController.K.getFullyQualifiedInternalHostname(), clusterController.K.getPort(), clusterController.K.getInternalPort(), clusterController.K.getHttpPort());
            clusterController3.L.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.K.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.K.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.K.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.K.getInternalPort();
            object = String.format(ClusterTemplate.l((Object)"\u000fj>m)q8?\"p(zkllv\"k)m\"~ ?$p?k\"~!zco#m8?d:?%i{e?$~??/w-q+z(3l?\"z;?:~ j)ll:?%i{b?\u001fk-m8?\rg#q\u001fz>i)mlh%k$?>z/p:z>fly%s)1"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    private /* synthetic */ void l(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.K.getName())) {
            return;
        }
        a3.C.connect((NodeInfo)a2, true);
    }

    public ClusterNode getNode(String string) {
        String a2 = string;
        Object a3 = this;
        if (a2.equals(a3.getName())) {
            return a3.getMe();
        }
        ClusterController clusterController = a3;
        return clusterController.l(clusterController.L.findById(a2).orElseGet(() -> {
            Object a2 = a2;
            ClusterController a3 = this;
            if ((a2 = a3.C.get((String)a2)) == null) {
                return null;
            }
            return a2.getClusterNode();
        }));
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.l((NodeInfo)a3);
        clusterController.C.updateNodeInfo((NodeInfo)a3);
        clusterController.e.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public void stop() {
        a.F = false;
    }
}

