/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.localstorage.file.PositionKeepingDataInputStream;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final MessagingPlatformConfiguration G;
    private static final DataSize c = DataSize.ofMegabytes((long)32L);
    private final Logger L;
    private AdvancedTlsX509KeyManager.Closeable H;
    private final ApplicationEventPublisher F;
    private boolean a;
    private final List<AxonServerInternalService> e;
    private Server f;
    private final Supplier<ScheduledExecutorService> l;
    private final LeaderElectionService C;
    private final ExecutorService K;
    private final LogReplicationService I;

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.L = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.G = a8;
        messagingClusterServer3.I = a6;
        messagingClusterServer3.C = a5;
        messagingClusterServer2.e = a4;
        messagingClusterServer2.l = a3;
        messagingClusterServer.F = a2;
        messagingClusterServer.K = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(PositionKeepingDataInputStream.l((Object)"7h!w a&)1|1g!p;vy")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = PositionKeepingDataInputStream.l((Object)"j;$\u0007W\u0018");
            if (messagingClusterServer.G.getSsl() != null && messagingClusterServer.G.getSsl().isEnabled()) {
                Object object = messagingClusterServer.G.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(TaskPublisher.l((Object)"k.e8c'$7r9d%o$|3xxy%fxi3x\"'5b7c8'0c:ovd9~vy3~"));
                }
                Object object2 = messagingClusterServer.G.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(PositionKeepingDataInputStream.l((Object)"e,k:m%*5|;j'a&r1vzw'hzt&m\"e ayo1}yb=h1$:k $'a "));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.H = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.l.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.G.getInternalPort(), (ServerCredentials)object);
                string = TaskPublisher.l((Object)"Y\u0005Fvo8k4f3n");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.G.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.G.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(c.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.G.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.G));
            messagingClusterServer.e.forEach(arg_0 -> MessagingClusterServer.l((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.C);
            a2.addService((BindableService)messagingClusterServer2.I);
            if (messagingClusterServer2.G.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.G.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.G.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.G.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.K);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(PositionKeepingDataInputStream.l((Object)"7h!w a&)6k'wy"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(TaskPublisher.l((Object)"i:\u007f%~3x{}9x=o$'"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(PositionKeepingDataInputStream.l((Object)"7h!w a&)6k'wy"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(TaskPublisher.l((Object)"i:\u007f%~3x{}9x=o$'"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.f = a2.build();
            messagingClusterServer.f.start();
            messagingClusterServer.L.info(PositionKeepingDataInputStream.l((Object)"\u0015|;jtW1v\"a&$\u0017h!w a&$\u0007a&r1vtw e&p1`tk:$$k&pn$/yt)t\u007f)"), (Object)messagingClusterServer.G.getInternalPort(), (Object)string);
            messagingClusterServer.F.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.a = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(TaskPublisher.l((Object)"Y\"k$~?d1*\u0017r9dvY3x o$*\u0015f#y\"o$*\u0005o$|3xvl7c:o2*"), (Throwable)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void l(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.H != null) {
            messagingClusterServer.H.close();
        }
        messagingClusterServer.K.shutdown();
        try {
            if (!messagingClusterServer.f.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.L.debug(TaskPublisher.l((Object)"\u0010e$i3l#f:svy\"e&z?d1*\u0015f#y\"o$*\u0005o$|3x"));
                messagingClusterServer2.f.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.L.debug(PositionKeepingDataInputStream.l((Object)"M:p1v&q$p1`t`!v=j3$'l!p0k#jtk2$=j a&j5htE,k:W1v\"a&"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.a = false;
        messagingClusterServer.L.info(TaskPublisher.l((Object)"\u0017r9dvY3x o$*\u0015f#y\"o$*\u0005o$|3xvy\"e&z3n"));
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.a;
    }

    public int getPhase() {
        return 50;
    }
}

