/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.transport.rest.v2.EventProcessorRestControllerV2;
import io.axoniq.axonserver.util.StreamObserverUtils;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final ReplicationGroupController B;
    private final FileSystemMonitor M;
    private final RaftGroupRepositoryManager G;
    private final Map<String, RaftGroup> c;
    private final MessagingPlatformConfiguration L;
    private final GrpcRaftGroupFactory H;
    private final LifecycleController F;
    private final ApplicationEventPublisher a;
    private final RaftProperties e;
    private final AtomicBoolean f;
    private final Logger l;
    private volatile boolean C;
    public static final String K = "replication-logs";
    private final Map<String, Long> I;

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.e.getMaxElectionTimeout();
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.C) {
            throw new IllegalStateException(StreamObserverUtils.l((Object)"G\bg\u0012g\u0007b\u000ft\u0007z\u000fa\b.\t|F}\u000e{\u0012j\ty\b.\u000f`F~\u0014a\u0001|\u0003}\u0015"));
        }
        if (!a3.c.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.L.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.c.get(a2)).localNode();
    }

    private /* synthetic */ boolean l(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.I.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.L.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(StreamObserverUtils.l((Object)"M\t{\njF`\tzFh\u000f`\u0002.\u0005{\u0014|\u0003`\u0012.\ba\u0002kFg\b.\ba\u0002k\u0015"));
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).e();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.C) {
            a2.c.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).l();
            });
        }
    }

    private /* synthetic */ MessagingPlatformException l(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.L.getName() + ": Not a member of " + (String)a2);
    }

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.M.unregisterPath(K);
        grpcRaftController.c.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.C = false;
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.G.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.a.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.B.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.l((String)a2));
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.L.getName();
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.L.getFullyQualifiedInternalHostname()).setPort(a5.L.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.l((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.l.debug(StreamObserverUtils.l((Object)"5z\u0007|\u0012.\u0000|\tcFg\bg\u0012\\\u0007h\u0012I\u0014a\u0013~Fu\u001b"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.l = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.c = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.I = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.f = new AtomicBoolean();
        grpcRaftController6.L = a9;
        grpcRaftController6.G = a8;
        grpcRaftController5.B = a7;
        grpcRaftController5.e = a6;
        grpcRaftController4.a = a5;
        grpcRaftController4.H = a4;
        grpcRaftController3.M = a3;
        grpcRaftController3.F = a2;
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.c.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    private /* synthetic */ void l(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.I.put(a2, System.currentTimeMillis() + 2L * (long)a3.e.getMaxElectionTimeout());
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.G.contexts();
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.l((String)a3);
        }
        a4.c.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.B.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.a.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.l.info(EventProcessorRestControllerV2.l((Object)"7Sv\u000e\u001eK<B%M-Z%A\"\u000e+\\#[<\u000e?Z-\\8K("), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.F.setCleanShutdown();
                grpcRaftController2.f.set(true);
                return;
            }
        } else {
            a3.l.warn(StreamObserverUtils.l((Object)"u\u001b4F\\\u0003~\ng\u0005o\u0012g\t`Fi\u0014a\u0013~F}\u0012o\u0014zFh\u0007g\nk\u0002"), (Object)a.groupId(), a2);
        }
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.e.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.l((File)a2);
        grpcRaftController2.M.registerPath(K, ((File)a2).toPath(), grpcRaftController.e.minFreeSpace(), grpcRaftController.e.warnFreeSpace());
        a2 = grpcRaftController2.G.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.l(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.C = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.l.info(EventProcessorRestControllerV2.l((Object)"U1\u0014l|)^ G/O8G#@lI>A9^l]8O>Z%@+"), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.c.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.l((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.l.warn(StreamObserverUtils.l((Object)"\u001ds\\. o\u000fb\u0003jFz\t.\u000f`\u000fz\u000fo\ng\u001ckF|\u0003~\ng\u0005o\u0012g\t`!|\t{\u0016"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.l.info(EventProcessorRestControllerV2.l((Object)"|)^ G/O8G#@lI>A9^lM#@8\\#B K>\u000e>[\"@%@+"));
        if (a2.isEmpty()) {
            grpcRaftController.f.set(true);
        }
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.c.keySet();
    }

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.c.get(a2);
    }

    public int getPhase() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup l(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.c;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.l.info(EventProcessorRestControllerV2.l((Object)"U1\u0014lG\"G8\u000e>K<B%M-Z%A\"\u000e+\\#[<"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.c.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.H.create((String)a4, (String)a2);
            a2.localNode().l(arg_0 -> a3.l((RaftGroup)a2, arg_0));
            a3.c.put(a4, a2);
            return a2;
        }
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.C;
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().D() || a2.logEntryProcessor().l() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(EventProcessorRestControllerV2.l((Object)"g\"Z)\\>[<ZlY$G KlY-G8G\"IlZ#\u000e.K/A!KlB)O(K>"));
            }
        }
        return a2.localNode();
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.c.keySet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.l();
        long l = a2.l();
        if (v0.l() && !a3.D()) {
            grpcRaftController.a.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l));
            return;
        }
        if (a3.D() && !a3.l()) {
            grpcRaftController.a.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).l(), l));
            return;
        }
        if (a3.b()) {
            grpcRaftController.a.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.F())) {
            grpcRaftController.a.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.F(), l));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.l(a2.localNode(), (StateChanged)a3);
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.f.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.C) {
            throw new IllegalStateException(StreamObserverUtils.l((Object)"5k\u0014x\u0003|F}\u0012o\u0014z\u0013~I}\u000e{\u0012j\ty\b.\u000f`F~\u0014a\u0001|\u0003}\u0015"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.c.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.c;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.c.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.l((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, EventProcessorRestControllerV2.l((Object)"|)^ G/O8G#@lI>A9^lJ)B)Z%A\"\u000e%@l^>A+\\)]?"));
                }
                a3 = grpcRaftController.l((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }
}

