/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.cluster.replication.EntryIterator;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroups;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.C;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.websocket.ClusterUpdatesListener;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class RaftLeaderProviderImpl
implements ReplicationLeaderProvider {
    private final Map<String, String> F;
    private final Set<Consumer<String>> a;
    private final ApplicationEventPublisher e;
    private final Function<String, Set<String>> f;
    private final String l;
    private final RaftGroupManager C;
    private static final EntryIterator K = new C();
    private final Logger I;

    @EventListener
    @Order(value=100)
    public void on(ContextEvents.ContextCreated contextCreated) {
        RaftLeaderProviderImpl a2 = contextCreated;
        RaftLeaderProviderImpl a3 = this;
        String string = (String)a3.F.get(a2.replicationGroup());
        Optional optional = a3.C.currentTerm(a2.replicationGroup());
        if (!optional.isPresent()) {
            return;
        }
        if (a3.l.equals(string)) {
            a3.e.publishEvent((Object)new ClusterEvents.BecomeContextLeader(a2.context(), a2.replicationGroup(), () -> K, ((Long)optional.get()).longValue()));
            return;
        }
        a3.e.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a2.context(), a2.replicationGroup(), string, ((Long)optional.get()).longValue()));
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown leaderStepDown) {
        RaftLeaderProviderImpl a2 = leaderStepDown;
        RaftLeaderProviderImpl a3 = this;
        long l = a3.C.currentTerm(a2.replicationGroup()).orElse(-1L);
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.F.remove(a2.replicationGroup());
        ((Set)raftLeaderProviderImpl.f.apply(a2.replicationGroup())).forEach(arg_0 -> a3.l((ClusterEvents.LeaderStepDown)a2, l, arg_0));
        a3.l(a2.replicationGroup());
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        RaftLeaderProviderImpl raftLeaderProviderImpl;
        RaftLeaderProviderImpl a2 = leaderConfirmation;
        RaftLeaderProviderImpl a3 = this;
        long l = a3.C.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l) {
            return;
        }
        if (a2.node() == null) {
            RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl2;
            raftLeaderProviderImpl2.F.remove(a2.replicationGroup());
        } else {
            RaftLeaderProviderImpl raftLeaderProviderImpl3 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl3;
            raftLeaderProviderImpl3.F.put(a2.replicationGroup(), a2.node());
        }
        ((Set)raftLeaderProviderImpl.f.apply(a2.replicationGroup())).forEach(arg_0 -> a3.l((ClusterEvents.LeaderConfirmation)a2, l, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLeader(String string) {
        void a2;
        RaftLeaderProviderImpl raftLeaderProviderImpl = this;
        String a3 = (String)raftLeaderProviderImpl.F.get(a2);
        raftLeaderProviderImpl.I.debug(ClusterUpdatesListener.l((Object)"8ry/ g&l(f-hcc&n'j1/8r"), (Object)a2, (Object)a3);
        if (a3 != null && a3.equals(raftLeaderProviderImpl.l)) {
            return true;
        }
        return false;
    }

    public String getLeader(String string) {
        Object a2 = string;
        RaftLeaderProviderImpl a3 = this;
        return (String)a3.F.get(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated, long l, String string) {
        void a2;
        void a3;
        RaftLeaderProviderImpl a4 = replicationGroupUpdated;
        RaftLeaderProviderImpl a5 = this;
        a5.e.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation((String)a3, a4.replicationGroup(), (String)a5.F.get(a4.replicationGroup()), (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClusterEvents.LeaderStepDown leaderStepDown, long l, String string) {
        void a2;
        void a3;
        Object a4;
        RaftLeaderProviderImpl raftLeaderProviderImpl = object;
        Object object = string;
        RaftLeaderProviderImpl a5 = raftLeaderProviderImpl;
        a5.e.publishEvent((Object)new ClusterEvents.ContextLeaderStepDown((String)a4, a3.replicationGroup(), (long)a2));
    }

    @EventListener
    public void on(ClusterEvents.LeaderNotification leaderNotification) {
        RaftLeaderProviderImpl a2 = leaderNotification;
        RaftLeaderProviderImpl a3 = this;
        long l = a3.C.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l) {
            return;
        }
        if (!a2.node().equals(a3.F.get(a2.replicationGroup()))) {
            RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
            raftLeaderProviderImpl.F.put(a2.replicationGroup(), a2.node());
            ((Set)raftLeaderProviderImpl.f.apply(a2.replicationGroup())).forEach(arg_0 -> a3.l((ClusterEvents.LeaderNotification)a2, l, arg_0));
            a3.l(a2.replicationGroup());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClusterEvents.BecomeLeader becomeLeader, long l, String string) {
        void a2;
        void a3;
        RaftLeaderProviderImpl a4 = becomeLeader;
        RaftLeaderProviderImpl a5 = this;
        a5.e.publishEvent((Object)new ClusterEvents.BecomeContextLeader((String)a3, a4.replicationGroup(), a4.unappliedEntriesSupplier(), (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Set l(RaftGroupRepositoryManager raftGroupRepositoryManager, AdminReplicationGroups adminReplicationGroups, String string) {
        void a2;
        RaftGroupRepositoryManager raftGroupRepositoryManager2 = raftGroupRepositoryManager;
        Object a3 = raftGroupRepositoryManager2.contextsPerReplicationGroup((String)a2);
        if (a3.isEmpty()) {
            void a4;
            a3 = a4.contextsPerReplicationGroup((String)a2);
        }
        return a3;
    }

    public Set<String> leaderFor() {
        RaftLeaderProviderImpl a2;
        return a2.F.keySet().stream().filter(arg_0 -> a2.isLeader(arg_0)).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClusterEvents.LeaderNotification leaderNotification, long l, String string) {
        void a2;
        void a3;
        RaftLeaderProviderImpl a4 = leaderNotification;
        RaftLeaderProviderImpl a5 = this;
        a5.e.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation((String)a3, a4.replicationGroup(), a4.node(), (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClusterEvents.LeaderConfirmation leaderConfirmation, long l, String string) {
        void a2;
        void a3;
        RaftLeaderProviderImpl a4 = leaderConfirmation;
        RaftLeaderProviderImpl a5 = this;
        a5.e.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation((String)a3, a4.replicationGroup(), a4.node(), (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    RaftLeaderProviderImpl(String string, Function<String, Set<String>> function, ApplicationEventPublisher applicationEventPublisher, RaftGroupManager raftGroupManager) {
        RaftLeaderProviderImpl a2;
        void a3;
        void a4;
        void a5;
        RaftLeaderProviderImpl a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl = raftLeaderProviderImpl2;
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = raftGroupManager;
        RaftLeaderProviderImpl raftLeaderProviderImpl3 = a6 = raftLeaderProviderImpl;
        RaftLeaderProviderImpl raftLeaderProviderImpl4 = a6;
        a6.I = LoggerFactory.getLogger(RaftLeaderProviderImpl.class);
        RaftLeaderProviderImpl raftLeaderProviderImpl5 = a6;
        a6.F = new ConcurrentHashMap();
        RaftLeaderProviderImpl raftLeaderProviderImpl6 = a6;
        raftLeaderProviderImpl5.a = new CopyOnWriteArraySet();
        raftLeaderProviderImpl4.l = a5;
        raftLeaderProviderImpl4.f = a4;
        raftLeaderProviderImpl3.e = a3;
        raftLeaderProviderImpl3.C = a2;
    }

    public void registerLeaderChangeListener(Consumer<String> consumer) {
        Object a2 = consumer;
        RaftLeaderProviderImpl a3 = this;
        a3.a.add(a2);
    }

    @EventListener
    @Order(value=10)
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        RaftLeaderProviderImpl a2 = becomeLeader;
        RaftLeaderProviderImpl a3 = this;
        long l = a3.C.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l) {
            return;
        }
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.F.put(a2.replicationGroup(), a3.l);
        ((Set)raftLeaderProviderImpl.f.apply(a2.replicationGroup())).forEach(arg_0 -> a3.l((ClusterEvents.BecomeLeader)a2, l, arg_0));
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
        raftLeaderProviderImpl2.e.publishEvent((Object)new ClusterEvents.LeaderNotification(a2.replicationGroup(), a3.l, l));
        raftLeaderProviderImpl2.l(a2.replicationGroup());
    }

    private static /* synthetic */ void l(String string, Consumer consumer) {
        Consumer a2 = consumer;
        String a3 = string;
        a2.accept(a3);
    }

    private /* synthetic */ void l(String string) {
        Object a2 = string;
        RaftLeaderProviderImpl a3 = this;
        a3.a.forEach(arg_0 -> RaftLeaderProviderImpl.l((String)a2, arg_0));
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        RaftLeaderProviderImpl a2 = replicationGroupUpdated;
        RaftLeaderProviderImpl a3 = this;
        if (a3.F.containsKey(a2.replicationGroup())) {
            long l = a3.C.currentTerm(a2.replicationGroup()).orElse(-1L);
            ((Set)a3.f.apply(a2.replicationGroup())).forEach(arg_0 -> a3.l((ClusterEvents.ReplicationGroupUpdated)a2, l, arg_0));
        }
    }

    @EventListener
    public void on(ContextEvents.ContextDeleted contextDeleted) {
        RaftLeaderProviderImpl a2 = contextDeleted;
        RaftLeaderProviderImpl a3 = this;
        long l = a3.C.currentTerm(a2.replicationGroup()).orElse(-1L);
        ((Set)a3.f.apply(a2.replicationGroup())).stream().filter(arg_0 -> RaftLeaderProviderImpl.l((ContextEvents.ContextDeleted)a2, arg_0)).forEach(arg_0 -> a3.l((ContextEvents.ContextDeleted)a2, l, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ContextEvents.ContextDeleted contextDeleted, long l, String string) {
        void a2;
        void a3;
        RaftLeaderProviderImpl a4 = contextDeleted;
        RaftLeaderProviderImpl a5 = this;
        a5.e.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation((String)a3, a4.replicationGroup(), (String)a5.F.get(a4.replicationGroup()), (long)a2));
    }

    private static /* synthetic */ boolean l(ContextEvents.ContextDeleted contextDeleted, String string) {
        String a2 = string;
        ContextEvents.ContextDeleted a3 = contextDeleted;
        return a2.equals(a3.context());
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public RaftLeaderProviderImpl(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftGroupRepositoryManager raftGroupRepositoryManager, AdminReplicationGroups adminReplicationGroups, ApplicationEventPublisher applicationEventPublisher, RaftGroupManager raftGroupManager) {
        RaftLeaderProviderImpl a2;
        void a3;
        void a4;
        void a5;
        void a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl = raftLeaderProviderImpl2;
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = raftGroupManager;
        RaftLeaderProviderImpl a7 = raftLeaderProviderImpl;
        a7(a6.getName(), arg_0 -> RaftLeaderProviderImpl.l((RaftGroupRepositoryManager)a5, (AdminReplicationGroups)a4, arg_0), (ApplicationEventPublisher)a3, (RaftGroupManager)a2);
    }
}

