/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.localstorage.file.PositionKeepingDataInputStream;
import io.axoniq.axonserver.message.ContextClusterMetrics;
import io.axoniq.axonserver.metric.MeterFactory;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private Server G;
    private final ExecutorService c;
    private boolean L;
    private final List<ServerTransportFilter> H;
    private final MessagingPlatformConfiguration F;
    private final List<AxonServerClientService> a;
    private final Logger e;
    private final MeterFactory f;
    private final AxonServerAccessController l;
    private final Supplier<ScheduledExecutorService> C;
    private AdvancedTlsX509KeyManager.Closeable K;
    private final LicenseAccessController I;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = ContextClusterMetrics.l((Object)"l;\"\u0007Q\u0018");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.F.getSsl() != null && gateway.F.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.K = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.F.getSsl().getPrivateKeyFile()), new File(gateway.F.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.C.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = PositionKeepingDataInputStream.l((Object)"\u0007W\u0018$1j5f8a0");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.F.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.F.getPort());
            }
            if (gateway2.F.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.F.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.F.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.a.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.F.getGrpcBufferedMessages()));
            if (gateway.F.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.l, gateway5.f));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.I));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.F.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.F.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.F.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.c);
            gateway.H.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.G = a2.build();
            gateway.G.start();
            gateway.e.info(ContextClusterMetrics.l((Object)"C,m:\"\u0007g&t1ptE5v1u5{tq c&v1ftm:\"$m&vn\"/\u007ft/ty)"), (Object)gateway.F.getPort(), (Object)string);
            gateway.L = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(PositionKeepingDataInputStream.l((Object)"\u0007p5v m:ctE,k:$\u0007a&r1vtC5p1s5}tb5m8a0"), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.L;
    }

    public int getPhase() {
        return 200;
    }

    public void stop() {
        Gateway gateway = this;
        if (gateway.K != null) {
            gateway.K.close();
        }
        Gateway gateway2 = gateway;
        gateway2.c.shutdown();
        if (gateway2.L) {
            try {
                if (!gateway.G.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.e.debug(PositionKeepingDataInputStream.l((Object)"B;v7a2q8h-$'p;t$m:ctG8q'p1vtW1v\"a&"));
                    gateway3.G.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.e.debug(ContextClusterMetrics.l((Object)"K:v1p&w$v1ftf!p=l3\"'j!v0m#ltm2\"\u0013P\u0004Atq1p\"g&"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.L = false;
        gateway.e.info(PositionKeepingDataInputStream.l((Object)"\u0015|;jtW1v\"a&$\u0013e a#e-$'p;t$a0"));
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.e = LoggerFactory.getLogger(Gateway.class);
        gateway6.F = a8;
        gateway5.a = a7;
        gateway5.H = a6;
        gateway4.l = a5;
        gateway4.I = a4;
        a9.C = a3;
        gateway3.f = a2;
        gateway3.c = Executors.newFixedThreadPool(a9.F.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(ContextClusterMetrics.l((Object)"e&r7/1z1a!v;py")));
    }
}

