/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.SendingStreamObserver;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.axoniq.axonserver.grpc.control.NodeInfo;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformInfo;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformServiceGrpc;
import io.axoniq.axonserver.grpc.control.RequestReconnect;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.localstorage.SnapshotReader;
import io.axoniq.axonserver.localstorage.file.PositionKeepingDataInputStream;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.util.StreamObserverUtils;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="PlatformService")
public class PlatformService
extends PlatformServiceGrpc.PlatformServiceImplBase
implements AxonServerClientService {
    public static final String G = "component";
    private final Map<PlatformInboundInstruction.RequestCase, Deque<InstructionConsumer>> c;
    private final MeterFactory L;
    private static final Logger H = LoggerFactory.getLogger(PlatformService.class);
    private final AuthenticationProvider F;
    private final InstructionAckSource<PlatformOutboundInstruction> a;
    private final Topology e;
    private final Map<String, Gauge> f;
    private final ClientIdRegistry l;
    private final Map<ClientComponent, SendingStreamObserver<PlatformOutboundInstruction>> C;
    private final ContextProvider K;
    private final ApplicationEventPublisher I;

    /*
     * WARNING - void declaration
     */
    public boolean requestReconnect(ClientComponent clientComponent, String string) {
        void a2;
        PlatformService a3 = clientComponent;
        PlatformService a4 = this;
        H.debug(SnapshotReader.l((Object)"\\A\u007fQkWz\u0004|AmK`JkGz\u001e._s\u0004#\u0004uY"), (Object)a3, (Object)a2);
        StreamObserver streamObserver = (StreamObserver)a4.C.get(a3);
        if (streamObserver != null) {
            PlatformService platformService = a3;
            a4.I.publishEvent((Object)new TopologyEvents.ApplicationReconnectRequested(platformService.C, platformService.K, a3.I, (String)a2));
            streamObserver.onNext((Object)PlatformOutboundInstruction.newBuilder().setRequestReconnect(RequestReconnect.newBuilder()).build());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClientComponent clientComponent, String string, SendingStreamObserver<PlatformOutboundInstruction> sendingStreamObserver) {
        void a2;
        void a3;
        PlatformService a4 = clientComponent;
        PlatformService a5 = this;
        H.debug(SnapshotReader.l((Object)"\\AiM}PkVk@.GbMkJz\u00044\u0004uY"), (Object)a4);
        a5.C.put(a4, a3);
        PlatformService platformService = a4;
        PlatformService platformService2 = a4;
        a5.I.publishEvent((Object)new TopologyEvents.ApplicationConnected(platformService.C, platformService.I, platformService2.l, platformService2.K, (String)a2, null));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClientComponent clientComponent, Throwable throwable) {
        void a2;
        void a3;
        PlatformService platformService = this;
        PlatformService a4 = (SendingStreamObserver)platformService.C.remove(a3);
        if (a4 != null) {
            StreamObserverUtils.l((StreamObserver)a4, (Throwable)a2);
        }
        platformService.l((ClientComponent)a3, 0L, a2.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Boolean l(String string, ClientComponent clientComponent) {
        void a2;
        PlatformService a3 = clientComponent;
        PlatformService a4 = this;
        return a4.requestReconnect((ClientComponent)a3, (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(ClientComponent clientComponent, long l, String string) {
        PlatformService a2 = clientComponent;
        PlatformService a3 = this;
        H.debug(PositionKeepingDataInputStream.l((Object)"\u0010ayv1c=w a&a0$7h=a:pt>t\u007f)"), (Object)a2);
        if (a2 != null) {
            void a4;
            void a5;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2.getContext();
            stringArray[2] = G;
            stringArray[3] = a2.getComponent();
            Tags tags = Tags.of((String[])stringArray);
            a3.L.counter((MetricName)BaseMetricName.da, tags).increment();
            if (a5 > 0L) {
                a3.L.timer((MetricName)BaseMetricName.H, tags).record(System.currentTimeMillis() - a5, TimeUnit.MILLISECONDS);
            }
            if ((tags = (SendingStreamObserver)a3.C.remove(a2)) != null) {
                StreamObserverUtils.l((StreamObserver)tags);
            }
            a3.l.unregister(a2.l, ClientIdRegistry.ConnectionType.K);
            PlatformService platformService = a2;
            PlatformService platformService2 = a2;
            a3.I.publishEvent((Object)new TopologyEvents.ApplicationDisconnected(platformService.C, platformService.I, platformService2.l, platformService2.K, null, (String)a4));
        }
    }

    public StreamObserver<PlatformInboundInstruction> openStream(StreamObserver<PlatformOutboundInstruction> streamObserver) {
        SendingStreamObserver a2;
        PlatformService platformService;
        PlatformService platformService2 = platformService = this;
        String string = platformService2.K.getContext();
        a2 = new SendingStreamObserver((StreamObserver)a2);
        PlatformService a3 = (Authentication)platformService2.F.get();
        if (H.isInfoEnabled()) {
            H.info(SnapshotReader.l((Object)"MK`JkGzMaJ.K~A`Aj\u0004hK|\u0004uY"), (Object)a3.getName());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private /* synthetic */ long l(String string) {
        Object a2 = string;
        PlatformService a3 = this;
        return a3.C.keySet().stream().filter(arg_0 -> PlatformService.l((String)a2, arg_0)).count();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(String string, ClientComponent clientComponent) {
        void a2;
        PlatformService a3 = clientComponent;
        PlatformService a4 = this;
        a4.requestReconnect((ClientComponent)a3, (String)a2);
    }

    @EventListener
    public void on(TopologyEvents.RequestClientReconnect requestClientReconnect) {
        PlatformService a2 = requestClientReconnect;
        PlatformService a3 = this;
        a3.requestReconnect(a2.l(), PositionKeepingDataInputStream.l((Object)"\u0006a%q1w a0$6}tq'a&"));
    }

    private /* synthetic */ boolean l(InstructionAck instructionAck) {
        PlatformService a2 = instructionAck;
        PlatformService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    @EventListener
    public void on(TopologyEvents.ApplicationInactivityTimeout applicationInactivityTimeout) {
        ClientComponent a2;
        PlatformService platformService = this;
        Object a3 = a2.l();
        a2 = new ClientComponent(a3.l(), a2.l().clientId(), a2.l(), a2.l().context());
        a3 = "Platform stream inactivity for " + a3.l();
        a3 = new ApplicationInactivityException((String)a3);
        platformService.l(a2, (Throwable)a3);
    }

    private static /* synthetic */ boolean F(String string, ClientComponent clientComponent) {
        String a2 = clientComponent;
        String a3 = string;
        return ((ClientComponent)a2).C.equals(a3);
    }

    private static /* synthetic */ boolean F(String string, Map.Entry entry) {
        Map.Entry a2 = entry;
        String a3 = string;
        return a3.equals(((ClientComponent)a2.getKey()).l);
    }

    private static /* synthetic */ boolean D(String string, ClientComponent clientComponent) {
        String a2 = clientComponent;
        String a3 = string;
        return ((ClientComponent)a2).K.equals(a3);
    }

    private static /* synthetic */ boolean l(String string, ClientComponent clientComponent) {
        String a2 = clientComponent;
        String a3 = string;
        return a2.getContext().equals(a3);
    }

    private static /* synthetic */ void D(PlatformOutboundInstruction platformOutboundInstruction, SendingStreamObserver sendingStreamObserver) {
        PlatformOutboundInstruction a2 = sendingStreamObserver;
        PlatformOutboundInstruction a3 = platformOutboundInstruction;
        a2.onNext((Object)a3);
    }

    /*
     * WARNING - void declaration
     */
    public void sendToClientStreamId(String string, PlatformOutboundInstruction platformOutboundInstruction) {
        void a2;
        PlatformService a3 = platformOutboundInstruction;
        PlatformService a4 = this;
        a4.C.entrySet().stream().filter(arg_0 -> PlatformService.F((String)a2, arg_0)).map(Map.Entry::getValue).collect(Collectors.toList()).forEach(arg_0 -> PlatformService.l((PlatformOutboundInstruction)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void getPlatformServer(ClientIdentification clientIdentification, StreamObserver<PlatformInfo> streamObserver) {
        void a2;
        void a3;
        PlatformService platformService = this;
        String string = platformService.K.getContext();
        try {
            PlatformService a4 = platformService.e.findNodeForClient(a3.getClientId(), a3.getComponentName(), string, a3.getTagsMap());
            void v0 = a2;
            v0.onNext((Object)PlatformInfo.newBuilder().setSameConnection(a4.getName().equals(platformService.e.getName())).setPrimary(NodeInfo.newBuilder().setNodeName(a4.getName()).setHostName(a4.getHostName()).setGrpcPort(a4.getGrpcPort().intValue()).setHttpPort(a4.getHttpPort().intValue())).build());
            v0.onCompleted();
            return;
        }
        catch (MessagingPlatformException a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.getClientId();
            objectArray[1] = string;
            objectArray[2] = a4.getMessage();
            H.info(SnapshotReader.l((Object)"a|VaV.BgJjM`C.PoViAz\u0004hK|\u0004mHgA`P._s\u000buY4\u0004uY"), objectArray);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)a4));
            return;
        }
        catch (RuntimeException a4) {
            H.warn(PositionKeepingDataInputStream.l((Object)"A&v;vtt&k7a'w=j3$7h=a:ptv1u!a'pt\u007f)"), (Object)a3, (Object)a4);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)a4));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean requestReconnect(String string, String string2) {
        void a2;
        Object a3 = string;
        PlatformService a4 = this;
        H.debug(PositionKeepingDataInputStream.l((Object)"\u0006a%q1w $&a7k:j1g >t\u007f)"), a3);
        return a4.C.keySet().stream().filter(arg_0 -> PlatformService.D((String)a3, arg_0)).map(arg_0 -> a4.l((String)a2, arg_0)).findFirst().orElse(false);
    }

    /*
     * WARNING - void declaration
     */
    public void requestReconnectForContext(String string, String string2) {
        void a2;
        Object a3 = string2;
        PlatformService a4 = this;
        a4.C.keySet().stream().filter(arg_0 -> PlatformService.F((String)a2, arg_0)).collect(Collectors.toSet()).forEach(arg_0 -> a4.l((String)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public PlatformService(Topology topology, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, ApplicationEventPublisher applicationEventPublisher, MeterFactory meterFactory, @Qualifier(value="platformInstructionAckSource") InstructionAckSource<PlatformOutboundInstruction> instructionAckSource) {
        void meterFactory2;
        void eventPublisher;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void topology2;
        InstructionAckSource<PlatformOutboundInstruction> a2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource2 = instructionAckSource3;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource3 = instructionAckSource;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource4 = a2 = instructionAckSource2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource5 = a2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource6 = a2;
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource7 = a2;
        instructionAckSource7.C = new ConcurrentHashMap();
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource8 = a2;
        instructionAckSource6.f = new ConcurrentHashMap();
        InstructionAckSource<PlatformOutboundInstruction> instructionAckSource9 = a2;
        instructionAckSource6.c = new EnumMap(PlatformInboundInstruction.RequestCase.class);
        instructionAckSource6.e = topology2;
        instructionAckSource5.K = contextProvider2;
        instructionAckSource5.F = authenticationProvider2;
        instructionAckSource4.l = clientIdRegistry2;
        instructionAckSource4.I = eventPublisher;
        a2.L = meterFactory2;
        a2.a = instructionAckSource3;
        a2.onInboundInstruction(PlatformInboundInstruction.RequestCase.ACK, (clientComponent, platformInboundInstruction) -> {
            void a2;
            PlatformService a3 = platformInboundInstruction;
            PlatformService a4 = this;
            if (a4.l((InstructionAck)(a3 = a3.getAck()))) {
                void v0 = a2;
                H.warn(SnapshotReader.l((Object)"[J}Q~TaVzAj\u0004gJ}P|QmPgK`\u0004}A`P.Pa\u0004zLk\u0004mHgA`P._s\u0004aB.GaJzAvP._s\n"), (Object)v0.l, (Object)v0.C);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.l;
            objectArray[1] = a2.C;
            objectArray[2] = a3;
            H.trace(PositionKeepingDataInputStream.l((Object)"\u0006a7a=r1`tm:w v!g m;jte7otb&k9$ l1$7h=a:pt\u007f)$;btg;j a,pt\u007f)*tV1w!h $/yz"), objectArray);
        });
    }

    private static /* synthetic */ boolean D(String string, Map.Entry entry) {
        Map.Entry a2 = entry;
        String a3 = string;
        return ((ClientComponent)a2.getKey()).C.equals(a3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendToClient(String string, String string2, PlatformOutboundInstruction platformOutboundInstruction) {
        void a2;
        void a3;
        Object a4 = string;
        PlatformService a5 = this;
        a4 = a5.C.entrySet().stream().filter(arg_0 -> PlatformService.l((String)a3, arg_0)).filter(arg_0 -> PlatformService.D((String)a4, arg_0)).map(Map.Entry::getValue).toList();
        a4.forEach(arg_0 -> PlatformService.D((PlatformOutboundInstruction)a2, arg_0));
        if (!a4.isEmpty()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void onInboundInstruction(PlatformInboundInstruction.RequestCase requestCase, InstructionConsumer instructionConsumer) {
        void a3;
        PlatformService a4 = instructionConsumer;
        PlatformService a5 = this;
        a5.c.computeIfAbsent(a3, a2 -> new ArrayDeque()).add(a4);
    }

    private static /* synthetic */ void l(PlatformOutboundInstruction platformOutboundInstruction, SendingStreamObserver sendingStreamObserver) {
        PlatformOutboundInstruction a2 = sendingStreamObserver;
        PlatformOutboundInstruction a3 = platformOutboundInstruction;
        a2.onNext((Object)a3);
    }

    public Set<ClientComponent> getConnectedClients() {
        PlatformService a2;
        return a2.C.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        void a2;
        PlatformService platformService = this;
        PlatformService a32 = (StreamObserver)platformService.C.remove(new ClientComponent(a2.D(), a2.F(), a2.l(), a2.J()));
        H.debug(SnapshotReader.l((Object)"oT~HgGoPgK`\u0004jM}GaJ`AmPk@4\u0004uY\"\u0004mK`JkGzMaJ4\u0004uY"), (Object)a2.D(), (Object)a32);
        if (a32 != null) {
            try {
                a32.onCompleted();
                return;
            }
            catch (Exception a32) {
                H.debug(PositionKeepingDataInputStream.l((Object)"A&v;vts<m8atg8k'm:ctp&e7o=j3$1r1j $$v;g1w'k&$7k:j1g m;jtb&k9$/yt)t\u007f)"), (Object)a2.D(), (Object)a32.getMessage());
            }
        }
    }

    private static /* synthetic */ boolean l(String string, Map.Entry entry) {
        Map.Entry a2 = entry;
        String a3 = string;
        return ((ClientComponent)a2.getKey()).K.equals(a3);
    }
}

