/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.rest.QueryRestController;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final long a;
    private final Logger e;
    private final Clock f;
    private final ApplicationEventPublisher l;
    private final Map<ClientStreamIdentification, Instant> C;
    private final Map<ClientStreamIdentification, ClientInformation> K;
    private final Publisher<PlatformOutboundInstruction> I;

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.F(), a2.b());
        a3.K.put(clientStreamIdentification, new ClientInformation(a2.D(), a2.J(), a2.F()));
    }

    private static /* synthetic */ void l(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.l((BiConsumer)a2, arg_0, arg_1));
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.I.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.K.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.K.get(a4);
            String string = clientInformation.I;
            String string2 = clientInformation.K;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.a;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.e.info(QueryRestController.l((Object)"\u001dF7O0^~C0K=^7\\7^'\n:O*O=^;N~L1X~G1X;\n*B?D~Q#\n3C2F7Y;I1D:Yp\n\u001dF7O0^d\n%Wr\n2K-^\u001fI*C(C*Sd\n%Wr\n*C3O1_*\u0010~Q#\u0004~"), objectArray);
            a5.l.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.C)));
        }
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.e.debug(QueryRestController.l((Object)"\u001dB;I5C0M~I1D0O=^;N~I2C;D*Y~K,O~Y*C2F~K2C(Op\u0004p"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.f).minus(heartbeatMonitor3.a, ChronoUnit.MILLIS);
        heartbeatMonitor3.C.forEach((arg_0, arg_1) -> heartbeatMonitor.l((Instant)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.e = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.K = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.C = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.e.trace(EventTransformationConfiguration.l((Object)"A\u001fh\b}8l\u001b}Z{\u001fj\u001f`\fl\u001e)\u001c{\u0015dZr\u0007"), (Object)a3);
            heartbeatMonitor.C.put(a3, Instant.now(a2.f));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.f = a5;
        heartbeatMonitor5.l = a4;
        heartbeatMonitor4.a = a3;
        heartbeatMonitor4.I = a2;
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.J(), a2.D());
        a3.C.remove(a2);
        a3.K.remove(a2);
        a3.e.debug(EventTransformationConfiguration.l((Object)"Z\u000ef\n)\u0017f\u0014`\u000ef\b`\u0014nZa\u001fh\b}\u0018l\u001b}Zo\u0015{Zj\u0016`\u001fg\u000e)\u0001tT"), (Object)a2);
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.l((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void l(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }
}

