/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.access.application.AccessControllerDB;
import io.axoniq.axonserver.enterprise.cluster.ClientConnectionInformation;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.j;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private final AtomicLong D;
    private final EventType j;
    private final Supplier<IndexManager> J;
    private final ConcurrentSkipListMap<FileVersion, j> i;
    private final MeterFactory.RateMeter h;
    private final MeterFactory.RateMeter B;
    protected final String M;
    protected final Supplier<StorageProperties> G;
    private final Counter c;
    private static final Logger L = LoggerFactory.getLogger(StandardIndexManager.class);
    private final String H;
    private final ConcurrentNavigableMap<Long, Integer> F;
    private static final ScheduledExecutorService a = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(ClientConnectionInformation.l((Object)"b\u0016o\u001dsUf\u0019e\u0019l\u001dyU")));
    private final Counter e;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> f;
    private final RemoteAggregateSequenceNumberResolver l;
    private ScheduledFuture<?> C;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> K;
    private static final String I = "aggregateMap";

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(Long l, Map<String, List<IndexEntry>> map) {
        void a2;
        Object a3 = l;
        StandardIndexManager a4 = this;
        if (a4.F.containsKey(a3)) {
            throw new IndexNotFoundException((Long)a3 + ": already completed");
        }
        a2.forEach((arg_0, arg_1) -> a4.l((Long)a3, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono l(FileVersion fileVersion) {
        void a2;
        StandardIndexManager standardIndexManager = this;
        Object a3 = ((StorageProperties)standardIndexManager.G.get()).transformedIndex(standardIndexManager.H, (FileVersion)a2);
        return standardIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager standardIndexManager = object;
        Object object = supplier2;
        StandardIndexManager a8 = standardIndexManager;
        a8((String)a7, (Supplier)a6, (String)a5, (EventType)a4, null, (MeterFactory)a3, (Supplier)a2);
    }

    private static /* synthetic */ Mono l(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.fromSupplier(() -> a3).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(file3 -> {
            File a2 = a2;
            File a3 = a3;
            return FileUtils.l((File)a3, (File)a2);
        });
    }

    private static /* synthetic */ IndexEntries l(IndexEntry indexEntry, String string) {
        Object a2 = string;
        IndexEntry a3 = indexEntry;
        return new StandardIndexEntries(a3.D());
    }

    public boolean remove(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        j j2 = (j)a3.i.remove(a2);
        if (j2 != null) {
            j2.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.K.remove(a2);
        if (FileUtils.l((File)((StorageProperties)standardIndexManager.G.get()).index(a3.H, (FileVersion)a2)) && FileUtils.l((File)((StorageProperties)a3.G.get()).bloomFilter(a3.H, (FileVersion)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l, long l2) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Map.Entry entry : standardIndexManager.F.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            StandardIndexManager a4 = standardIndexManager.l(fileVersion, (String)a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(fileVersion, standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.C.equals((Object)standardIndexManager.j)));
        }
        IndexManager a5 = (IndexManager)standardIndexManager.J.get();
        if (a5 != null) {
            return a5.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, (Long)standardIndexManager.F.keySet().last() - 1L);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l, int n, Map<String, List<IndexEntry>> map) {
        StandardIndexManager standardIndexManager;
        HTreeMap hTreeMap;
        Map<String, List> a2;
        FileVersion a222;
        StandardIndexManager standardIndexManager2;
        block12: {
            StandardIndexManager a3;
            block7: {
                StandardIndexManager standardIndexManager3;
                block11: {
                    block10: {
                        block9: {
                            void a222;
                            void a4;
                            standardIndexManager2 = this;
                            a222 = new FileVersion((long)a4, (int)a222);
                            if (a2 == null) {
                                a2 = Collections.emptyMap();
                            }
                            if (!FileUtils.l((File)(a4 = ((StorageProperties)standardIndexManager2.G.get()).transformedIndex(standardIndexManager2.H, a222)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a4);
                            }
                            a3 = DBMaker.fileDB((File)a4);
                            if (!((StorageProperties)standardIndexManager2.G.get()).isUseMmapIndex()) break block9;
                            a3.fileMmapEnable();
                            if (!((StorageProperties)standardIndexManager2.G.get()).isForceCleanMmapIndex()) break block10;
                            StandardIndexManager standardIndexManager4 = a3;
                            standardIndexManager3 = standardIndexManager4;
                            standardIndexManager4.cleanerHackEnable();
                            break block11;
                        }
                        a3.fileChannelEnable();
                    }
                    standardIndexManager3 = a3;
                }
                a3 = standardIndexManager3.make();
                hTreeMap = a3.hashMap(I, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.l()).createOrOpen();
                try {
                    a2.forEach((string, list) -> {
                        void a2;
                        int n;
                        List a3 = list;
                        HTreeMap a4 = hTreeMap;
                        IndexEntry indexEntry = (IndexEntry)a3.get(0);
                        Integer[] integerArray = new Integer[a3.size()];
                        int n2 = n = 0;
                        while (n2 < a3.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a3.get(n3)).l();
                            n2 = n;
                        }
                        a4.put((Object)a2, (Object)new StandardIndexEntries(indexEntry.D(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    standardIndexManager = a3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            standardIndexManager = a3;
        }
        standardIndexManager.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)standardIndexManager2.G.get()).bloomFilter(standardIndexManager2.H, a222).getAbsolutePath(), a2.keySet().size(), ((StorageProperties)standardIndexManager2.G.get()).getBloomIndexFpp());
        hTreeMap2.D();
        hTreeMap2.l(a2.keySet());
        hTreeMap2.F();
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, RemoteAggregateSequenceNumberResolver remoteAggregateSequenceNumberResolver, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager a8;
        Object a9 = string;
        StandardIndexManager standardIndexManager = a8 = this;
        StandardIndexManager standardIndexManager2 = a8;
        StandardIndexManager standardIndexManager3 = a8;
        StandardIndexManager standardIndexManager4 = a8;
        a8.f = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a8;
        standardIndexManager4.K = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a8;
        a8.i = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a8;
        standardIndexManager3.F = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a8;
        standardIndexManager3.D = new AtomicLong();
        standardIndexManager3.G = a7;
        standardIndexManager2.H = a6;
        standardIndexManager2.M = a9;
        standardIndexManager.j = a5;
        standardIndexManager.l = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a9;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a9 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a8;
        void v10 = a3;
        a8.B = a3.rateMeter((MetricName)BaseMetricName.T, (Tags)a9);
        a8.h = v10.rateMeter((MetricName)BaseMetricName.a, (Tags)a9);
        standardIndexManager9.c = v10.counter((MetricName)BaseMetricName.L, (Tags)a9);
        standardIndexManager9.e = a3.counter((MetricName)BaseMetricName.q, (Tags)a9);
        a.scheduleAtFixedRate(() -> {
            Object a2;
            StandardIndexManager standardIndexManager = this;
            StorageProperties storageProperties = (StorageProperties)standardIndexManager.G.get();
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            while (standardIndexManager2.i.size() > storageProperties.getMaxIndexesInMemory()) {
                a2 = standardIndexManager.i.pollFirstEntry();
                L.debug(ClientConnectionInformation.l((Object)"p\u00051XH\u0014d\u000bb\u0016lXb\u0016o\u001dsXp\u0005"), (Object)standardIndexManager.M, a2.getKey());
                standardIndexManager.C = a.schedule(() -> StandardIndexManager.l((Map.Entry)a2), 2L, TimeUnit.SECONDS);
                standardIndexManager2 = standardIndexManager;
            }
            StandardIndexManager standardIndexManager3 = standardIndexManager;
            while (standardIndexManager3.K.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager4 = standardIndexManager;
                standardIndexManager3 = standardIndexManager4;
                a2 = standardIndexManager4.K.pollFirstEntry();
                StandardIndexManager standardIndexManager5 = standardIndexManager;
                L.debug(AccessControllerDB.l((Object)"\u001a\\[\u00013D\fN\u0017D\u0005\u0001\u0003M\u000eN\f\u0001\u0007H\rU\u0004SAG\u000eSAZ\u001c\u0001\u0007S\u000eLAL\u0004L\u000eS\u0018"), (Object)standardIndexManager5.M, a2.getKey());
                standardIndexManager5.e.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a8.J = a2;
    }

    public boolean validIndex(FileVersion fileVersion) {
        block3: {
            boolean bl;
            StandardIndexManager a2;
            block4: {
                a2 = fileVersion;
                StandardIndexManager a3 = this;
                if (!a3.F.containsKey(a2.l()) || ((Integer)a3.F.get(a2.l())).intValue() != a2.l()) break block3;
                if (a3.l((FileVersion)a2) == null || a3.l((FileVersion)a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                L.warn(ClientConnectionInformation.l((Object)"M\u0019b\u0014n\u001c+\fdX}\u0019g\u0011o\u0019\u007f\u001d+\u0011e\u001cn\u0000+\u001ed\n+\u000bn\u001ff\u001de\f1Xp\u0005"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    private static /* synthetic */ Integer l(FileVersion fileVersion, Long l, Integer n) {
        Integer a2 = n;
        FileVersion a3 = fileVersion;
        return a2 == null ? a3.l() : Math.max(a3.l(), a2);
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        StandardIndexManager standardIndexManager;
        StandardIndexManager standardIndexManager2 = standardIndexManager = this;
        standardIndexManager2.f.clear();
        standardIndexManager2.K.clear();
        standardIndexManager2.i.forEach((fileVersion, j2) -> {
            FileVersion a2 = j2;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        StandardIndexManager standardIndexManager3 = standardIndexManager;
        standardIndexManager3.i.clear();
        if (standardIndexManager3.C != null && !standardIndexManager.C.isDone()) {
            standardIndexManager.C.cancel(true);
        }
        if (a2 != false) {
            standardIndexManager.F.keySet().forEach(arg_0 -> standardIndexManager.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager4 = standardIndexManager;
        standardIndexManager4.F.clear();
        StandardIndexManager a3 = (IndexManager)standardIndexManager4.J.get();
        if (a3 != null) {
            a3.cleanup((boolean)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        Object a4 = new HashMap();
        a3.forEach((arg_0, arg_1) -> StandardIndexManager.l((Map)a4, arg_0, arg_1));
        standardIndexManager.l((FileVersion)a2, (Map)a4);
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(long l, String string, IndexEntry indexEntry) {
        StandardIndexManager a3;
        void a4;
        void a5;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntry;
        StandardIndexManager a6 = standardIndexManager;
        if (a6.F.containsKey((long)a5)) {
            throw new IndexNotFoundException((long)a5 + ": already completed");
        }
        a6.f.computeIfAbsent((long)a5, a2 -> new ConcurrentHashMap()).computeIfAbsent(a4, arg_0 -> StandardIndexManager.l((IndexEntry)a3, arg_0)).add((IndexEntry)a3);
    }

    public long size() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntries(String string, long l) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Long l2 : standardIndexManager.f.descendingKeySet()) {
            StandardIndexManager a4 = (IndexEntries)((Map)standardIndexManager.f.get(l2)).get(a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(new FileVersion(l2.longValue(), 0), standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.C.equals((Object)standardIndexManager.j)));
        }
        if (!standardIndexManager.F.isEmpty()) {
            return standardIndexManager.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, ((Long)standardIndexManager.F.keySet().first()).longValue());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IndexEntries l(FileVersion fileVersion, String string) {
        int n;
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        if (standardIndexManager.l((FileVersion)a3, (String)a2)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                StandardIndexManager a4 = standardIndexManager.l((FileVersion)a3);
                return a4.l((String)a2);
            }
            catch (IndexNotFoundException a4) {
                return null;
            }
            catch (Exception a4) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a3.l() + " segment.", a4);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l, long l2, long l3, long l4, long l5) {
        void a2;
        void a3;
        void a4;
        void a5;
        long a6;
        IndexManager indexManager;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        IndexManager indexManager2 = indexManager = standardIndexManager.F.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a6 < a5) {
                return a7;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = standardIndexManager.l(fileVersion, (String)a4);
            Object[] objectArray = new Object[4];
            objectArray[0] = standardIndexManager.M;
            objectArray[1] = a4;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            L.debug(AccessControllerDB.l((Object)"\u001a\\[\u0001\rN\u000eJ\u0014Q F\u0006S\u0004F\u0000U\u0004\u0001\u001a\\AH\u000f\u0001\u0012D\u0006L\u0004O\u0015\u0001\u001a\\AG\u000eT\u000fEAZ\u001c"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.l((long)a3, (long)a2, (SortedMap)a7, fileVersion, indexEntries);
                if (standardIndexManager2.l((long)a3, (long)(a8 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            a6 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)standardIndexManager.J.get();
        if (indexManager != null) {
            void a8;
            a7.putAll(indexManager.lookupAggregateInClosedSegments((String)a4, (long)a3, (long)a2, (long)a8, (long)a5, a6));
        }
        return a7;
    }

    private static /* synthetic */ IndexEntries D(List list, String string) {
        String a2 = string;
        List a3 = list;
        return new StandardIndexEntries(((IndexEntry)a3.get(0)).D());
    }

    private /* synthetic */ void D() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.D.set(standardIndexManager.F.keySet().stream().skip(((StorageProperties)a2.G.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    private /* synthetic */ File l(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.G.get()).index(a3.H, (FileVersion)a2);
    }

    public void complete(FileVersion fileVersion) {
        StandardIndexManager a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager standardIndexManager = a2 = this;
        standardIndexManager.D((FileVersion)a3, (Map)standardIndexManager.f.get(a3.l()));
        a2.f.remove(a3.l());
        a2.D();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> l(FileVersion fileVersion, File file) {
        void a3;
        StandardIndexManager a4 = fileVersion;
        StandardIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.l((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(arg_0 -> StandardIndexManager.l((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.l((FileVersion)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void D(FileVersion fileVersion, Map<String, IndexEntries> map) {
        DBMaker.Maker maker;
        void a2;
        File file;
        Map a3;
        StorageProperties storageProperties;
        StandardIndexManager standardIndexManager;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            standardIndexManager = this;
                            storageProperties = (StorageProperties)standardIndexManager.G.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.l((File)(file = storageProperties.indexTemp(standardIndexManager.H, a2.l())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                StandardIndexManager a4 = maker2.hashMap(I, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.l()).createOrOpen();
                try {
                    a4.putAll(a3);
                    if (a4 == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (a4 != null) {
                            try {
                                a4.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a4.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(standardIndexManager.H, (FileVersion)a2).toPath(), copyOptionArray);
        }
        catch (IOException a4) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(standardIndexManager.H, (FileVersion)a2), (Throwable)a4);
        }
        StandardIndexManager standardIndexManager2 = a4 = new PersistedBloomFilter(storageProperties.bloomFilter(standardIndexManager.H, (FileVersion)a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        standardIndexManager2.D();
        standardIndexManager2.l(a3.keySet());
        standardIndexManager2.F();
        standardIndexManager.K.put(a2, a4);
        standardIndexManager.F.put(a2.l(), a2.l());
        standardIndexManager.l((FileVersion)a2);
    }

    private static /* synthetic */ boolean l(long l, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    private /* synthetic */ boolean l(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.G.get()).dataFile(a3.H, (FileVersion)a2).exists();
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l) {
        Integer n;
        void a2;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.G.get();
        if (standardIndexManager.f.remove((long)a2) == null && (n = (Integer)standardIndexManager.F.remove((long)a2)) != null) {
            FileVersion fileVersion;
            int a222;
            int n2 = a222 = 0;
            while (n2 < n) {
                fileVersion = new FileVersion((long)a2, a222);
                if (storageProperties.index(standardIndexManager.H, fileVersion).exists()) {
                    standardIndexManager.remove(fileVersion);
                }
                n2 = ++a222;
            }
            FileVersion a222 = new FileVersion((long)a2, n.intValue());
            fileVersion = (j)standardIndexManager.i.remove(a222);
            if (fileVersion != null) {
                fileVersion.close();
            }
            standardIndexManager.K.remove(a222);
        }
        if (FileUtils.l((File)storageProperties.index(standardIndexManager.H, (long)a2)) && FileUtils.l((File)storageProperties.bloomFilter(standardIndexManager.H, (long)a2))) {
            return true;
        }
        return false;
    }

    private /* synthetic */ j l(FileVersion fileVersion2) {
        StandardIndexManager a2 = fileVersion2;
        StandardIndexManager a3 = this;
        try {
            return a3.i.computeIfAbsent(a2, fileVersion -> {
                StandardIndexManager a2 = fileVersion;
                StandardIndexManager a3 = this;
                return new j(a3, (FileVersion)a2);
            }).l();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a2 = (j)a3.i.remove(a2);
            if (a2 != null) {
                a2.close();
            }
            throw indexNotFoundException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean l(long l, long l2, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!a4.isEmpty() && a3 >= a4.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    public void addExistingIndex(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.F.put(a2.l(), a2.l());
        a3.D();
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory) {
        StandardIndexManager a2;
        void a3;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = meterFactory;
        StandardIndexManager a7 = standardIndexManager;
        a7((String)a6, (Supplier)a5, (String)a4, (EventType)a3, null, (MeterFactory)a2, () -> null);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean l(FileVersion fileVersion2, String string) {
        void a2;
        StandardIndexManager a3 = fileVersion2;
        StandardIndexManager a4 = this;
        if ((a3 = a4.K.computeIfAbsent(a3, fileVersion -> {
            StandardIndexManager a2 = fileVersion;
            StandardIndexManager a3 = this;
            L.debug(ClientConnectionInformation.l((Object)"p\u00051Xd\bn\u0016+\u001ag\u0017d\u0015+\u001eb\u0014\u007f\u001dyXm\u0017yXp\u0005"), (Object)a3.M, (Object)a2.l());
            StorageProperties storageProperties = (StorageProperties)a3.G.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.H, (FileVersion)a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.l()) {
                return null;
            }
            a3.c.increment();
            StandardIndexManager standardIndexManager = a2;
            standardIndexManager.l();
            return standardIndexManager;
        })) != null && !a3.l((String)a2)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int l(long l, long l2, SortedMap<FileVersion, IndexEntries> sortedMap, FileVersion fileVersion, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!(a4 = a4.range((long)a3, (long)a2, EventType.C.equals((Object)a5.j))).isEmpty()) {
            void a6;
            void a7;
            a7.put(a6, a4);
        }
        return a4.size();
    }

    private static /* synthetic */ void l(Map.Entry a2) {
        ((j)a2.getValue()).close();
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return a3.l((FileVersion)a2).l();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Stream l(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        StandardIndexManager a4 = this;
        File[] fileArray = new File[2];
        fileArray[0] = a2.index(a4.H, ((Long)a3.getKey()).longValue());
        fileArray[1] = a2.bloomFilter(a4.H, ((Long)a3.getKey()).longValue());
        return Stream.of(fileArray);
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l, long l2, long l3, long l4) {
        void a2;
        void a3;
        Iterator iterator;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        Object[] objectArray = new Object[4];
        objectArray[0] = standardIndexManager.M;
        objectArray[1] = a6;
        objectArray[2] = (long)a5;
        objectArray[3] = (long)a4;
        L.debug(AccessControllerDB.l((Object)"Z\u001c\u001bAM\u000eN\nT\u0011`\u0006F\u0013D\u0006@\u0015DAZ\u001c\u0001\fH\u000fr\u0004P\u0014D\u000fB\u0004o\u0014L\u0003D\u0013\u0001\u001a\\M\u0001\r@\u0012U2D\u0010T\u0004O\u0002D/T\fC\u0004SAZ\u001c"), objectArray);
        long l5 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = standardIndexManager.f.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l6 = (Long)iterator.next();
            if (l5 < a3) {
                return a7;
            }
            IndexEntries indexEntries = (IndexEntries)standardIndexManager.f.getOrDefault(l6, Collections.emptyMap()).get(a6);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.l((long)a5, (long)a4, (SortedMap)a7, new FileVersion(l6.longValue(), 0), indexEntries);
                if (standardIndexManager2.l((long)a5, (long)(a2 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            l5 = l6;
            iterator2 = iterator;
        }
        TreeMap treeMap = a7;
        treeMap.putAll(standardIndexManager.lookupAggregateInClosedSegments((String)a6, (long)a5, (long)a4, (long)a2, (long)a3, l5));
        return treeMap;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void l(Map map, String string2, List list) {
        void a2;
        List a3 = list;
        Map a4 = map;
        a4.computeIfAbsent(a2, string -> {
            String a2 = string;
            List a3 = a3;
            return new StandardIndexEntries(((IndexEntry)a3.get(0)).D());
        }).addAll(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void l(Long l, String string, List list) {
        void a3;
        void a4;
        Object a5 = list;
        StandardIndexManager a6 = this;
        a6.f.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a3, arg_0 -> StandardIndexManager.D((List)a5, arg_0)).addAll((List)a5);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l, int n) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        StandardIndexManager a4 = (StorageProperties)standardIndexManager.G.get();
        return standardIndexManager.F.entrySet().stream().filter(arg_0 -> StandardIndexManager.l((long)a3, (int)a2, arg_0)).flatMap(arg_0 -> standardIndexManager.l((StorageProperties)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> l(String string, int n, long l) {
        void a52222;
        void a52222;
        void a2;
        Map map;
        void a3;
        void a4;
        StandardIndexManager standardIndexManager = this;
        int n2 = 0;
        for (Long a52222 : standardIndexManager.f.descendingKeySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if (a52222 > a3 || (map = (Map)standardIndexManager.f.get(a52222)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n2;
        }
        for (Map.Entry a52222 : standardIndexManager.F.entrySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if ((Long)a52222.getKey() > a3) continue;
            map = standardIndexManager.l(new FileVersion(((Long)a52222.getKey()).longValue(), ((Integer)a52222.getValue()).intValue()), (String)a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n2;
        }
        Iterator<Object> iterator = (StandardIndexManager)standardIndexManager.J.get();
        Optional a52222 = Optional.empty();
        if (iterator != null) {
            Optional a52222 = iterator.l((String)a2, (int)(a4 - n2), (long)a3);
        }
        if (a52222.isEmpty() && standardIndexManager.l != null && n2 < a4 && !standardIndexManager.F.isEmpty()) {
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            Optional a52222 = standardIndexManager2.l.getLastSequenceNumber(standardIndexManager2.M, (String)a2, (int)(a4 - n2), (Long)standardIndexManager.F.keySet().last() - 1L);
        }
        return a52222;
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.G.get()).index(a3.H, (FileVersion)a2);
        fileArray[1] = ((StorageProperties)a3.G.get()).bloomFilter(a3.H, (FileVersion)a2);
        return Arrays.asList(fileArray);
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return Mono.defer(() -> a3.l((FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager a4 = this;
        if (a4.F.containsKey(a3.l())) {
            return a4.l((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.J.get();
        if (indexManager != null) {
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l) {
        void a2;
        void a3;
        StandardIndexManager a222 = searchHint;
        StandardIndexManager a4 = this;
        int a222 = a222.equals((Object)EventStorageEngine.SearchHint.I) ? ((StorageProperties)a4.G.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a4.l((String)a3, a222, (long)a2);
    }

    private /* synthetic */ void l(FileVersion fileVersion, Void void_) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.F.put(a2.l(), a2.l());
    }

    public void init() {
        int n;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.G.get();
        String[] stringArray = FileUtils.l((File)new File(standardIndexManager.H), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            StandardIndexManager a2 = FileUtils.l((String)stringArray[n]);
            if (storageProperties.dataFile(standardIndexManager.H, (FileVersion)a2).exists()) {
                standardIndexManager.F.compute(a2.l(), (arg_0, arg_1) -> StandardIndexManager.l((FileVersion)a2, arg_0, arg_1));
            } else {
                standardIndexManager.remove((FileVersion)a2);
            }
            n3 = ++n;
        }
        standardIndexManager.D();
    }

    /*
     * WARNING - void declaration
     */
    public void l(FileVersion fileVersion, Map<String, IndexEntries> map) {
        void a2;
        StandardIndexManager a3 = this;
        StandardIndexManager a4 = fileVersion;
        if (a3.l((FileVersion)a4)) {
            a3.D((FileVersion)a4, (Map)a2);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a3.J.get();
        if (standardIndexManager != null) {
            standardIndexManager.l((FileVersion)a4, (Map)a2);
        }
    }
}

