/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.localstorage.file.multitier.MultiTierInformationProvider;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.WrappedCommand;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final DistributeLicenseService c;
    private final RaftConfigServiceFactory L;
    private final ClusterTemplateController H;
    public static final String F = "_none";
    private static final Logger a;
    private final ClusterTopology e;
    private final ClusterController f;
    private static final Logger l;
    private final Predicate<String> C;
    private final FeatureChecker K;
    private final ApplicationEventPublisher I;

    @GetMapping
    public List<JsonClusterNode> l(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        l.info(WrappedCommand.l((Object)"Zf|@!Odltxri!in=mtri!snydn/"), (Object)AuditLog.username((Principal)object));
        return a2.f.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.f.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode l(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        l.info(MultiTierInformationProvider.l((Object)"ugSA\u000eNKm[y]h\u000erAxK<JyZ}Gp]<Hs\\<Ua\u0000"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.f.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.f.isActive((String)object));
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void l(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        l.info(MultiTierInformationProvider.l((Object)"ugSA\u000eNKm[y]h\u000e\u007fBi]hKn\u000ehKq^pOhK<JsYrBsOx\u0000"), (Object)AuditLog.username((Principal)object));
        if (a2.e.isAdminNode()) {
            ServletOutputStream resp;
            object = WrappedCommand.l((Object)"~mhrido,idpqq`id3xpm");
            String string = a2.H.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(MultiTierInformationProvider.l((Object)"ZyVh\u0001lB}Gr\u0015<MtOn]yZ![hH1\u0016"));
            v1.addHeader(WrappedCommand.l((Object)"Broidsu0Etrmnnhihro"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(MultiTierInformationProvider.l((Object)"ws[<M}@<[oK<ZtGo\u000ez[rMhGs@}BuZe\u000es@pW<HnAq\u000e}JqGr\u000erAxK"));
    }

    static {
        l = AuditLog.getLogger();
        a = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void l(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        l.info(MultiTierInformationProvider.l((Object)"ugSA\u000eNKm[y]h\u000ehA<JyByZy\u000erAxK<Ua\u0000"), (Object)AuditLog.username((Principal)a2), object);
        name.L.getRaftConfigService().deleteNode((String)object);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.C = new ContextNameValidation();
        a9.f = a8;
        clusterRestController5.L = a7;
        clusterRestController5.K = a6;
        clusterRestController4.c = a5;
        clusterRestController4.I = a4;
        clusterRestController3.e = a3;
        clusterRestController3.H = a2;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void l(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        l.info(WrappedCommand.l((Object)"Fz`\\=Sxphdnu=mtbxond=tme|ux/"), (Object)AuditLog.username((Principal)a2));
        a.info(MultiTierInformationProvider.l((Object)"RKk\u000epG\u007fKr]y\u000ei^pA}JyJ0\u000elKnHs\\qGrI<BuMy@oK<[lJ}Zy\u00002\u0000"));
        try {
            void licenseFile;
            clusterRestController.c.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, WrappedCommand.l((Object)"Or!qd|exs=grs=^|ephs/=Dsrhsx!ii|u=uud=^|ephs!odmmtb|utns!zsrtm!tr=bod|uxe=cxgrsx!hqqn|etoz!|!qh~dsrx/"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @PostMapping
    public ResponseEntity<RestResponse> l(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        l.info(WrappedCommand.l((Object)"Fz`\\=Sxphdnu=ur!wnto=bqtnuxs=`i!f|'z`/"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.f.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, MultiTierInformationProvider.l((Object)"m}@rAh\u000e\u007fAqLu@y\u000evAu@u@{\u000e\u007fArZyVh\u000ekGhF<@sms@hKdZo\u0000"));
            }
            if (!RaftAdminGroup.l((String)string) && !jsonClusterNode.C.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            a.debug(WrappedCommand.l((Object)"|ey)4;=Sxftridohsf=ldrxm{!|oy!|eyhsf=lx!in=broideu=#f|?/"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            a.debug(MultiTierInformationProvider.l((Object)"OxJ4\u0007&\u000eNK{GoZy\\u@{\u000eqWoKpH<OrJ<OxJu@{\u000eqK<Zs\u000erA<Ms@hKdZo\u0000"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            a.debug(WrappedCommand.l((Object)"|ey)4;=Sxftridohsf=ldrxm{!|oy!|eyhsf=lx!in=`qm=broideun/"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.f.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, MultiTierInformationProvider.l((Object)"RAxK<Op\\yOxW<\\yIu]hKnKx\u000eu@<O<Mp[oZy\\")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.L.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.I.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, WrappedCommand.l((Object)"\\b~dmuxe=krhs!odltxri-=l|x=u|jx!|!jitmx!in=qon~dnr")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }
}

