/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.enterprise.cluster.ClientConnectionInformation;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.PositionKeepingDataInputStream;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private static final Logger e = AuditLog.getLogger();
    private final boolean f;
    public static final String l = "Plugins disabled";
    private final FeatureChecker C;
    private final Logger K;
    private final PluginController I;

    @GetMapping
    public Iterable<PluginInfo> l(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        e.info(ClientConnectionInformation.l((Object)"P\u0003v%+*n\t~\u001dx\f+\fdXg\u0011x\f+\u001b~\ny\u001de\f+\bg\rl\u0011e\u000b%X"), (Object)AuditLog.username((Principal)object));
        return a2.I.listPlugins();
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey l(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.f || !a2.C.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, l);
            }
            e.info(ClientConnectionInformation.l((Object)"#p\u0005VXY\u001dz\rn\u000b\u007fX\u007f\u0017+\u0011e\u000b\u007f\u0019g\u0014+\bg\rl\u0011eXp\u0005%X"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.l(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.I.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void l(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.f || !context.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, l);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        e.info(PositionKeepingDataInputStream.l((Object)"\u000f\u007f)YtV1u!a'ptp;$!j&a3m'p1vtt8q3m:$/y{\u007f)$2k&$7k:p1| $/yz"), objectArray);
        context.I.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.K = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.f = a3.isPluginsEnabled();
        pluginsRestController.I = a2;
        pluginsRestController.C = a5;
    }

    private /* synthetic */ String l(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, PositionKeepingDataInputStream.l((Object)"J;$$h!c=jtt5g?e3att&k\"m0a0"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ClientConnectionInformation.l((Object)">b\u0014n\u0016j\u0015nXx\u0010d\rg\u001c+\u0016d\f+\u001bd\u0016\u007f\u0019b\u0016+\u001cb\nn\u001b\u007f\u0017y\u0001+\u000bn\bj\nj\fd\n"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> l(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.f || !pluginsRestController.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, l);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        e.info(ClientConnectionInformation.l((Object)"#p\u0005VXY\u001dz\rn\u000b\u007fXm\u0017yXh\u0017e\u001eb\u001f~\nj\fb\u0017eXd\u001e+\u0003vWp\u0005%X"), objectArray);
        try {
            void context;
            return pluginsRestController.I.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.K.warn(PositionKeepingDataInputStream.l((Object)"\u0012e=h1`tp;$&a v=a\"att&k$a&p=a'$2k&$/yn\u007f)"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void l(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        e.info(PositionKeepingDataInputStream.l((Object)"_/y\t$\u0006a%q1w $ ktq:m:w e8htt8q3m:$/y{\u007f)*t"), objectArray);
        version.I.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void l(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.f || !configurationJSON.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, l);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        e.info(PositionKeepingDataInputStream.l((Object)"\u000f\u007f)YtV1u!a'ptp;$!t0e atg;j2m3q&e m;jtk2$/y{\u007f)*t"), objectArray);
        configurationJSON.I.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void l(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.f || !active.C.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, l);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? PositionKeepingDataInputStream.l((Object)"'p5v ") : ClientConnectionInformation.l((Object)"x\fd\b");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        e.info(ClientConnectionInformation.l((Object)"#p\u0005VXY\u001dz\rn\u000b\u007fX\u007f\u0017+\u0003vX{\u0014~\u001fb\u0016+\u0003vWp\u0005%X"), objectArray);
        active.I.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }
}

