/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.message.query.subscription.metric.HubSubscriptionMetrics;
import io.axoniq.axonserver.message.query.subscription.metric.SubscriptionQueryMetricRegistry;
import io.axoniq.axonserver.rest.LicenseInfo;
import io.axoniq.axonserver.rest.PublicRestController;
import io.axoniq.axonserver.rest.json.NodeConfiguration;
import io.axoniq.axonserver.rest.json.QueryRequestJson;
import io.axoniq.axonserver.rest.json.StatusInfo;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.rest.svg.mapping.AxonServer;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.version.VersionInfo;
import io.axoniq.axonserver.version.VersionInfoProvider;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CrossOrigin
@RestController(value="PublicRestController")
@RequestMapping(value={"/v1/public"})
public class PublicRestController {
    private final EventDispatcher M;
    private final VersionInfoProvider G;
    private final SslConfiguration c;
    private final AccessControlConfiguration L;
    private final Topology H;
    private final Function<Predicate<String>, Stream<AxonServer>> F;
    private final SubscriptionQueryMetricRegistry a;
    @Value(value="${axoniq.axonserver.devmode.enabled:false}")
    private boolean e;
    private final CommandDispatcher f;
    private final FeatureChecker l;
    private final Map<String, Boolean> C;
    private final QueryDispatcher K;
    private final boolean I;

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"status"})
    @Operation(summary="Retrieves status information, used by UI")
    public StatusInfo l(@RequestParam(value="context", defaultValue="default", required=false) String string) {
        void a2;
        PublicRestController publicRestController = this;
        HubSubscriptionMetrics hubSubscriptionMetrics = publicRestController.a.get((String)a2);
        PublicRestController publicRestController2 = this = new StatusInfo();
        publicRestController2.setCommandRate(publicRestController.f.commandRate((String)a2));
        publicRestController2.setQueryRate(publicRestController.K.queryRate((String)a2));
        if (!a2.startsWith(QueryRequestJson.l((Object)"s"))) {
            PublicRestController publicRestController3 = this;
            PublicRestController publicRestController4 = publicRestController;
            this.setEventRate(publicRestController.M.eventRate((String)a2));
            this.setSnapshotRate(publicRestController4.M.snapshotRate((String)a2));
            publicRestController3.setNrOfEvents(publicRestController4.M.getNrOfEvents((String)a2));
            publicRestController3.setEventTrackers(publicRestController.M.eventTrackerStatus((String)a2));
        }
        PublicRestController publicRestController5 = this;
        HubSubscriptionMetrics hubSubscriptionMetrics2 = hubSubscriptionMetrics;
        this.setNrOfActiveSubscriptionQueries(hubSubscriptionMetrics2.activesCount().longValue());
        publicRestController5.setNrOfSubscriptionQueries(hubSubscriptionMetrics2.totalCount().longValue());
        publicRestController5.setNrOfSubscriptionQueriesUpdates(hubSubscriptionMetrics.updatesCount().longValue());
        return this;
    }

    @GetMapping(path={"mycontexts"})
    @Operation(summary="Retrieves names for all storage (non admin) contexts for the current node")
    public Iterable<String> l() {
        PublicRestController a2;
        return a2.H.getMyStorageContextNames();
    }

    @GetMapping(path={"license"})
    @Operation(summary="Retrieves license information")
    public LicenseInfo l() {
        PublicRestController a2;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a2 = new LicenseInfo();
        PublicRestController publicRestController3 = publicRestController;
        a2.setExpiryDate(publicRestController.l.getExpiryDate());
        a2.setEdition(publicRestController3.l.getEdition());
        publicRestController2.setLicensee(publicRestController3.l.getLicensee());
        publicRestController2.setFeatureList(publicRestController.l.getFeatureList());
        return publicRestController2;
    }

    /*
     * WARNING - void declaration
     */
    public PublicRestController(Function<Predicate<String>, Stream<AxonServer>> function, Topology topology, CommandDispatcher commandDispatcher, QueryDispatcher queryDispatcher, EventDispatcher eventDispatcher, FeatureChecker featureChecker, MessagingPlatformConfiguration messagingPlatformConfiguration, VersionInfoProvider versionInfoProvider, SubscriptionQueryMetricRegistry subscriptionQueryMetricRegistry) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        PublicRestController a10;
        PublicRestController a11;
        PublicRestController publicRestController = publicRestController2;
        PublicRestController publicRestController2 = messagingPlatformConfiguration;
        PublicRestController publicRestController3 = a11 = publicRestController;
        PublicRestController publicRestController4 = a11;
        PublicRestController publicRestController5 = a10;
        PublicRestController publicRestController6 = a11;
        PublicRestController publicRestController7 = a11;
        PublicRestController publicRestController8 = a11;
        a11.F = a9;
        publicRestController8.H = a8;
        publicRestController8.f = a7;
        publicRestController7.K = a6;
        publicRestController7.M = a5;
        publicRestController6.l = a4;
        publicRestController6.c = a10.getSsl();
        a11.L = publicRestController5.getAccesscontrol();
        publicRestController4.I = publicRestController5.isPluginsEnabled();
        publicRestController4.G = a3;
        publicRestController3.a = a2;
        publicRestController3.C = a10.getPreview();
    }

    @GetMapping(path={"me"})
    @Operation(summary="Retrieves general information on the configuration of the current node, including hostnames and ports for the gRPC and HTTP connections and contexts")
    public NodeConfiguration l() {
        PublicRestController a2;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a2 = new NodeConfiguration(publicRestController.H.getMe());
        PublicRestController publicRestController3 = publicRestController;
        PublicRestController publicRestController4 = a2;
        PublicRestController publicRestController5 = publicRestController;
        a2.setAuthentication(publicRestController.L.isEnabled());
        a2.setSsl(publicRestController5.c.isEnabled());
        publicRestController4.setAdminNode(publicRestController5.H.isAdminNode());
        publicRestController4.setDevelopmentMode(publicRestController.e);
        a2.setContextNames(publicRestController3.H.getMyContextNames());
        publicRestController2.setStorageContextNames(publicRestController3.H.getMyStorageContextNames());
        publicRestController2.setPluginsEnabled(publicRestController.I && publicRestController.l.plugins());
        PublicRestController publicRestController6 = a2;
        PublicRestController publicRestController7 = publicRestController;
        a2.setInitialized(publicRestController.H.initialized());
        a2.setMaxApplications(publicRestController7.l.getMaxApplications());
        publicRestController6.setMaxConnections(publicRestController7.l.maxConnections());
        publicRestController6.setMaxContexts(publicRestController.l.getMaxContexts().orElse(Integer.MAX_VALUE).intValue());
        a2.setMaxReplicationGroups(publicRestController.l.getMaxReplicationGroups().orElse(Integer.MAX_VALUE).intValue());
        PublicRestController publicRestController8 = a2;
        publicRestController8.setMaxUsers(publicRestController.l.getMaxUsers());
        return publicRestController8;
    }

    @GetMapping(path={"version"})
    @Operation(summary="Retrieves version information of the product")
    public VersionInfo l() {
        PublicRestController a2;
        return a2.G.get();
    }

    @GetMapping
    @Operation(summary="Retrieves all nodes in the cluster that the current node knows about.", description="For _admin nodes the result contains all nodes, for non _admin nodes theresult only contains nodes from contexts available on this node and the _admin nodes.")
    public List<JsonServerNode> l() {
        PublicRestController a2;
        return ((Stream)a2.F.apply(null)).map(JsonServerNode::new).sorted(Comparator.comparing(JsonServerNode::getName)).collect(Collectors.toList());
    }

    @GetMapping(path={"user"})
    @Operation(summary="Retrieves information on the user logged in in the current Http Session")
    public UserInfo l(HttpServletRequest httpServletRequest) {
        PublicRestController a2 = httpServletRequest;
        PublicRestController a3 = this;
        if (a2.getUserPrincipal() instanceof Authentication) {
            a2 = (Authentication)a2.getUserPrincipal();
            return new UserInfo(a2.getName(), a2.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        return null;
    }
}

