/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.enterprise.cluster.ClientConnectionInformation;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.C;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.axoniq.axonserver.transport.rest.v2.ReplicationRestControllerV2;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private final RoleController l;
    private static final Logger C;
    private final UserAdminService K;
    private static final Logger I;

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"public/users"})
    public List<UserJson> l(@Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = this;
        try {
            return userRestController.K.users((Authentication)new PrincipalAuthentication((Principal)a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            I.info(ReplicationRestControllerV2.l((Object)"\u001472\u0011o\u0000&?;l:?*><l)-& *(oao72"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    static {
        I = LoggerFactory.getLogger(UserRestController.class);
        C = AuditLog.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"users/{name}"})
    public void l(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        void name;
        UserRestController userRestController = this;
        try {
            userRestController.K.deleteUser((String)name, (Authentication)new PrincipalAuthentication((Principal)a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            C.error(ClientConnectionInformation.l((Object)"#p\u0005VXO\u001dg\u001d\u007f\u001d+\rx\u001dyXp\u0005+\u001ej\u0011g\u001doX&Xp\u0005"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public UserRestController(UserAdminService userAdminService, RoleController roleController) {
        void a2;
        UserRestController a3;
        UserRestController a4 = roleController;
        UserRestController userRestController = a3 = this;
        userRestController.K = a2;
        userRestController.l = a4;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"users"})
    public void l(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = userRestController2;
        UserRestController userRestController2 = userJson;
        UserRestController userJson2 = userRestController;
        if (a2 != null && userRestController2.userName.equals(a2.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, ClientConnectionInformation.l((Object)"E\u0017\u007fXj\u0014g\u0017|\u001doX\u007f\u0017+\u001bc\u0019e\u001fnXr\u0017~\n+\u0017|\u0016+\u001by\u001do\u001de\fb\u0019g\u000b"));
        }
        Set<Object> set = new HashSet();
        if (userRestController2.roles != null) {
            set = Arrays.stream(userRestController2.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserRestController userRestController3 = userRestController2;
        userJson2.K.createOrUpdateUser(userRestController3.userName, userRestController3.password, set.stream().map(adminUserRole -> {
            UserRestController a2 = adminUserRole;
            UserRestController a3 = this;
            return new C(a3, (AdminUserRole)a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication((Principal)a2));
    }
}

