/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.NodeTool;
import io.axoniq.tools.http.json.ContextNode;
import io.axoniq.tools.http.json.NodeAndRole;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegisterContext {
    private RegisterContext() {
    }

    public static void run(String[] args) throws Throwable {
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.CONTEXT, CommandOptions.CONTEXTREPLICATIONGROUP, CommandOptions.CONTEXT_PRIMARY_NODES, CommandOptions.ACTIVE_BACKUP_NODES, CommandOptions.PASSIVE_BACKUP_NODES, CommandOptions.MESSAGING_ONLY_NODES, CommandOptions.SECONDARY_NODES, CommandOptions.PROPERTIES, CommandOptions.TOKEN});
        ContextNode contextNode = new ContextNode();
        contextNode.setContext(commandLine.getOptionValue(CommandOptions.CONTEXT.getOpt()));
        if (commandLine.hasOption(CommandOptions.REPLICATIONGROUP.getOpt())) {
            contextNode.setReplicationGroup(commandLine.getOptionValue(CommandOptions.CONTEXTREPLICATIONGROUP.getOpt()));
        }
        ArrayList nodeRolesMap = new ArrayList();
        HashSet definedNodes = new HashSet();
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.CONTEXT_PRIMARY_NODES, (String)"PRIMARY", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.ACTIVE_BACKUP_NODES, (String)"ACTIVE_BACKUP", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.PASSIVE_BACKUP_NODES, (String)"PASSIVE_BACKUP", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.MESSAGING_ONLY_NODES, (String)"MESSAGING_ONLY", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.SECONDARY_NODES, (String)"SECONDARY", definedNodes, nodeRolesMap);
        if (commandLine.hasOption(CommandOptions.PROPERTIES.getOpt())) {
            for (String metadataProperty : commandLine.getOptionValues(CommandOptions.PROPERTIES.getOpt())) {
                String[] keyValue = metadataProperty.split("=", 2);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException("Property value must be key=value - " + keyValue);
                }
                contextNode.getMetaData().put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        contextNode.setRoles(nodeRolesMap);
        contextNode.setNodes(new ArrayList(definedNodes));
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        ToolResult result = NodeTool.registerContext((ContextNode)contextNode, (String)serverHttpAddress, (boolean)connectInsecure, (String)token);
        if (result.isFailure()) {
            throw result.getFailure();
        }
    }

    private static void addNodes(CommandLine commandLine, Option nodes, String role, Set<String> definedNodes, List<NodeAndRole> nodeRolesMap) {
        if (commandLine.hasOption(nodes.getOpt())) {
            for (String primary : commandLine.getOptionValues(nodes.getOpt())) {
                if (definedNodes.contains(primary)) {
                    throw new IllegalArgumentException("Node can only be provided once");
                }
                nodeRolesMap.add(new NodeAndRole(primary, role));
                definedNodes.add(primary);
            }
        }
    }
}

