/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.migrators;

import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.migration.MigrationBaseProperties;
import io.axoniq.axonserver.migration.destination.EventStoreStrategy;
import io.axoniq.axonserver.migration.migrators.Migrator;
import io.axoniq.axonserver.migration.migrators.db.MigrationStatus;
import io.axoniq.axonserver.migration.migrators.db.MigrationStatusRepository;
import io.axoniq.axonserver.migration.serialisation.EventSerializer;
import io.axoniq.axonserver.migration.source.BaseEvent;
import io.axoniq.axonserver.migration.source.EventProducer;
import io.axoniq.axonserver.migration.source.SnapshotEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.migration.migrateSnapshots"}, havingValue="true", matchIfMissing=true)
public class SnapshotMigrator
implements Migrator {
    private final MigrationBaseProperties migrationProperties;
    private final EventProducer eventProducer;
    private final MigrationStatusRepository migrationStatusRepository;
    private final EventSerializer eventSerializer;
    private final EventStoreStrategy eventStoreStrategy;
    private final Logger logger = LoggerFactory.getLogger(SnapshotMigrator.class);
    private final AtomicLong snapshotsMigrated = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() throws Exception {
        MigrationStatus migrationStatus = this.migrationStatusRepository.findById((Object)1L).orElse(new MigrationStatus());
        String lastProcessedTimestamp = migrationStatus.getLastSnapshotTimestamp();
        String lastEventId = migrationStatus.getLastSnapshotEventId();
        boolean keepRunning = true;
        this.logger.info("Starting migration of snapshots from timestamp: {}, batchSize = {}", (Object)lastProcessedTimestamp, (Object)this.migrationProperties.getBatchSize());
        try {
            while (keepRunning) {
                keepRunning = false;
                List result = this.eventProducer.findSnapshots(lastProcessedTimestamp, this.migrationProperties.getBatchSize());
                if (result.isEmpty()) {
                    this.logger.info("No more snapshots found");
                    return;
                }
                boolean lastFound = lastEventId == null;
                for (SnapshotEvent entry : result) {
                    if (!lastFound) {
                        lastFound = entry.getTimeStamp().compareTo(lastProcessedTimestamp) > 0 || entry.getEventIdentifier().equals(lastEventId);
                        continue;
                    }
                    Event.Builder eventBuilder = Event.newBuilder().setAggregateIdentifier(entry.getAggregateIdentifier()).setPayload(this.eventSerializer.toPayload((BaseEvent)entry)).setAggregateSequenceNumber(entry.getSequenceNumber()).setMessageIdentifier(entry.getEventIdentifier()).setAggregateType(entry.getType());
                    eventBuilder.setTimestamp(entry.getTimeStampAsLong());
                    this.eventSerializer.convertMetadata(entry.getMetaData(), eventBuilder);
                    this.eventStoreStrategy.appendSnapshot(eventBuilder.build());
                    lastProcessedTimestamp = entry.getTimeStamp();
                    lastEventId = entry.getEventIdentifier();
                    if (this.snapshotsMigrated.incrementAndGet() % 1000L == 0L) {
                        this.logger.debug("Migrated {} snapshots", (Object)this.snapshotsMigrated.get());
                    }
                    keepRunning = true;
                }
            }
        }
        finally {
            migrationStatus.setLastSnapshotEventId(lastEventId);
            migrationStatus.setLastSnapshotTimestamp(lastProcessedTimestamp);
            this.migrationStatusRepository.save((Object)migrationStatus);
        }
    }

    public SnapshotMigrator(MigrationBaseProperties migrationProperties, EventProducer eventProducer, MigrationStatusRepository migrationStatusRepository, EventSerializer eventSerializer, EventStoreStrategy eventStoreStrategy) {
        this.migrationProperties = migrationProperties;
        this.eventProducer = eventProducer;
        this.migrationStatusRepository = migrationStatusRepository;
        this.eventSerializer = eventSerializer;
        this.eventStoreStrategy = eventStoreStrategy;
    }
}

