/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.ApplicationTool;
import io.axoniq.tools.http.json.Application;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class ListApplications {
    private ListApplications() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void run(String[] args) throws Throwable {
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.TOKEN});
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        if (AxonIQCliUtil.jsonOutput((CommandLine)commandLine)) {
            ToolResult result = ApplicationTool.listApplicationsRaw((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.println((String)result.getSuccessValue());
            return;
        } else {
            ToolResult result = ApplicationTool.listApplications((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.printf("%-20s %-60s %-20s%n", "Name", "Description", "Roles");
            for (Application app : (List)result.getSuccessValue()) {
                System.out.printf("%-20s %-60s %-20s%n", app.getName(), app.getDescription() != null ? app.getDescription() : "", app.getRoles().stream().map(Object::toString).collect(Collectors.joining(",")));
            }
        }
    }
}

