/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.transport.rest.ApplicationRestController;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final Limits d;
    private final ClusterTagsCache i;
    private final AdminConfigurationFactory J;
    private volatile boolean h;
    private final MessagingPlatformConfiguration H;
    private final ApplicationEventPublisher a;
    private final RemoteConnections L;
    private final Logger j;
    private final AdminNodes F;
    private final CurrentNodeProvider e;

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.L.get((String)a2));
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.L.activeConnections();
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.L.connections();
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.F.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.i.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public void stop() {
        a.h = false;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.a.publishEvent(a2);
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.K(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.H.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.j.info(ApplicationRestController.K((Object)"~cSxDv\neE1@~C\u007f\nfCeB1IdXcO\u007f^1D~Nt\n\u007fK|O+\njW"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.H.getInternalHostname()) && a2.getGrpcInternalPort() == a3.H.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, ApplicationRestController.K((Object)"RK\u007fD~^1@~C\u007f\nrFdYeOc\nfCeB1YpGt\nyEb^\u007fK|O1K\u007fN1C\u007f^tX\u007fK}\naEc^"));
        }
        ClusterNode clusterNode = a3.F.findById(a2.getNodeName()).orElseGet(() -> a3.K((NodeInfo)a2));
        if (!a3.L.contains(a2.getNodeName())) {
            a3.K((NodeInfo)a2);
        }
        return clusterNode;
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public int getPhase() {
        return 50;
    }

    private /* synthetic */ void K(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.L.contains((String)a2) || a3.H.getName().equals(a2)) {
            return;
        }
        a3.d.getMaxClusterSize().ifPresent(arg_0 -> a3.K((String)a2, arg_0));
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.K((ClusterNode)clusterController.e.get());
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.K();
        a2.h = true;
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.j = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.H = messagingPlatformConfiguration2;
        clusterController6.F = clusterNodeRepository;
        clusterController5.J = adminConfigurationFactory2;
        clusterController5.i = clusterTagsCache2;
        clusterController4.a = applicationEventPublisher2;
        clusterController4.d = limits2;
        clusterController3.L = remoteConnections2;
        clusterController3.e = clusterController2;
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.K((NodeInfo)a3);
        clusterController.L.updateNodeInfo((NodeInfo)a3);
        clusterController.a.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public ClusterNode getNode(String string) {
        String a2 = string;
        Object a3 = this;
        if (a2.equals(a3.getName())) {
            return a3.getMe();
        }
        ClusterController clusterController = a3;
        return clusterController.K(clusterController.F.findById(a2).orElseGet(() -> {
            Object a2 = a2;
            ClusterController a3 = this;
            if ((a2 = a3.L.get((String)a2)) == null) {
                return null;
            }
            return a2.getClusterNode();
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.L.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    private /* synthetic */ ClusterNode K(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.j.info(ApplicationRestController.K((Object)"kuN1D~Nt\njW"), (Object)a3);
        a3 = clusterController.J.clusterNode((NodeInfo)a3);
        return clusterController.F.save((ClusterNode)a3);
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.L.disconnect((String)a2);
    }

    private /* synthetic */ void K(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.H.getName())) {
            return;
        }
        a3.L.connect((NodeInfo)a2, true);
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.L.nodes();
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.H.getName()) || a3.L.get(a2) != null && a3.L.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.F.deleteAllByNameNot(clusterController.getName());
        clusterController.L.sync();
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.j.info(ApplicationRestController.K((Object)"ntFt^t\n\u007fEuO+\njW"), a3);
        clusterController2.a.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.H.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.F.deleteAllByNameNot((String)a3);
            clusterController3.L.closeAll();
        } else {
            a2.F.findById((String)a3).ifPresent(arg_0 -> a2.K((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.a.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.L.sync();
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.e.isAdmin();
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.h;
    }

    private /* synthetic */ void K(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.F.deleteById((String)a2);
    }

    private /* synthetic */ void K() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.F.findById(clusterController2.H.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.F.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.H.getName();
                a2 = String.format(ApplicationRestController.K((Object)"R_cXtDe\n\u007fEuO1DpGt\nyKb\nrBpDvOu\u00061Dt]1DpGt\n4Y?\nB^pXe\nPR~DBOc\\tX1]x^y\ncOrEgOcS1LxFt\u0004"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.J.clusterNode(clusterController3.H.getName(), clusterController.H.getFullyQualifiedHostname(), clusterController.H.getFullyQualifiedInternalHostname(), clusterController.H.getPort(), clusterController.H.getInternalPort(), clusterController.H.getHttpPort());
            clusterController3.F.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.H.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.H.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.H.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.H.getInternalPort();
            object = String.format(ApplicationRestController.K((Object)"R_cXtDe\n\u007fEuO6Y1C\u007f^tX\u007fK}\nyEb^\u007fK|O>Z~Xe\n9\u000fb\u00104N8\nyKb\nrBpDvOu\u00061\n\u007fOf\ngK}_tY1\u000fb\u00104N?\nB^pXe\nPR~DBOc\\tX1]x^y\ncOrEgOcS1LxFt\u0004"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }
}

