/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.config.ClusterTemplate;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMembers;
import io.axoniq.axonserver.enterprise.cluster.internal.ManagedChannelHelper;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.ChannelManager;
import io.axoniq.axonserver.grpc.ChannelProvider;
import io.axoniq.axonserver.grpc.GrpcChannelProvider;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.TlsChannelCredentials;
import io.grpc.util.AdvancedTlsX509TrustManager;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import org.springframework.context.Lifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class ChannelManager
implements ChannelProvider,
GrpcChannelProvider,
ChannelExceptionHandler,
Lifecycle {
    private final MessagingPlatformConfiguration i;
    private final Map<ChannelKey, ManagedChannel> J;
    private final ReplicationGroupMembers h;
    private AdvancedTlsX509TrustManager.Closeable H;
    private final ExecutorService a;
    private final AdminNodes L;
    private final Supplier<ScheduledExecutorService> j;
    private ChannelCredentials F;
    private volatile boolean e;

    public Channel channelForNode(String string) {
        Object a3 = string;
        ChannelManager a4 = this;
        Object object = a3 = a4.L.findById((String)a3).map(a2 -> new ChannelKey(a2.getInternalHostName(), a2.getGrpcInternalPort().intValue())).orElseGet(() -> a4.K((String)a3));
        return a4.get(object.e, object.F);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelManager(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, ReplicationGroupMembers replicationGroupMembers, Supplier<ScheduledExecutorService> supplier) {
        Object a2;
        void a3;
        void a4;
        void a5;
        ChannelManager a6;
        ChannelManager channelManager = object;
        Object object = supplier;
        ChannelManager channelManager2 = a6 = channelManager;
        ChannelManager channelManager3 = a6;
        ChannelManager channelManager4 = a6;
        channelManager4.J = new ConcurrentHashMap();
        a6.i = a5;
        channelManager3.a = Executors.newFixedThreadPool(a6.i.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(SslConfiguration.K((Object)"\u001e\u007f\b`\tv\u000f>\u000fv\ff\u0018`\t>\u0018k\u0018p\bg\u0012aP")));
        channelManager3.L = a4;
        channelManager2.h = a3;
        channelManager2.j = a2;
    }

    private static /* synthetic */ MessagingPlatformException K(String a2) {
        return new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, a2 + ": Node not found");
    }

    public void stop() {
        ChannelManager a2;
        if (a2.H != null) {
            a2.H.close();
        }
        ChannelManager channelManager = a2;
        channelManager.a.shutdown();
        channelManager.J.forEach((channelKey, managedChannel) -> {
            ChannelManager a2 = managedChannel;
            ChannelManager a3 = this;
            if (!a2.isShutdown()) {
                try {
                    void a4;
                    a2.shutdown().awaitTermination(100L, TimeUnit.MILLISECONDS);
                    a3.J.remove(a4, a2);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        a2.e = false;
    }

    public boolean isRunning() {
        ChannelManager a2;
        return a2.e;
    }

    private /* synthetic */ ChannelKey K(String string) {
        Object a2 = string;
        ChannelManager a3 = this;
        a2 = (ReplicationGroupMember)a3.h.findByNodeName((String)a2).stream().findFirst().orElseThrow(() -> ChannelManager.K((String)a2));
        return new ChannelKey(a2.host(), a2.port());
    }

    /*
     * WARNING - void declaration
     */
    public void handleChannelException(String string, int n, Throwable throwable) {
        Status.Code a2;
        Object a3 = string;
        ChannelManager a4 = this;
        if ((a2 = Status.fromThrowable((Throwable)a2).getCode()).equals((Object)Status.Code.UNAVAILABLE) || a2.equals((Object)Status.Code.INTERNAL)) {
            void a5;
            a3 = new ChannelKey((String)a3, (int)a5);
            if ((a3 = (ManagedChannel)a4.J.remove(a3)) != null) {
                try {
                    if (!a3.shutdown().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                        a3.shutdownNow();
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Channel channelForAddress(String string, int n) {
        void a2;
        int a3 = n;
        ChannelManager a4 = this;
        return a4.get((String)a2, a3);
    }

    private /* synthetic */ boolean K() {
        ChannelManager a2;
        if (a2.i.getSsl() != null && a2.i.getSsl().isEnabled()) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        ChannelManager channelManager = this;
        if (channelManager.K()) {
            try {
                ChannelManager channelManager2;
                ChannelManager a2 = TlsChannelCredentials.newBuilder();
                AdvancedTlsX509TrustManager advancedTlsX509TrustManager = AdvancedTlsX509TrustManager.newBuilder().setVerification(channelManager.i.getSsl().getTrustManagerVerification()).build();
                if (channelManager.i.getSsl().getInternalTrustManagerFile() != null) {
                    channelManager.H = advancedTlsX509TrustManager.updateTrustCredentials(new File(channelManager.i.getSsl().getInternalTrustManagerFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)channelManager.j.get());
                    channelManager2 = a2;
                } else {
                    advancedTlsX509TrustManager.useSystemDefaultTrustCerts();
                    channelManager2 = a2;
                }
                TrustManager[] trustManagerArray = new TrustManager[1];
                trustManagerArray[0] = advancedTlsX509TrustManager;
                channelManager2.trustManager(trustManagerArray);
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray2[0] = advancedTlsX509TrustManager;
                channelManager.F = a2.trustManager(trustManagerArray2).build();
                v3 = channelManager;
            }
            catch (Exception a2) {
                throw new FailedToStartException(ClusterTemplate.K((Object)"'\n\u0013\u0006\u001e\u0001R\u0010\u001dD\u0011\u0016\u0017\u0005\u0006\u0001R'\u001a\u0005\u001c\n\u0017\b?\u0005\u001c\u0005\u0015\u0001\u0000"), (Throwable)a2);
            }
        } else {
            v3 = channelManager;
        }
        v3.e = true;
    }

    /*
     * WARNING - void declaration
     */
    public Channel get(String string, int n) {
        void a2;
        Object a3 = string;
        ChannelManager a4 = this;
        a3 = new ChannelKey((String)a3, (int)a2);
        return (Channel)a4.J.computeIfAbsent(a3, channelKey -> {
            ChannelManager a2;
            ChannelManager a3 = channelKey;
            ChannelManager channelManager = a2 = this;
            ChannelManager channelManager2 = a3;
            return ManagedChannelHelper.K((ExecutorService)channelManager.a, (MessagingPlatformConfiguration)channelManager.i, (String)channelManager2.e, (int)channelManager2.F, (ChannelCredentials)a2.F);
        });
    }
}

