/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.transport.rest.v2.ScheduledEventsRestControllerV2;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> E;
    private final Logger c;
    private final Topology l;
    private final CommandDispatcher K;
    private final AxonServerRoutingConfiguration d;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int i;
    private final AuthenticationProvider J;
    private final ContextProvider h;
    private final ClientIdRegistry H;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> a = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.K(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
    private final MeterFactory L;
    private final InstructionAckSource<SerializedCommandProviderInbound> j;
    private final ApplicationEventPublisher F;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> e = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.E.values());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(String string, StreamObserver streamObserver, SerializedCommandResponse serializedCommandResponse) {
        void a2;
        void a3;
        CommandService a4 = serializedCommandResponse;
        CommandService a5 = this;
        a5.K((String)a3, (SerializedCommandResponse)a4, (StreamObserver)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ByteString byteString, StreamObserver<SerializedCommandResponse> streamObserver) {
        void a2;
        CommandService a222 = byteString;
        CommandService a3 = this;
        a222 = new SerializedCommand((ByteString)a222);
        String string = a222.wrapped().getClientId();
        if (a3.c.isTraceEnabled()) {
            a3.c.trace(ScheduledEventsRestControllerV2.K((Object)"\r L}$8\u00158\u001f+\u00139V>\u00190\u001b<\u00189L}\r "), (Object)string, (Object)a222.wrapped().getName());
        }
        try {
            CommandService commandService = a3;
            commandService.K.dispatch(commandService.h.getContext(), (Authentication)a3.J.get(), (SerializedCommand)a222, arg_0 -> a3.K(string, (StreamObserver)a2, arg_0));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.c.warn(EventTransformationConfiguration.K((Object)"Ks|jnnlrfth:i{fvj~/mfng:ztjb\u007f\u007flnj~/\u007f}h`h"), (Throwable)exception);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(String string, SerializedCommandResponse serializedCommandResponse, StreamObserver<SerializedCommandResponse> streamObserver) {
        CommandService a22 = serializedCommandResponse;
        CommandService a3 = this;
        try {
            void a4;
            void v0 = a4;
            v0.onNext((Object)a22);
            v0.onCompleted();
            return;
        }
        catch (RuntimeException a22) {
            void a5;
            a3.c.debug(ScheduledEventsRestControllerV2.K((Object)"$8\u0005-\u00193\u00058V)\u0019}\u00151\u001f8\u0018)V&\u000b}\u0010<\u001f1\u00139"), (Object)a5, (Object)a22);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> instructionAckSource, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void commandDispatcher2;
        void topology2;
        CommandService a2;
        CommandService commandService = commandService2;
        CommandService commandService2 = axonServerRoutingConfiguration;
        CommandService commandService3 = a2 = commandService;
        CommandService commandService4 = a2;
        CommandService commandService5 = a2;
        CommandService commandService6 = a2;
        CommandService commandService7 = a2;
        a2.c = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService8 = a2;
        a2.E = new ConcurrentHashMap();
        commandService7.i = 1;
        commandService7.l = topology2;
        commandService6.K = commandDispatcher2;
        commandService6.h = contextProvider2;
        commandService5.J = authenticationProvider2;
        commandService5.H = clientIdRegistry2;
        commandService4.L = meterFactory2;
        commandService4.F = eventPublisher;
        commandService3.j = instructionAckSource2;
        commandService3.d = commandService2;
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> streamObserver) {
        void a2;
        CommandService commandService = this;
        String string = commandService.h.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService2 = commandService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)EventTransformationConfiguration.K((Object)"fu!{wuas~4nb`t|\u007f}ljh!}}jl4lubwntk4LubwntkIjhysl\u007f")).addMethod(e, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(a, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    @PreDestroy
    public void cleanup() {
        CommandService a2;
        a2.E.forEach((clientStreamIdentification, grpcCommandDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcCommandDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.E.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        CommandService a2 = clientStreamIdentification;
        CommandService a3 = this;
        if (a3.E.containsKey(a2)) {
            void a4;
            String string2 = "Command stream inactivity for " + a2.K();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcCommandDispatcherListener)a3.E.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            CommandService commandService = a3;
            commandService.c.debug(EventTransformationConfiguration.K((Object)"Lubwntk:\\n}\u007fnw/ycu|\u007fk:iu}:lvf\u007fan5:tg"), (Object)a2);
            commandService.F.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a2.e(), (String)a4, a2.K()));
        }
    }

    private /* synthetic */ boolean K(InstructionAck instructionAck) {
        CommandService a2 = instructionAck;
        CommandService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }
}

