/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.licensing;

import io.axoniq.axonserver.access.application.AccessControllerDB;
import io.axoniq.axonserver.config.AxonServerEnterpriseProperties;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.RequestReconnectController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.licensing.H;
import io.axoniq.axonserver.licensing.LicenseConfiguration;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.marketplace"}, havingValue="false", matchIfMissing=true)
public class FileLicenseManager
implements LicenseManager {
    private static final String I = "AXONIQ_LICENSE";
    private static final String b = "axoniq.license";
    private static final String g = "expiry_date";
    private final String G;
    private static final String B = "licensee";
    private static final String C = "license";
    private final AtomicReference<H> E;
    private static final String c = "grace_date";
    private static final String l = "license_key_id";
    private static final Logger K = AuditLog.getLogger();
    private static final String d = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA0xyNKA5aL42X7eXy1zwe\n9V6do3TYhrH7smWa6RBtCkhQ2holCEalrdiEX3LQoyhPmvV8lqWrDc9JHuYheWQL\npQXKB84sb9DCCWZWTPV0OZpe8nyotgmwBYohvEzTGLLRrAp+pM/J+/IVSiMyiP5E\nKf6ODcRWQH/us+4x4IsjTZC+o0HsYjSXG62Bo7pXFXLKjUqA3rpTyT1v3Yafgp4C\n78wHa/fqKCE562B2IEEhxWdsJl//wOsk/I8bYH+YoZtceGpRJlkMjK3t/KOExU61\nae5NJruyXbqRBWOtrcBb37b2cgykqaZlCwQczsZwl8Pglm1Yl0t8lTdTM+wxLErI\nAbxYE50UtvMLCaIG8lqT9W28UQgOr+RPdkEwUWYNeWWH2R0Kukva9loB+LBDe/Ce\nYhRvh41KpekJhU0NYjymCizNFohQ0rUDtt8p+i/IpIxfWBtgJODOrP2tbr8necX8\nX5oMyN4H/ar6favdWCHXi9FtTrHv1lchisXn3R9/obJptkxyZc8yvWuEBhXBFJ6H\nydOPNdbiWIH9TptZ2vaQrSFyaPR5yCoG/kyZ6o7TQE8lK6MrULiJNB/6ZKujri5x\nLovNJrtY/w69qVkC/8lIJhwJMSJKySeUYBhOjVN4f7vVEVYncYx8HJU2utQ1j6+e\n9T0pQ8CjhkOpmcTcaaMmU0UCAwEAAQ==";
    private static final String i = "product";
    private final AdminNodes J;
    private static final String h = "clusterNodes";
    private static final String H = "signature";
    private static final String a = "AxonServer";
    private final AtomicReference<Properties> L;
    private static final Logger j = LoggerFactory.getLogger(LicenseManager.class);
    private static final String F = "issue_date";
    private static final String e = "contexts";

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Properties K(byte[] byArray) {
        FileLicenseManager fileLicenseManager = this;
        j.debug(RequestReconnectController.K((Object)"M\n`\u0001h\u000bfEm\fb\u0000o\u0016dEg\u0017n\b!\u0006n\u000bu\u0000o\u0011/K/"));
        Properties a2 = new Properties();
        try {
            void a3;
            a2.load(new ByteArrayInputStream((byte[])a3));
            return a2;
        }
        catch (IOException iOException) {
            throw LicenseException.K();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createOrUpdate(byte[] byArray) {
        File file;
        Object a23;
        void a222;
        FileLicenseManager fileLicenseManager = this;
        j.debug(AccessControllerDB.K((Object)"P|jtb|rthz&scj&qo~csux(3("));
        FileLicenseManager fileLicenseManager2 = fileLicenseManager;
        Properties properties = fileLicenseManager2.K((byte[])a222);
        fileLicenseManager2.K(properties);
        String string = System.getProperty(C, System.getenv(I));
        if (StringUtils.isEmpty((String)string)) {
            a23 = new File(fileLicenseManager.G);
            if (!((File)a23).exists() && !((File)a23).mkdirs()) {
                throw new MessagingPlatformException(ErrorCode.OTHER, "Failed to create directory: " + ((File)a23).getAbsolutePath());
            }
            file = new File((File)a23, b);
        } else {
            file = new File(string);
        }
        a23 = new FileOutputStream(file);
        try {
            Object object = a23;
            ((FileOutputStream)object).write((byte[])a222);
            ((OutputStream)object).flush();
        }
        catch (Throwable a222) {
            try {
                Throwable throwable;
                try {
                    ((FileOutputStream)a23).close();
                    throwable = a222;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = a222;
                    throwable = throwable3;
                    throwable3.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException a23) {
                throw LicenseException.K((String)file.getAbsolutePath(), (Throwable)a23);
            }
        }
        ((FileOutputStream)a23).close();
        j.info(RequestReconnectController.K((Object)"+d\u0012!\th\u0006d\u000br\u0000!\u0016`\u0013d\u0001!\u0011nEz\u0018/"), (Object)file);
        FileLicenseManager fileLicenseManager3 = fileLicenseManager;
        fileLicenseManager3.E.set(H.L);
        fileLicenseManager3.e(properties.getProperty(i));
    }

    public LocalDate getGraceDate() {
        FileLicenseManager a2;
        return a2.K().getGraceDate();
    }

    private /* synthetic */ LicenseConfiguration K() {
        Object object = this;
        Object a2 = object.readLicenseProperties();
        if (a2 == null) {
            throw LicenseException.K();
        }
        a2 = new LicenseConfiguration(object.K(((Properties)a2).getProperty(g)), ((Properties)a2).getProperty(RequestReconnectController.K((Object)"d\u0001h\u0011h\no")), ((Properties)a2).getProperty(l), Integer.parseInt(((Properties)a2).getProperty(e, AccessControllerDB.K((Object)"7"))), Integer.parseInt(((Properties)a2).getProperty(h, RequestReconnectController.K((Object)"2"))), ((Properties)a2).getProperty(B), object.K(((Properties)a2).getProperty(c)), object.K(((Properties)a2).getProperty(F)), (Properties)a2);
        j.debug(AccessControllerDB.K((Object)"Jtexhncy&ii'&f{"), (Object)a2.getLicensee());
        j.debug(RequestReconnectController.K((Object)"S\u0010o\u000bh\u000bfEz\u0018!\bn\u0001d"), (Object)a2.getEdition());
        j.debug(AccessControllerDB.K((Object)"Jtexhnc=cevttd&ygic=on&f{"), (Object)a2.getExpiryDate());
        return a2;
    }

    public byte[] readLicense() {
        FileLicenseManager a2;
        j.info(AccessControllerDB.K((Object)"Qi|bthz&qo~csux&~isrxhi(3("));
        FileLicenseManager fileLicenseManager = a2;
        return fileLicenseManager.K(fileLicenseManager.K());
    }

    @NotNull
    private /* synthetic */ String K() {
        FileLicenseManager fileLicenseManager = this;
        String string = System.getProperty(C, System.getenv(I));
        Object a2 = null;
        if (string != null) {
            a2 = new File(string);
        }
        if (a2 == null || !((File)a2).exists()) {
            a2 = new File(fileLicenseManager.G, b);
            if (!((File)a2).exists()) {
                throw LicenseException.K((File)a2);
            }
            string = ((File)a2).getAbsolutePath();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ byte[] K(String string) {
        byte[] byArray;
        Object a2 = string;
        FileLicenseManager a3 = this;
        j.debug(RequestReconnectController.K((Object)")n\u0004e\fo\u0002!\th\u0006d\u000br\u0000!\u0006n\u000bu\u0000o\u0011!\u0003s\nlEz\u0018/K/"), a2);
        a2 = new File((String)a2);
        FileInputStream fileInputStream = new FileInputStream((File)a2);
        try {
            byte[] byArray2 = new byte[Math.toIntExact(((File)a2).length())];
            fileInputStream.read(byArray2);
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            try {
                fileInputStream.close();
                throwable2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                    throw throwable2;
                }
                catch (IOException iOException) {
                    throw LicenseException.K((File)a2);
                }
            }
        }
        fileInputStream.close();
        return byArray;
    }

    public void validate(byte[] byArray) {
        FileLicenseManager a2;
        Object a3 = byArray;
        FileLicenseManager fileLicenseManager = a2 = this;
        fileLicenseManager.K(fileLicenseManager.K((byte[])a3));
    }

    private /* synthetic */ boolean K(String string) {
        String a2 = string;
        FileLicenseManager a3 = this;
        if (a2 != null && a2.contains(a)) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void e(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        if (!H.j.equals((Object)a3.E.getAndSet(H.j))) {
            K.info(AccessControllerDB.K((Object)"Qo~csux&qi|bxb=gsb=p|jtb|rxb=`rt=!f{:("), a2);
        }
    }

    public long nodesCount() {
        FileLicenseManager a2;
        return a2.J.findAll().count();
    }

    public LocalDate getIssueDate() {
        FileLicenseManager a2;
        return a2.K().getIssueDate();
    }

    @EventListener
    @Order(value=-2147483648)
    public void on(ClusterEvents.LicenseUpdated licenseUpdated) {
        FileLicenseManager a2;
        FileLicenseManager a3 = licenseUpdated;
        FileLicenseManager fileLicenseManager = a2 = this;
        fileLicenseManager.K();
        fileLicenseManager.createOrUpdate(a3.getLicense());
    }

    public boolean isEnterprise() {
        FileLicenseManager a2;
        return a2.K().isEnterprise();
    }

    @Scheduled(fixedRate=3600000L, initialDelay=3600000L)
    private /* synthetic */ void K() {
        FileLicenseManager a2;
        j.debug(RequestReconnectController.K((Object)",o\u0013`\th\u0001`\u0011h\u000bfEb\u0004b\rd\u0001!\th\u0006d\u000br\u0000/K/"));
        a2.L.set(null);
    }

    private /* synthetic */ LocalDate K(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        if (StringUtils.isEmpty((String)a2)) {
            return null;
        }
        return LocalDate.parse((CharSequence)a2);
    }

    public Properties readLicenseProperties() {
        FileLicenseManager fileLicenseManager = this;
        Object a2 = (Properties)fileLicenseManager.L.get();
        if (a2 != null) {
            return a2;
        }
        FileLicenseManager fileLicenseManager2 = fileLicenseManager;
        a2 = fileLicenseManager2.K(fileLicenseManager2.K());
        fileLicenseManager2.K((Properties)a2);
        fileLicenseManager2.L.set(a2);
        return a2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void K(Properties properties) {
        String string;
        FileLicenseManager fileLicenseManager = this;
        try {
            void v3;
            void a22;
            block13: {
                Object object;
                KeyFactory keyFactory = KeyFactory.getInstance(AccessControllerDB.K((Object)"TNG"));
                Object a322 = Base64.getMimeDecoder().decode(d);
                a322 = new X509EncodedKeySpec((byte[])a322);
                a322 = keyFactory.generatePublic((KeySpec)a322);
                Object object2 = Signature.getInstance(RequestReconnectController.K((Object)"R-@W4Sv\fu\rS6@"));
                ((Signature)object2).initVerify((PublicKey)a322);
                Object object3 = a322 = new ArrayList<String>(a22.stringPropertyNames());
                Collections.sort(object3);
                if (!object3.remove(H)) {
                    throw LicenseException.K((String)AccessControllerDB.K((Object)"utasgisoc=`tcqb=ktunosa"));
                }
                Object object4 = a322 = a322.iterator();
                while (object4.hasNext()) {
                    object = (String)a322.next();
                    object4 = a322;
                    Signature signature = object2;
                    signature.update(((String)object).getBytes(StandardCharsets.UTF_8));
                    signature.update(a22.getProperty((String)object, "").getBytes(StandardCharsets.UTF_8));
                }
                boolean a322 = ((Signature)object2).verify(Base64.getDecoder().decode(a22.getProperty(H)));
                if (!a322) {
                    fileLicenseManager.K(RequestReconnectController.K((Object)"M\fb\u0000o\u0016dEr\ff\u000b`\u0011t\u0017dEh\u0016!\fo\u0013`\th\u0001/"));
                    throw LicenseException.K((String)AccessControllerDB.K((Object)"utasgisoc=osp|jtb"));
                }
                object = Objects.requireNonNull(fileLicenseManager.K(a22.getProperty(g)));
                LocalDate a322 = Objects.requireNonNull(fileLicenseManager.K(a22.getProperty(c)));
                object2 = LocalDate.now();
                if (((LocalDate)object2).isAfter((ChronoLocalDate)object)) {
                    if (((LocalDate)object2).isBefore(a322)) {
                        K.warn(RequestReconnectController.K((Object)")h\u0006d\u000br\u0000!\r`\u0016!\u0000y\u0015h\u0017d\u0001-E@\u001dn\u000bR\u0000s\u0013d\u0017!\u0012h\tmEb\no\u0011h\u000bt\u0000!\u0012n\u0017j\fo\u0002!\u0010o\u0011h\t!\u001e|"), (Object)a322);
                        j.warn(AccessControllerDB.K((Object)"Qo~csux&ugn&x~moocy*=GeisUxtkco&joqj=erhiossx&jiomthz&hhioq&f{"), (Object)a322);
                        v3 = a22;
                        break block13;
                    } else {
                        fileLicenseManager.K(RequestReconnectController.K((Object)"$y\no6d\u0017w\u0000sEM\fb\u0000o\u0016dEi\u0004rEd\u001dq\fs\u0000e"));
                        throw LicenseException.K((LocalDate)object);
                    }
                }
                v3 = a22;
            }
            string = v3.getProperty(i);
            if (!fileLicenseManager.K(string)) {
                throw LicenseException.e((String)string);
            }
            int a22 = Integer.parseInt((String)a22.get(h));
            long l = fileLicenseManager.nodesCount();
            if (l > (long)a22) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a22;
                objectArray[1] = l;
                fileLicenseManager.K(String.format(AccessControllerDB.K((Object)"Eqsnrxt=jtktrxb=rr&8b=dhr=`rssb=#y&siycn("), objectArray));
                throw LicenseException.K((int)a22, (long)l);
            }
        }
        catch (SignatureException signatureException) {
            fileLicenseManager.K(RequestReconnectController.K((Object)"6h\u0002o\u0004u\u0010s\u0000!\u0013`\th\u0001`\u0011h\noEg\u0004h\td\u0001/"));
            throw LicenseException.K((String)("SignatureException: " + signatureException.getMessage()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new Error(AccessControllerDB.K((Object)"Intu=uuihjy&sckco&ugmvxh"), generalSecurityException);
        }
        fileLicenseManager.e(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ Properties K(String string) {
        File a2;
        FileLicenseManager fileLicenseManager = this;
        j.debug(AccessControllerDB.K((Object)"Jrgyosa=jtexhnc=voimcortcn&{trk=}`(3("), (Object)a2);
        a2 = new File((String)((Object)a2));
        Properties properties = new Properties();
        FileInputStream a32 = new FileInputStream(a2);
        try {
            properties.load(a32);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            try {
                a32.close();
                throwable2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                    throw throwable2;
                }
                catch (IOException a32) {
                    throw LicenseException.K((File)a2);
                }
            }
        }
        a32.close();
        return properties;
    }

    public boolean validateSilently() {
        FileLicenseManager fileLicenseManager = this;
        try {
            fileLicenseManager.K();
        }
        catch (Exception a2) {
            fileLicenseManager.K(a2.getMessage());
            return false;
        }
        return true;
    }

    private /* synthetic */ void K(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        if (!H.e.equals((Object)a3.E.getAndSet(H.e))) {
            K.error(RequestReconnectController.K((Object)")h\u0006d\u000br\u0000!\u0013`\th\u0001`\u0011h\noEg\u0004h\td\u0001;Ez\u0018/"), a2);
            j.error(AccessControllerDB.K((Object)"Qo~csux&kgqoygiorh=`|oqcy<=}`("), a2);
        }
    }

    public LocalDate getExpiryDate() {
        FileLicenseManager a2;
        return a2.K().getExpiryDate();
    }

    public String property(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        return a3.readLicenseProperties().getProperty((String)a2);
    }

    public boolean validateSilently(byte[] byArray) {
        Object a22 = byArray;
        FileLicenseManager a3 = this;
        try {
            FileLicenseManager fileLicenseManager = a3;
            a22 = fileLicenseManager.K((byte[])a22);
            fileLicenseManager.K((Properties)a22);
        }
        catch (Exception a22) {
            a3.K(a22.getMessage());
            return false;
        }
        j.debug(RequestReconnectController.K((Object)")h\u0006d\u000br\u0000!\u0013`\th\u0001`\u0011d\u0001/"));
        return true;
    }

    public int getClusterNodes() {
        FileLicenseManager a2;
        return a2.K().getClusterNodes();
    }

    /*
     * WARNING - void declaration
     */
    public FileLicenseManager(AxonServerEnterpriseProperties axonServerEnterpriseProperties, AdminNodes adminNodes) {
        void a2;
        FileLicenseManager a3;
        FileLicenseManager a4 = axonServerEnterpriseProperties;
        FileLicenseManager fileLicenseManager = a3 = this;
        FileLicenseManager fileLicenseManager2 = a3;
        fileLicenseManager.L = new AtomicReference();
        FileLicenseManager fileLicenseManager3 = a3;
        fileLicenseManager.E = new AtomicReference<H>(H.L);
        fileLicenseManager.G = a4.getLicenseDirectory() == null ? Paths.get("", new String[0]).toAbsolutePath().toString() : a4.getLicenseDirectory();
        a3.J = a2;
    }
}

