/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.access.application.AccessControllerDB;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventStreamReader;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.D;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private static final String b = "aggregateMap";
    private final MeterFactory.RateMeter g;
    private final Supplier<IndexManager> G;
    private final ConcurrentSkipListMap<FileVersion, D> B;
    private final EventType C;
    private final String E;
    private final AtomicLong c;
    private final MeterFactory.RateMeter l;
    protected final String K;
    protected final Supplier<StorageProperties> d;
    private final Counter i;
    private static final ScheduledExecutorService J;
    private final RemoteAggregateSequenceNumberResolver h;
    private final ConcurrentNavigableMap<Long, Integer> H;
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> a;
    private final Counter L;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> j;
    private static final Logger F;
    private ScheduledFuture<?> e;

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String string, long l, long l2, long l3, long l4) {
        void a2;
        void a3;
        Iterator iterator;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        Object[] objectArray = new Object[4];
        objectArray[0] = standardIndexManager.K;
        objectArray[1] = a6;
        objectArray[2] = (long)a5;
        objectArray[3] = (long)a4;
        F.debug(AccessControllerDB.K((Object)"f{'&qirmhv\\aztxa|rx&f{=kthNclsxh~cSspdxt=}`*=j|uiUxwhcsexHhk\u007fco&f{"), objectArray);
        long l5 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = standardIndexManager.a.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l6 = (Long)iterator.next();
            if (l5 < a3) {
                return a7;
            }
            IndexEntries indexEntries = (IndexEntries)standardIndexManager.a.getOrDefault(l6, Collections.emptyMap()).get(a6);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.K((long)a5, (long)a4, (SortedMap)a7, new FileVersion(l6.longValue(), 0), indexEntries);
                if (standardIndexManager2.K((long)a5, (long)(a2 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            l5 = l6;
            iterator2 = iterator;
        }
        TreeMap treeMap = a7;
        treeMap.putAll(standardIndexManager.lookupAggregateInClosedSegments((String)a6, (long)a5, (long)a4, (long)a2, (long)a3, l5));
        return treeMap;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ IndexEntries K(FileVersion fileVersion, String string) {
        int n;
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        if (standardIndexManager.K((FileVersion)a3, (String)a2)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                StandardIndexManager a4 = standardIndexManager.K((FileVersion)a3);
                return a4.K((String)a2);
            }
            catch (IndexNotFoundException a4) {
                return null;
            }
            catch (Exception a4) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a3.K() + " segment.", a4);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return a3.K((FileVersion)a2).K();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int K(long l, long l2, SortedMap<FileVersion, IndexEntries> sortedMap, FileVersion fileVersion, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!(a4 = a4.range((long)a3, (long)a2, EventType.j.equals((Object)a5.C))).isEmpty()) {
            void a6;
            void a7;
            a7.put(a6, a4);
        }
        return a4.size();
    }

    /*
     * WARNING - void declaration
     */
    public void createNewVersion(long l, int n, Map<String, List<IndexEntry>> map) {
        StandardIndexManager standardIndexManager;
        HTreeMap hTreeMap;
        Map<String, List> a2;
        FileVersion a222;
        StandardIndexManager standardIndexManager2;
        block12: {
            StandardIndexManager a3;
            block7: {
                StandardIndexManager standardIndexManager3;
                block11: {
                    block10: {
                        block9: {
                            void a222;
                            void a4;
                            standardIndexManager2 = this;
                            a222 = new FileVersion((long)a4, (int)a222);
                            if (a2 == null) {
                                a2 = Collections.emptyMap();
                            }
                            if (!FileUtils.K((File)(a4 = ((StorageProperties)standardIndexManager2.d.get()).transformedIndex(standardIndexManager2.E, a222)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a4);
                            }
                            a3 = DBMaker.fileDB((File)a4);
                            if (!((StorageProperties)standardIndexManager2.d.get()).isUseMmapIndex()) break block9;
                            a3.fileMmapEnable();
                            if (!((StorageProperties)standardIndexManager2.d.get()).isForceCleanMmapIndex()) break block10;
                            StandardIndexManager standardIndexManager4 = a3;
                            standardIndexManager3 = standardIndexManager4;
                            standardIndexManager4.cleanerHackEnable();
                            break block11;
                        }
                        a3.fileChannelEnable();
                    }
                    standardIndexManager3 = a3;
                }
                a3 = standardIndexManager3.make();
                hTreeMap = a3.hashMap(b, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.K()).createOrOpen();
                try {
                    a2.forEach((string, list) -> {
                        void a2;
                        int n;
                        List a3 = list;
                        HTreeMap a4 = hTreeMap;
                        IndexEntry indexEntry = (IndexEntry)a3.get(0);
                        Integer[] integerArray = new Integer[a3.size()];
                        int n2 = n = 0;
                        while (n2 < a3.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a3.get(n3)).K();
                            n2 = n;
                        }
                        a4.put((Object)a2, (Object)new StandardIndexEntries(indexEntry.e(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    standardIndexManager = a3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            standardIndexManager = a3;
        }
        standardIndexManager.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)standardIndexManager2.d.get()).bloomFilter(standardIndexManager2.E, a222).getAbsolutePath(), a2.keySet().size(), ((StorageProperties)standardIndexManager2.d.get()).getBloomIndexFpp());
        hTreeMap2.K();
        hTreeMap2.K(a2.keySet());
        hTreeMap2.e();
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntries(String string, long l) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Long l2 : standardIndexManager.a.descendingKeySet()) {
            StandardIndexManager a4 = (IndexEntries)((Map)standardIndexManager.a.get(l2)).get(a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(new FileVersion(l2.longValue(), 0), standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.j.equals((Object)standardIndexManager.C)));
        }
        if (!standardIndexManager.H.isEmpty()) {
            return standardIndexManager.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, ((Long)standardIndexManager.H.keySet().first()).longValue());
        }
        return null;
    }

    public void addExistingIndex(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.H.put(a2.K(), a2.K());
        a3.K();
    }

    private static /* synthetic */ IndexEntries e(List list, String string) {
        String a2 = string;
        List a3 = list;
        return new StandardIndexEntries(((IndexEntry)a3.get(0)).e());
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, RemoteAggregateSequenceNumberResolver remoteAggregateSequenceNumberResolver, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager a8;
        Object a9 = string;
        StandardIndexManager standardIndexManager = a8 = this;
        StandardIndexManager standardIndexManager2 = a8;
        StandardIndexManager standardIndexManager3 = a8;
        StandardIndexManager standardIndexManager4 = a8;
        a8.a = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a8;
        standardIndexManager4.j = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a8;
        a8.B = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a8;
        standardIndexManager3.H = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a8;
        standardIndexManager3.c = new AtomicLong();
        standardIndexManager3.d = a7;
        standardIndexManager2.E = a6;
        standardIndexManager2.K = a9;
        standardIndexManager.C = a5;
        standardIndexManager.h = a4;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a9;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a9 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a8;
        void v10 = a3;
        a8.l = a3.rateMeter((MetricName)BaseMetricName.F, (Tags)a9);
        a8.g = v10.rateMeter((MetricName)BaseMetricName.Ya, (Tags)a9);
        standardIndexManager9.L = v10.counter((MetricName)BaseMetricName.Fa, (Tags)a9);
        standardIndexManager9.i = a3.counter((MetricName)BaseMetricName.i, (Tags)a9);
        J.scheduleAtFixedRate(() -> {
            Object a2;
            StandardIndexManager standardIndexManager = this;
            StorageProperties storageProperties = (StorageProperties)standardIndexManager.d.get();
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            while (standardIndexManager2.B.size() > storageProperties.getMaxIndexesInMemory()) {
                a2 = standardIndexManager.B.pollFirstEntry();
                F.debug(EventStreamReader.K((Object)"\u0013?Rb+.\u00071\u0001,\u000fb\u0001,\f'\u0010b\u0013?"), (Object)standardIndexManager.K, a2.getKey());
                standardIndexManager.e = J.schedule(() -> StandardIndexManager.K((Map.Entry)a2), 2L, TimeUnit.SECONDS);
                standardIndexManager2 = standardIndexManager;
            }
            StandardIndexManager standardIndexManager3 = standardIndexManager;
            while (standardIndexManager3.j.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager4 = standardIndexManager;
                standardIndexManager3 = standardIndexManager4;
                a2 = standardIndexManager4.j.pollFirstEntry();
                StandardIndexManager standardIndexManager5 = standardIndexManager;
                F.debug(AccessControllerDB.K((Object)"}`<=Txkrpxb=dqirk=`tjico&{io&f{=`oip&pcpio\u007f"), (Object)standardIndexManager5.K, a2.getKey());
                standardIndexManager5.i.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a8.G = a2;
    }

    private static /* synthetic */ boolean K(long l, int n, Map.Entry entry) {
        long a2;
        Map.Entry a3 = entry;
        int a4 = n;
        if ((Long)a3.getKey() > a2 || (Integer)a3.getValue() > a4) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void createIndex(FileVersion fileVersion, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        Object a4 = new HashMap();
        a3.forEach((arg_0, arg_1) -> StandardIndexManager.K((Map)a4, arg_0, arg_1));
        standardIndexManager.K((FileVersion)a2, (Map)a4);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> K(String string, int n, long l) {
        void a52222;
        void a52222;
        void a2;
        Map map;
        void a3;
        void a4;
        StandardIndexManager standardIndexManager = this;
        int n2 = 0;
        for (Long a52222 : standardIndexManager.a.descendingKeySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if (a52222 > a3 || (map = (Map)standardIndexManager.a.get(a52222)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n2;
        }
        for (Map.Entry a52222 : standardIndexManager.H.entrySet()) {
            if (n2 >= a4) {
                return Optional.empty();
            }
            if ((Long)a52222.getKey() > a3) continue;
            map = standardIndexManager.K(new FileVersion(((Long)a52222.getKey()).longValue(), ((Integer)a52222.getValue()).intValue()), (String)a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n2;
        }
        Iterator<Object> iterator = (StandardIndexManager)standardIndexManager.G.get();
        Optional a52222 = Optional.empty();
        if (iterator != null) {
            Optional a52222 = iterator.K((String)a2, (int)(a4 - n2), (long)a3);
        }
        if (a52222.isEmpty() && standardIndexManager.h != null && n2 < a4 && !standardIndexManager.H.isEmpty()) {
            StandardIndexManager standardIndexManager2 = standardIndexManager;
            Optional a52222 = standardIndexManager2.h.getLastSequenceNumber(standardIndexManager2.K, (String)a2, (int)(a4 - n2), (Long)standardIndexManager.H.keySet().last() - 1L);
        }
        return a52222;
    }

    /*
     * WARNING - void declaration
     */
    public Mono<Void> activateVersion(FileVersion fileVersion, File file) {
        void a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager a4 = this;
        if (a4.H.containsKey(a3.K())) {
            return a4.K((FileVersion)a3, (File)a2);
        }
        IndexManager indexManager = (IndexManager)a4.G.get();
        if (indexManager != null) {
            return indexManager.activateVersion((FileVersion)a3, (File)a2);
        }
        return Mono.empty();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void e(FileVersion fileVersion, Map<String, IndexEntries> map) {
        DBMaker.Maker maker;
        void a2;
        File file;
        Map a3;
        StorageProperties storageProperties;
        StandardIndexManager standardIndexManager;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            standardIndexManager = this;
                            storageProperties = (StorageProperties)standardIndexManager.d.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.K((File)(file = storageProperties.indexTemp(standardIndexManager.E, a2.K())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                StandardIndexManager a4 = maker2.hashMap(b, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.K()).createOrOpen();
                try {
                    a4.putAll(a3);
                    if (a4 == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (a4 != null) {
                            try {
                                a4.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                a4.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(standardIndexManager.E, (FileVersion)a2).toPath(), copyOptionArray);
        }
        catch (IOException a4) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(standardIndexManager.E, (FileVersion)a2), (Throwable)a4);
        }
        StandardIndexManager standardIndexManager2 = a4 = new PersistedBloomFilter(storageProperties.bloomFilter(standardIndexManager.E, (FileVersion)a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        standardIndexManager2.K();
        standardIndexManager2.K(a3.keySet());
        standardIndexManager2.e();
        standardIndexManager.j.put(a2, a4);
        standardIndexManager.H.put(a2.K(), a2.K());
        standardIndexManager.K((FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> getLastSequenceNumber(String string, EventStorageEngine.SearchHint searchHint, long l) {
        void a2;
        void a3;
        StandardIndexManager a222 = searchHint;
        StandardIndexManager a4 = this;
        int a222 = a222.equals((Object)EventStorageEngine.SearchHint.j) ? ((StorageProperties)a4.d.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a4.K((String)a3, a222, (long)a2);
    }

    public void init() {
        int n;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.d.get();
        String[] stringArray = FileUtils.K((File)new File(standardIndexManager.E), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            StandardIndexManager a2 = FileUtils.K((String)stringArray[n]);
            if (storageProperties.dataFile(standardIndexManager.E, (FileVersion)a2).exists()) {
                standardIndexManager.H.compute(a2.K(), (arg_0, arg_1) -> StandardIndexManager.K((FileVersion)a2, arg_0, arg_1));
            } else {
                standardIndexManager.remove((FileVersion)a2);
            }
            n3 = ++n;
        }
        standardIndexManager.K();
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup(boolean bl) {
        void a2;
        StandardIndexManager standardIndexManager;
        StandardIndexManager standardIndexManager2 = standardIndexManager = this;
        standardIndexManager2.a.clear();
        standardIndexManager2.j.clear();
        standardIndexManager2.B.forEach((fileVersion, d2) -> {
            FileVersion a2 = d2;
            FileVersion a3 = fileVersion;
            a2.close();
        });
        StandardIndexManager standardIndexManager3 = standardIndexManager;
        standardIndexManager3.B.clear();
        if (standardIndexManager3.e != null && !standardIndexManager.e.isDone()) {
            standardIndexManager.e.cancel(true);
        }
        if (a2 != false) {
            standardIndexManager.H.keySet().forEach(arg_0 -> standardIndexManager.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager4 = standardIndexManager;
        standardIndexManager4.H.clear();
        StandardIndexManager a3 = (IndexManager)standardIndexManager4.G.get();
        if (a3 != null) {
            a3.cleanup((boolean)a2);
        }
    }

    public Mono<Void> activateVersion(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return Mono.defer(() -> a3.K((FileVersion)a2));
    }

    /*
     * WARNING - void declaration
     */
    public Stream<File> getBackupFilenames(long l, int n) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        StandardIndexManager a4 = (StorageProperties)standardIndexManager.d.get();
        return standardIndexManager.H.entrySet().stream().filter(arg_0 -> StandardIndexManager.K((long)a3, (int)a2, arg_0)).flatMap(arg_0 -> standardIndexManager.K((StorageProperties)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String string, long l, long l2) {
        void a2;
        void a3;
        StandardIndexManager standardIndexManager = this;
        for (Map.Entry entry : standardIndexManager.H.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            StandardIndexManager a4 = standardIndexManager.K(fileVersion, (String)a3);
            if (a4 == null || a4.firstSequenceNumber() >= a2) continue;
            StandardIndexManager standardIndexManager2 = a4;
            return new SegmentIndexEntries(fileVersion, standardIndexManager2.range(standardIndexManager2.firstSequenceNumber(), (long)a2, EventType.j.equals((Object)standardIndexManager.C)));
        }
        IndexManager a5 = (IndexManager)standardIndexManager.G.get();
        if (a5 != null) {
            return a5.lastIndexEntriesFromClosedSegments((String)a3, (long)a2, (Long)standardIndexManager.H.keySet().last() - 1L);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllVersions(long l) {
        Integer n;
        void a2;
        StandardIndexManager standardIndexManager = this;
        StorageProperties storageProperties = (StorageProperties)standardIndexManager.d.get();
        if (standardIndexManager.a.remove((long)a2) == null && (n = (Integer)standardIndexManager.H.remove((long)a2)) != null) {
            FileVersion fileVersion;
            int a222;
            int n2 = a222 = 0;
            while (n2 < n) {
                fileVersion = new FileVersion((long)a2, a222);
                if (storageProperties.index(standardIndexManager.E, fileVersion).exists()) {
                    standardIndexManager.remove(fileVersion);
                }
                n2 = ++a222;
            }
            FileVersion a222 = new FileVersion((long)a2, n.intValue());
            fileVersion = (D)standardIndexManager.B.remove(a222);
            if (fileVersion != null) {
                fileVersion.close();
            }
            standardIndexManager.j.remove(a222);
        }
        if (FileUtils.K((File)storageProperties.index(standardIndexManager.E, (long)a2)) && FileUtils.K((File)storageProperties.bloomFilter(standardIndexManager.E, (long)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String string, long l, long l2, long l3, long l4, long l5) {
        void a2;
        void a3;
        void a4;
        void a5;
        long a6;
        IndexManager indexManager;
        StandardIndexManager standardIndexManager = this;
        TreeMap a7 = new TreeMap();
        IndexManager indexManager2 = indexManager = standardIndexManager.H.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a6 < a5) {
                return a7;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = standardIndexManager.K(fileVersion, (String)a4);
            Object[] objectArray = new Object[4];
            objectArray[0] = standardIndexManager.K;
            objectArray[1] = a4;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            F.debug(AccessControllerDB.K((Object)"}`<=jrivsmGzaoczgic=}`&th=uxapcsr=}`&{ihhy&f{"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager2 = standardIndexManager;
                int n = standardIndexManager2.K((long)a3, (long)a2, (SortedMap)a7, fileVersion, indexEntries);
                if (standardIndexManager2.K((long)a3, (long)(a8 -= (long)n), indexEntries)) {
                    return a7;
                }
            }
            a6 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)standardIndexManager.G.get();
        if (indexManager != null) {
            void a8;
            a7.putAll(indexManager.lookupAggregateInClosedSegments((String)a4, (long)a3, (long)a2, (long)a8, (long)a5, a6));
        }
        return a7;
    }

    public boolean remove(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        D d2 = (D)a3.B.remove(a2);
        if (d2 != null) {
            d2.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.j.remove(a2);
        if (FileUtils.K((File)((StorageProperties)standardIndexManager.d.get()).index(a3.E, (FileVersion)a2)) && FileUtils.K((File)((StorageProperties)a3.d.get()).bloomFilter(a3.E, (FileVersion)a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(Long l, String string, List list) {
        void a3;
        void a4;
        Object a5 = list;
        StandardIndexManager a6 = this;
        a6.a.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a3, arg_0 -> StandardIndexManager.e((List)a5, arg_0)).addAll((List)a5);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Stream K(StorageProperties storageProperties, Map.Entry entry) {
        void a2;
        Map.Entry a3 = entry;
        StandardIndexManager a4 = this;
        File[] fileArray = new File[2];
        fileArray[0] = a2.index(a4.E, ((Long)a3.getKey()).longValue());
        fileArray[1] = a2.bloomFilter(a4.E, ((Long)a3.getKey()).longValue());
        return Stream.of(fileArray);
    }

    private static /* synthetic */ void K(Map.Entry a2) {
        ((D)a2.getValue()).close();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono K(FileVersion fileVersion) {
        void a2;
        StandardIndexManager standardIndexManager = this;
        Object a3 = ((StorageProperties)standardIndexManager.d.get()).transformedIndex(standardIndexManager.E, (FileVersion)a2);
        return standardIndexManager.activateVersion((FileVersion)a2, (File)a3);
    }

    public boolean validIndex(FileVersion fileVersion) {
        block3: {
            boolean bl;
            StandardIndexManager a2;
            block4: {
                a2 = fileVersion;
                StandardIndexManager a3 = this;
                if (!a3.H.containsKey(a2.K()) || ((Integer)a3.H.get(a2.K())).intValue() != a2.K()) break block3;
                if (a3.K((FileVersion)a2) == null || a3.K((FileVersion)a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                F.warn(EventStreamReader.K((Object)".#\u0001.\r&H6\u0007b\u001e#\u0004+\f#\u001c'H+\u0006&\r:H$\u00070H1\r%\u0005'\u00066Rb\u0013?"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean K(long l, long l2, IndexEntries indexEntries) {
        void a2;
        void a3;
        StandardIndexManager a4;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntries;
        StandardIndexManager a5 = standardIndexManager;
        if (!a4.isEmpty() && a3 >= a4.firstSequenceNumber() || a2 <= 0L) {
            return true;
        }
        return false;
    }

    static {
        F = LoggerFactory.getLogger(StandardIndexManager.class);
        J = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(EventStreamReader.K((Object)"\u0001,\f'\u0010o\u0005#\u0006#\u000f'\u001ao")));
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory, Supplier<IndexManager> supplier2) {
        Object a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        StandardIndexManager standardIndexManager = object;
        Object object = supplier2;
        StandardIndexManager a8 = standardIndexManager;
        a8((String)a7, (Supplier)a6, (String)a5, (EventType)a4, null, (MeterFactory)a3, (Supplier)a2);
    }

    private static /* synthetic */ Mono K(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.fromSupplier(() -> a3).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(file3 -> {
            File a2 = a2;
            File a3 = a3;
            return FileUtils.K((File)a3, (File)a2);
        });
    }

    public List<File> indexFiles(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.d.get()).index(a3.E, (FileVersion)a2);
        fileArray[1] = ((StorageProperties)a3.d.get()).bloomFilter(a3.E, (FileVersion)a2);
        return Arrays.asList(fileArray);
    }

    public void complete(FileVersion fileVersion) {
        StandardIndexManager a2;
        StandardIndexManager a3 = fileVersion;
        StandardIndexManager standardIndexManager = a2 = this;
        standardIndexManager.e((FileVersion)a3, (Map)standardIndexManager.a.get(a3.K()));
        a2.a.remove(a3.K());
        a2.K();
    }

    private /* synthetic */ void K() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.c.set(standardIndexManager.H.keySet().stream().skip(((StorageProperties)a2.d.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Mono<Void> K(FileVersion fileVersion, File file) {
        void a3;
        StandardIndexManager a4 = fileVersion;
        StandardIndexManager a5 = this;
        return Mono.fromSupplier(() -> a5.K((FileVersion)a4)).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(arg_0 -> StandardIndexManager.K((File)a3, arg_0)).doOnSuccess(arg_0 -> a5.K((FileVersion)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void K(Map map, String string2, List list) {
        void a2;
        List a3 = list;
        Map a4 = map;
        a4.computeIfAbsent(a2, string -> {
            String a2 = string;
            List a3 = a3;
            return new StandardIndexEntries(((IndexEntry)a3.get(0)).e());
        }).addAll(a3);
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(long l, String string, IndexEntry indexEntry) {
        StandardIndexManager a3;
        void a4;
        void a5;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = indexEntry;
        StandardIndexManager a6 = standardIndexManager;
        if (a6.H.containsKey((long)a5)) {
            throw new IndexNotFoundException((long)a5 + ": already completed");
        }
        a6.a.computeIfAbsent((long)a5, a2 -> new ConcurrentHashMap()).computeIfAbsent(a4, arg_0 -> StandardIndexManager.K((IndexEntry)a3, arg_0)).add((IndexEntry)a3);
    }

    private static /* synthetic */ IndexEntries K(IndexEntry indexEntry, String string) {
        Object a2 = string;
        IndexEntry a3 = indexEntry;
        return new StandardIndexEntries(a3.e());
    }

    private /* synthetic */ void K(FileVersion fileVersion, Void void_) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        a3.H.put(a2.K(), a2.K());
    }

    public long size() {
        return 0L;
    }

    private /* synthetic */ D K(FileVersion fileVersion2) {
        StandardIndexManager a2 = fileVersion2;
        StandardIndexManager a3 = this;
        try {
            return a3.B.computeIfAbsent(a2, fileVersion -> {
                StandardIndexManager a2 = fileVersion;
                StandardIndexManager a3 = this;
                return new D(a3, (FileVersion)a2);
            }).K();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a2 = (D)a3.B.remove(a2);
            if (a2 != null) {
                a2.close();
            }
            throw indexNotFoundException;
        }
    }

    private /* synthetic */ File K(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.d.get()).index(a3.E, (FileVersion)a2);
    }

    /*
     * WARNING - void declaration
     */
    public StandardIndexManager(String string, Supplier<StorageProperties> supplier, String string2, EventType eventType, MeterFactory meterFactory) {
        StandardIndexManager a2;
        void a3;
        void a4;
        void a5;
        void a6;
        StandardIndexManager standardIndexManager = standardIndexManager2;
        StandardIndexManager standardIndexManager2 = meterFactory;
        StandardIndexManager a7 = standardIndexManager;
        a7((String)a6, (Supplier)a5, (String)a4, (EventType)a3, null, (MeterFactory)a2, () -> null);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean K(FileVersion fileVersion2, String string) {
        void a2;
        StandardIndexManager a3 = fileVersion2;
        StandardIndexManager a4 = this;
        if ((a3 = a4.j.computeIfAbsent(a3, fileVersion -> {
            StandardIndexManager a2 = fileVersion;
            StandardIndexManager a3 = this;
            F.debug(EventStreamReader.K((Object)"\u0013?Rb\u00072\r,H \u0004-\u0007/H$\u0001.\u001c'\u001ab\u000e-\u001ab\u0013?"), (Object)a3.K, (Object)a2.K());
            StorageProperties storageProperties = (StorageProperties)a3.d.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.E, (FileVersion)a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.K()) {
                return null;
            }
            a3.L.increment();
            StandardIndexManager standardIndexManager = a2;
            standardIndexManager.h();
            return standardIndexManager;
        })) != null && !a3.K((String)a2)) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ Integer K(FileVersion fileVersion, Long l, Integer n) {
        Integer a2 = n;
        FileVersion a3 = fileVersion;
        return a2 == null ? a3.K() : Math.max(a3.K(), a2);
    }

    /*
     * WARNING - void declaration
     */
    public void K(FileVersion fileVersion, Map<String, IndexEntries> map) {
        void a2;
        StandardIndexManager a3 = this;
        StandardIndexManager a4 = fileVersion;
        if (a3.K((FileVersion)a4)) {
            a3.e((FileVersion)a4, (Map)a2);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a3.G.get();
        if (standardIndexManager != null) {
            standardIndexManager.K((FileVersion)a4, (Map)a2);
        }
    }

    private /* synthetic */ boolean K(FileVersion fileVersion) {
        StandardIndexManager a2 = fileVersion;
        StandardIndexManager a3 = this;
        return ((StorageProperties)a3.d.get()).dataFile(a3.E, (FileVersion)a2).exists();
    }

    /*
     * WARNING - void declaration
     */
    public void addToActiveSegment(Long l, Map<String, List<IndexEntry>> map) {
        void a2;
        Object a3 = l;
        StandardIndexManager a4 = this;
        if (a4.H.containsKey(a3)) {
            throw new IndexNotFoundException((Long)a3 + ": already completed");
        }
        a2.forEach((arg_0, arg_1) -> a4.K((Long)a3, arg_0, arg_1));
    }
}

