/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.logging.H;
import io.axoniq.axonserver.rest.svg.Fonts;
import io.axoniq.axonserver.transport.rest.v2.HealthRestControllerV2;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger e = AuditLog.getLogger();

    @EventListener
    public void on(AbstractAuthenticationEvent abstractAuthenticationEvent) {
        AuditLog a2 = abstractAuthenticationEvent;
        AuditLog a3 = this;
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (e.isDebugEnabled()) {
            e.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            e.info(Fonts.K((Object)"j0A6H\u007fQ6R7\u0006*U:T1G2C\u007f\u0004$[}\b"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            e.error(HealthRestControllerV2.K((Object)"vp]vT?MvNw\u001ajIzHq[r_?\u0018dG=\u001aY{VvZ~%\u001adG"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    public static String username(String a2) {
        if (a2 == null) {
            return Fonts.K((Object)"\u001a>H0H&K0S,\u0018");
        }
        return StringUtils.sanitize((String)a2);
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated adminUserUpdated) {
        AuditLog a2 = adminUserUpdated;
        AuditLog a3 = this;
        if (e.isDebugEnabled()) {
            e.debug(a2.toString());
        }
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + H.e.K()[2].getName()));
    }

    public AuditLog() {
        AuditLog a2;
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted adminUserDeleted) {
        AuditLog a2 = adminUserDeleted;
        AuditLog a3 = this;
        if (e.isDebugEnabled()) {
            e.debug(a2.toString());
        }
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return HealthRestControllerV2.K((Object)"\u0006~TpTfWpOl\u0004");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return Fonts.K((Object)"c\u0011g\u001dj\u001ab");
        }
        return HealthRestControllerV2.K((Object)"[sL{]vZ~");
    }
}

