/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.message.ContextClusterMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StreamObserverUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final int a = 25000;
    private final long L;
    private final Logger j;
    private final long F;
    private final Map<String, ActiveQuery> e;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.j.debug(ContextClusterMetrics.K((Object)"(V\u0006I\u0007\\\u001f\\KH\u001e\\\u0019@KB\u0016\u0019\rV\u0019\u0019\u001aL\u000eK\u0012\u0019\u0003X\u0005]\u0007\\\u0019\u0019\u0002]\u000eW\u001fP\rP\u000e]K[\u0012\u0019\bU\u0002\\\u0005M8M\u0019\\\nT\"]KB\u0016\u0017"), (Object)a2.e(), a3);
        if (a2.h((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.K((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(StreamObserverUtils.K((Object)"G)j(a%p/k($2kfl'j\"h#vf!5$*k5p"), objectArray))) {
                a4.remove(a2.e());
            }
        }
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.e.forEach((arg_0, arg_1) -> a3.K((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.e.isEmpty();
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.e.get(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.K((ActiveQuery)a3, a2.e());
    }

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.j = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.a = 25000;
        QueryCache queryCache3 = this;
        queryCache.e = new ConcurrentHashMap();
        queryCache.F = defaultQueryTimeout;
        if (a2 > 0L) {
            this.L = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.L = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.j.debug(StreamObserverUtils.K((Object)"V#i)r#$+a5w'c#M\"$=y"), a3);
        return (ActiveQuery)queryCache.e.remove(a3);
    }

    public int size() {
        QueryCache a2;
        return a2.e.size();
    }

    private /* synthetic */ void K() {
        QueryCache a2;
        if ((long)a2.e.size() >= a2.L) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.L + "/" + a2.L + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.e.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.K();
        return (ActiveQuery)queryCache.e.putIfAbsent(a2, a4);
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l = System.currentTimeMillis() - a4.F;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).K() < l) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).e()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }
}

