/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.rest.svg.mapping.Applications;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final DispatchQueueMetrics J;
    private final Map<String, AtomicInteger> h;
    private final QueryInterceptors H;
    private final FlowControlQueues<QueryInstruction> a;
    private final QueryRegistrationCache L;
    private final NonReplacingConstraintCache<String, ActiveQuery> j;
    private final Logger F;
    private final QueryMetricsRegistry e;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(String string, String string2, long l, QueryHandler queryHandler) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryHandler;
        QueryDispatcher a6 = queryDispatcher;
        a6.K((QueryHandler)a5, (String)a4, (String)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(SerializedQuery serializedQuery, String string, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        Set set;
        QueryDispatcher a2;
        QueryDispatcher queryDispatcher;
        block5: {
            void a3;
            SerializedQuery serializedQuery2;
            void a4;
            Consumer<QueryResponse> consumer3;
            void a5;
            block4: {
                DefaultExecutionContext a6;
                void a7;
                queryDispatcher = this;
                a6 = new DefaultExecutionContext((String)a7, (Authentication)a6);
                consumer3 = arg_0 -> queryDispatcher.K(a6, (Consumer)a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher2 = queryDispatcher;
                    serializedQuery2 = queryDispatcher2.H.queryRequest((SerializedQuery)a4, (ExecutionContext)a6);
                    a2 = serializedQuery2.query();
                    set = queryDispatcher2.K((String)a7, (QueryRequest)a2);
                    if (!set.isEmpty()) break block4;
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.K((String)("No handler for query: " + a2.getQuery()))).build());
                    a3.accept(Applications.K((Object)"\u0019_\u0014\\>U9D"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a7;
                    objectArray[1] = a4.query().getQuery();
                    objectArray[2] = exception;
                    queryDispatcher.F.warn(TaskPublisher.K((Object)"\u001d(\\u\u00004\u000f9\u00031F!\tu\u0002<\u0015%\u0007!\u0005=F$\u00130\u0014,F.\u001b"), objectArray);
                    a2 = ErrorCode.fromException((Throwable)exception);
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(a2.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.K((String)StringUtils.getOrDefault((String)a2.getCode(), (String)exception.getClass().getName()))).build());
                    a3.accept(Applications.K((Object)"\u0011Q>\\2T"));
                    a6.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(a2.getMessageIdentifier(), serializedQuery2, true, consumer3, (Consumer)a3, set, queryDispatcher.K((QueryRequest)a2));
            if (queryDispatcher.j.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.K((String)TaskPublisher.K((Object)"\u0004\u00130\u0014,F\"\u000f!\u000eu\u0015 \u0016%\n<\u00031F\u001c\"u\u00079\u00140\u00071\u001fu\u0016'\u0003&\u0003;\u0012"))).build());
            a3.accept(Applications.K((Object)"t\"@;Y4Q#U\u001eT"));
            return;
        }
        queryDispatcher.K(a2.getMessageIdentifier(), (ActiveQuery)set);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(ActiveQuery activeQuery, long l, QueryHandler queryHandler) {
        void a2;
        void a3;
        QueryDispatcher a4 = activeQuery;
        QueryDispatcher a5 = this;
        a5.K((QueryHandler)a3, a4.e(), a4.G(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void completeWithError(String string, String string2, ErrorCode errorCode, String string3) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        QueryDispatcher a6 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = a5;
        objectArray[2] = a3.getCode();
        objectArray[3] = a2;
        a6.F.debug(TaskPublisher.K((Object)"%:\u000b%\n0\u0012<\b2F\"\u000f!\u000eu\u0003'\u0014:\u0014u\u0012=\u0003u\u0005:\u000b8\u0013;\u000f6\u0007!\u000f:\bu\u0011<\u0012=F4F&\u00160\u0005<\u0000<\u0005u\u000e4\b1\n0\u0014u=6\n<\u0003;\u0012\u0006\u0012'\u00034\u000b\u001c\u0002h\u001d(;yF3\t'F!\u000e0F$\u00130\u0014,F\u000e\u000f1[.\u001b\bHu#'\u0014:\u0014u\u0005:\u00020\\u\u001d(Hu#'\u0014:\u0014\u0018\u0003&\u00154\u00010\\u\u001d(H"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.j.get(a5);
        if (activeQuery != null && activeQuery.K((String)a4, (ErrorCode)a3, (String)a2)) {
            a6.j.remove(a5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        void a3;
        Object a4 = consumer2;
        QueryDispatcher a5 = this;
        a5.dispatchProxied((SerializedQuery)a3, (Consumer)a2, (Consumer)a4, true);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(String string, String string2, Runnable runnable) {
        Runnable a22 = runnable;
        QueryDispatcher a3 = this;
        try {
            a22.run();
            return;
        }
        catch (MessagingPlatformException a22) {
            void a4;
            void a5;
            QueryDispatcher queryDispatcher = a3;
            queryDispatcher.F.debug(TaskPublisher.K((Object)"\u0010\u0014'\t'F1\u000f&\u00164\u00126\u000e<\b2F3\n:\u0011u\u0017 \u0003'\u001fu\u000f;\u0015!\u0014 \u0005!\u000f:\bu\u0012:F!\u0007'\u00010\u0012u\u00059\u000f0\b!F.\u001b"), (Object)a5);
            queryDispatcher.completeWithError((String)a4, (String)a5, a22.getErrorCode(), a22.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleResponse(QueryResponse queryResponse, String string, String string2) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = a3.getRequestIdentifier();
        if ((a4 = queryDispatcher.K((String)a2, (String)a4)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a4.K(), (String)a2);
            long l = System.currentTimeMillis() - a4.K();
            if (a4.K()) {
                void a5;
                queryDispatcher.e.addEndToEndResponseTime(a4.K(), a4.h(), (String)a5, clientStreamIdentification.e(), a4.e(), l);
            }
            if (a4.K((QueryResponse)a3, (String)a2) && a4.e()) {
                a4.K((String)a2);
                return;
            }
        } else {
            queryDispatcher.F.debug(TaskPublisher.K((Object)"\u001b\tuN8\t'\u0003|F<\b3\t'\u000b4\u0012<\t;F3\t'F.\u001b"), (Object)a3.getRequestIdentifier());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(DefaultExecutionContext defaultExecutionContext, Consumer consumer, QueryResponse queryResponse) {
        void a2;
        void a3;
        QueryDispatcher a4 = queryResponse;
        QueryDispatcher a5 = this;
        a5.K((DefaultExecutionContext)a3, (QueryResponse)a4, (Consumer)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(String string, String string2, String string3, Consumer<QueryHandler> consumer) {
        void a2;
        void a3;
        Object a4 = string;
        QueryDispatcher a5 = this;
        a4 = new QueryDefinition((String)a4, (String)a3);
        if ((a4 = a5.L.find((QueryDefinition)a4, (String)a2)) != null) {
            void a6;
            a6.accept(a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleComplete(String string, String string2, String string3) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher a4 = queryDispatcher.K((String)a3, (String)a2);
        if (a4 != null) {
            if (a4.e((String)a3)) {
                queryDispatcher.j.remove((Object)a4.e());
            }
            long l = System.currentTimeMillis() - a4.K();
            if (a4.K()) {
                void a5;
                queryDispatcher.e.addHandlerResponseTime(a4.K(), a4.h(), (String)a5, a4.K(), l);
                return;
            }
        } else {
            queryDispatcher.F.debug(Applications.K((Object)"~8\u0010\u007f]8B2\u0019wY9V8B:Q#Y8^wV8BwK*\u00108^wS8]'\\2D2T"), (Object)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void e(QueryHandler queryHandler, String string, String string2, long l) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryHandler a5 = queryHandler;
        a5.K((String)a3, (String)a4, (long)a2);
    }

    public void cancel(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.j.remove(a2)) != null) {
            a2.K();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void query(SerializedQuery serializedQuery, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        Consumer<String> a3;
        Consumer<QueryResponse> a4;
        void a5;
        QueryDispatcher queryDispatcher = this;
        Object a6 = a5.context();
        a4 = arg_0 -> queryDispatcher.K(a4, (SerializedQuery)a5, (String)a6, arg_0);
        a3 = arg_0 -> queryDispatcher.K(a3, (String)a6, arg_0);
        QueryDispatcher queryDispatcher2 = queryDispatcher;
        queryDispatcher2.queryRate((String)a6).e();
        queryDispatcher2.h.computeIfAbsent(a6, string -> {
            void a2;
            QueryDispatcher queryDispatcher = this;
            Object a3 = new AtomicInteger();
            queryDispatcher.e.gauge((MetricName)BaseMetricName.Z, Tags.of((String)"context", (String)a2), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        queryDispatcher.K((SerializedQuery)a5, (String)a6, (Authentication)a2, a4, a3);
    }

    /*
     * WARNING - void declaration
     */
    public void flowControl(String string, long l) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.j.get(a2)) != null) {
            void a4;
            a2.K().forEach(arg_0 -> a3.K((ActiveQuery)a2, (long)a4, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String K(String string, String string2) {
        void a2;
        Object a3 = string2;
        QueryDispatcher a4 = this;
        return (String)a2 + "/" + (String)a3;
    }

    /*
     * WARNING - void declaration
     */
    public void flowControlProxied(String string, String string2, long l, String string3, String string4) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string2;
        QueryDispatcher a7 = this;
        a7.K((String)a5, (String)a6, (String)a4, arg_0 -> a7.K((String)a3, (String)a6, (long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(DefaultExecutionContext defaultExecutionContext, QueryResponse queryResponse, Consumer<QueryResponse> consumer) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher queryDispatcher = this;
        try {
            a4.accept(queryDispatcher.H.queryResponse((QueryResponse)a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception a5) {
            queryDispatcher.F.warn(TaskPublisher.K((Object)"\u001d(\\u#-\u00050\u0016!\u000f:\bu\u000f;F'\u0003&\u0016:\b&\u0003u\u000f;\u00120\u00146\u0003%\u0012:\u0014"), (Object)a2.contextName(), (Object)a5);
            Exception exception = a5;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.K((String)exception.getMessage())).build());
            a2.compensate((Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(QueryHandler queryHandler, String string, String string2, long l) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5 = queryHandler;
        QueryDispatcher a6 = this;
        void v0 = a4;
        a6.K((String)v0, a5.K(), () -> QueryDispatcher.e((QueryHandler)a5, (String)v0, (String)a3, (long)a2));
    }

    private /* synthetic */ boolean K(QueryResponse queryResponse) {
        QueryDispatcher a2 = queryResponse;
        QueryDispatcher a3 = this;
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ActiveQuery K(String string, String string2) {
        Object a2 = string2;
        QueryDispatcher a3 = this;
        ActiveQuery activeQuery = (ActiveQuery)a3.j.get(a2);
        if (activeQuery == null) {
            void a4;
            a2 = (String)a2 + "/" + (String)a4;
            activeQuery = (ActiveQuery)a3.j.get(a2);
        }
        return activeQuery;
    }

    public void deleteMetrics(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        a3.h.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.e.remove((MetricName)BaseMetricName.Z, (String)a2);
        queryDispatcher.e.removeForContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void cancelProxied(String string, String string2) {
        void a2;
        QueryDispatcher a3;
        Object a4 = string2;
        QueryDispatcher queryDispatcher = a3 = this;
        queryDispatcher.cancel(queryDispatcher.K((String)a2, (String)a4));
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.a;
    }

    /*
     * WARNING - void declaration
     */
    public QueryDispatcher(QueryRegistrationCache queryRegistrationCache, NonReplacingConstraintCache<String, ActiveQuery> nonReplacingConstraintCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int n) {
        void a2;
        void clientIdRegistry2;
        void meterFactory2;
        void queryInterceptors2;
        void queryCache;
        void registrationCache;
        QueryDispatcher queryMetricsRegistry2;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryMetricsRegistry;
        QueryDispatcher queryDispatcher3 = queryMetricsRegistry2 = queryDispatcher;
        QueryDispatcher queryDispatcher4 = queryMetricsRegistry2;
        queryMetricsRegistry2.F = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher5 = queryMetricsRegistry2;
        queryMetricsRegistry2.h = new ConcurrentHashMap();
        queryDispatcher4.L = registrationCache;
        queryDispatcher4.e = queryDispatcher2;
        queryDispatcher3.j = queryCache;
        queryDispatcher3.H = queryInterceptors2;
        QueryDispatcher queryDispatcher6 = queryMetricsRegistry2;
        queryDispatcher3.J = new DispatchQueueMetrics((MeterFactory)meterFactory2, (MetricName)BaseMetricName.E, (MetricName)BaseMetricName.X, (ClientIdRegistry)clientIdRegistry2);
        QueryDispatcher queryDispatcher7 = queryMetricsRegistry2;
        queryDispatcher6.a = new FlowControlQueues(Comparator.comparing(QueryInstruction::K).reversed(), (int)a2, (QueueMetrics)queryMetricsRegistry2.J, ErrorCode.TOO_MANY_REQUESTS);
        queryDispatcher2.gauge((MetricName)BaseMetricName.B, (Object)queryCache, ConstraintCache::size);
    }

    public MeterFactory.RateMeter queryRate(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        return a3.e.rateMeter((String)a2);
    }

    private /* synthetic */ boolean K(QueryRequest queryRequest) {
        QueryDispatcher a2 = queryRequest;
        QueryDispatcher a3 = this;
        return ProcessingInstructionHelper.K((List)a2.getProcessingInstructionsList());
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2, boolean bl) {
        void a22;
        void a3;
        void a4;
        void a322;
        QueryDispatcher queryDispatcher = this;
        void v0 = a322;
        QueryRequest queryRequest = v0.query();
        String string = v0.context();
        Object a5 = v0.clientStreamId();
        if ((string = queryDispatcher.L.find(string, queryRequest, (String)a5)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a5;
            objectArray[1] = queryRequest.getQuery();
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.K((String)String.format(Applications.K((Object)"\u0014\\>U9Dw\u0015$\u00109_#\u00101_\"^3\u0010 X>\\2\u0010'B8S2C$Y9Wm\u0010rC"), objectArray))).build());
            a3.accept(a5);
            return;
        }
        a5 = queryDispatcher.K(queryRequest.getMessageIdentifier(), a322.clientStreamId());
        ActiveQuery a22 = new ActiveQuery((String)a5, (SerializedQuery)a322, false, (Consumer)a4, (Consumer)a3, Collections.singleton(string), a22 != false && queryDispatcher.K(queryRequest));
        try {
            if (queryDispatcher.j.putIfAbsent(a5, (Object)a22) != null) {
                a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a322.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.K((String)TaskPublisher.K((Object)"\u0004\u00130\u0014,F\"\u000f!\u000eu\u0015 \u0016%\n<\u00031F\u001c\"u\u00079\u00140\u00071\u001fu\u0016'\u0003&\u0003;\u0012"))).build());
                a3.accept(Applications.K((Object)"t\"@;Y4Q#U\u001eT"));
                return;
            }
            queryDispatcher.K((String)a5, a22);
            return;
        }
        catch (InsufficientBufferCapacityException a322) {
            a22.K(string.K(), ErrorCode.QUERY_DISPATCH_ERROR, a322.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(Consumer consumer, SerializedQuery serializedQuery, String string, QueryResponse queryResponse) {
        void a2;
        QueryDispatcher a3;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryResponse;
        QueryDispatcher a4 = queryDispatcher;
        QueryDispatcher queryDispatcher3 = a3;
        a2.accept(queryDispatcher3);
        if (a4.K((QueryResponse)queryDispatcher3)) {
            void a5;
            void a6;
            a4.e.error(a6.query().getQuery(), (String)a5, a3.getErrorCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(Consumer consumer, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryDispatcher a5 = this;
        a3.accept(a4);
        ((AtomicInteger)a5.h.get(a2)).decrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Set<QueryHandler> K(String string, QueryRequest queryRequest) {
        void a2;
        QueryHandler queryHandler;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = ProcessingInstructionHelper.K((List)a3.getProcessingInstructionsList()) == 1 ? ((queryHandler = queryDispatcher.L.findOne((String)a2, (QueryRequest)a3)) == null ? Set.of() : Set.of(queryHandler)) : queryDispatcher.L.find((String)a2, (QueryRequest)a3);
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(String string, ActiveQuery activeQuery) {
        void a2;
        QueryDispatcher queryDispatcher = this;
        try {
            queryDispatcher.F.trace(TaskPublisher.K((Object)"\"<\u0015%\u0007!\u0005=\u000f;\u0001u\u0017 \u0003'\u001fu\u001d(H{H"), (Object)a2.e());
            a2.e();
            return;
        }
        catch (MessagingPlatformException a3) {
            void a4;
            QueryDispatcher queryDispatcher2 = queryDispatcher;
            queryDispatcher2.F.debug(Applications.K((Object)"\u0012B%_%\u00103E%Y9WwT>C'Q#S?Y9Ww_1\u0010&E2B.\u0010,My\u0010\u0014Q9S2\\;Y9WwG>D?\u00102B%_%\u001e"), (Object)a2.e(), (Object)a3);
            a2.K(a3.getErrorCode(), a3.getMessage());
            queryDispatcher2.j.remove((Object)a4);
            return;
        }
    }
}

