/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ExceptionUtils;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ClusterTemplateController K;
    private final RaftConfigServiceFactory d;
    public static final String i = "_none";
    private final FeatureChecker J;
    private static final Logger h;
    private final DistributeLicenseService H;
    private static final Logger a;
    private final ClusterTopology L;
    private final ApplicationEventPublisher j;
    private final Predicate<String> F;
    private final ClusterController e;

    @GetMapping(path={"{name}"})
    public JsonClusterNode K(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        a.info(ExceptionUtils.K((Object)"W'q\u0001,\u000ei-y9\u007f(,2c8i|h9x=e0\u007f|j3~|w!\""), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.e.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.e.isActive((String)object));
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void K(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        a.info(ExceptionUtils.K((Object)"W'q\u0001,\u000ei-y9\u007f(,?`)\u007f(i.,(i1|0m(i|h3{2`3m8\""), (Object)AuditLog.username((Principal)object));
        if (a2.L.isAdminNode()) {
            ServletOutputStream resp;
            object = ApplicationProtoConverter.K((Object)"0q&n'x!0'x>m?|'x}d>q");
            String string = a2.K.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(ExceptionUtils.K((Object)"x9t(#,`=e27|o4m.\u007f9xay(jq4"));
            v1.addHeader(ApplicationProtoConverter.K((Object)"^<s'x=i~Y:n#r t't<s"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(ExceptionUtils.K((Object)"U3y|o=b|y/i|x4e/,:y2o(e3b=`5x%,3b0u|j.c1,=h1e2,2c8i"));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void K(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        a.info(ExceptionUtils.K((Object)"W'q\u0001,\u000ei-y9\u007f(,(c|h9`9x9,2c8i|w!\""), (Object)AuditLog.username((Principal)a2), object);
        name.d.getRaftConfigService().deleteNode((String)object);
    }

    @GetMapping
    public List<JsonClusterNode> K(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        a.info(ApplicationProtoConverter.K((Object)"F(`\u000e=\u0001x\"h6n'='rsq:n'==r7x 3"), (Object)AuditLog.username((Principal)object));
        return a2.e.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.e.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void K(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        a.info(ApplicationProtoConverter.K((Object)"\bf.@sO6l&x isq:~6s xsh#y2i63"), (Object)AuditLog.username((Principal)a2));
        h.info(ExceptionUtils.K((Object)"\u0012i+,0e?i2\u007f9,)|0c=h9hp,,i.j3~1e2k|`5o9b/i|y,h=x9\"r\""));
        try {
            void licenseFile;
            clusterRestController.H.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, ApplicationProtoConverter.K((Object)"S<=?x2y6os{<osB2y>t=3sX=n&o6='u2isi;xsB2y>t==!x#q:~2i:r==4o<h#=:ns~!x2i6ys\u007f6{<o6=&m?r2y:s4=2=?t0x=n63"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.F = new ContextNameValidation();
        a9.e = a8;
        clusterRestController5.d = a7;
        clusterRestController5.J = a6;
        clusterRestController4.H = a5;
        clusterRestController4.j = a4;
        clusterRestController3.L = a3;
        clusterRestController3.K = a2;
    }

    static {
        a = AuditLog.getLogger();
        h = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    @PostMapping
    public ResponseEntity<RestResponse> K(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        a.info(ApplicationProtoConverter.K((Object)"\bf.@sO6l&x isi<=9r:ss~?h i6os|'=(`if.3"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.e.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, ExceptionUtils.K((Object)"O=b2c(,?c1n5b9,6c5b5b;,?c2x9t(,+e(d|b3O3b(i$x/\""));
            }
            if (!RaftAdminGroup.K((String)string) && !jsonClusterNode.F.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            h.debug(ApplicationProtoConverter.K((Object)"2y75z'sO6z:n'x!t=zsp*n6q5=2s7=2y7t=zsp6='rs~<s'x+is?(`q3"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            h.debug(ExceptionUtils.K((Object)"m8ht%f,\u000ei;e/x9~5b;,1u/i0j|m2h|m8h5b;,1i|x3,2c|o3b(i$x/\""));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            h.debug(ApplicationProtoConverter.K((Object)"2y75z'sO6z:n'x!t=zsp*n6q5=2s7=2y7t=zsp6='rs|?qs~<s'x+i 3"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.e.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, ExceptionUtils.K((Object)"\u0012c8i|m0~9m8u|~9k5\u007f(i.i8,5b|m|o0y/x9~")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.d.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.j.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, ApplicationProtoConverter.K((Object)"\u0012~0x#i6ysw<t==!x\"h6n'1sp2dsi2v6=2=$u:q6='rsm!r0x n")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }
}

