/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.AxonServerEnterpriseConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.sks.RocksDBIndexKey;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    public static final String H = "Plugins disabled";
    private final boolean a;
    private final FeatureChecker L;
    private final Logger j;
    private static final Logger F = AuditLog.getLogger();
    private final PluginController e;

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> K(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.a || !pluginsRestController.L.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        F.info(AxonServerEnterpriseConfiguration.K((Object)">\b\u0018.E!\u0000\u0002\u0010\u0016\u0016\u0007E\u0015\n\u0001E\u0010\n\u001d\u0003\u001a\u0002\u0006\u0017\u0012\u0011\u001a\n\u001dE\u001c\u0003S\u001e\u000eJ\b\u0018]E"), objectArray);
        try {
            void context;
            return pluginsRestController.e.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.j.warn(RocksDBIndexKey.K((Object)"/N\u0000C\fKI[\u0006\u000f\u001bJ\u001d]\u0000J\u001fJI_\u001b@\u0019J\u001b[\u0000J\u001a\u000f\u000f@\u001b\u000f\u0012RST\u0014"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void K(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.a || !configurationJSON.L.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        F.info(RocksDBIndexKey.K((Object)"2T\u0014rI}\f^\u001cJ\u001a[I[\u0006\u000f\u001c_\rN\u001dJIL\u0006A\u000fF\u000eZ\u001bN\u001dF\u0006AI@\u000f\u000f\u0012RFT\u0014\u0001I"), objectArray);
        configurationJSON.e.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    @GetMapping
    public Iterable<PluginInfo> K(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        F.info(AxonServerEnterpriseConfiguration.K((Object)"(\u001e\u000e8S7\u0016\u0014\u0006\u0000\u0000\u0011S\u0011\u001cE\u001f\f\u0000\u0011S\u0006\u0006\u0017\u0001\u0000\u001d\u0011S\u0015\u001f\u0010\u0014\f\u001d\u0016]E"), (Object)AuditLog.username((Principal)object));
        return a2.e.listPlugins();
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void K(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        F.info(RocksDBIndexKey.K((Object)"t\u0012R4\u000f;J\u0018Z\f\\\u001d\u000f\u001d@IZ\u0007F\u0007\\\u001dN\u0005CI_\u0005Z\u000eF\u0007\u000f\u0012RFT\u0014\u0001I"), objectArray);
        version.e.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void K(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.a || !active.L.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? RocksDBIndexKey.K((Object)"\u001a[\b]\u001d") : AxonServerEnterpriseConfiguration.K((Object)"\u0000\u0011\u001c\u0015");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        F.info(AxonServerEnterpriseConfiguration.K((Object)">\b\u0018.E!\u0000\u0002\u0010\u0016\u0016\u0007E\u0007\nS\u001e\u000eE\u0003\t\u0006\u0002\u001a\u000bS\u001e\u000eJ\b\u0018]E"), objectArray);
        active.e.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.j = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.a = a3.isPluginsEnabled();
        pluginsRestController.e = a2;
        pluginsRestController.L = a5;
    }

    private /* synthetic */ String K(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, RocksDBIndexKey.K((Object)"a\u0006\u000f\u0019C\u001cH\u0000AI_\bL\u0002N\u000eJI_\u001b@\u001fF\rJ\r"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, AxonServerEnterpriseConfiguration.K((Object)"#\u001a\t\u0016\u000b\u0012\b\u0016E\u0000\r\u001c\u0010\u001f\u0001S\u000b\u001c\u0011S\u0006\u001c\u000b\u0007\u0004\u001a\u000bS\u0001\u001a\u0017\u0016\u0006\u0007\n\u0001\u001cS\u0016\u0016\u0015\u0012\u0017\u0012\u0011\u001c\u0017"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void K(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.a || !context.L.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        F.info(RocksDBIndexKey.K((Object)"2T\u0014rI}\f^\u001cJ\u001a[I[\u0006\u000f\u001cA\u001bJ\u000eF\u001a[\f]I_\u0005Z\u000eF\u0007\u000f\u0012RFT\u0014\u000f\u000f@\u001b\u000f\n@\u0007[\fW\u001d\u000f\u0012RG"), objectArray);
        context.e.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey K(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.a || !a2.L.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, H);
            }
            F.info(AxonServerEnterpriseConfiguration.K((Object)">\b\u0018.E!\u0000\u0002\u0010\u0016\u0016\u0007E\u0007\nS\f\u001d\u0016\u0007\u0004\u001f\tS\u0015\u001f\u0010\u0014\f\u001dE\b\u0018]E"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.K(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.e.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }
}

