/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.taskscheduler;

import io.axoniq.axonserver.configuration.runtime.Task;
import io.axoniq.axonserver.configuration.runtime.Tasks;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.TaskStatus;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.taskscheduler.ScheduledTaskExecutor;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseTaskManager
implements SmartLifecycle {
    protected final AtomicLong b;
    private final MeterFactory g;
    private static final String G = "false";
    protected final PlatformTransactionManager B;
    protected final Map<String, Map<String, ScheduledFuture<?>>> C;
    private final Map<String, Gauge> E;
    protected final ScheduledExecutorService c;
    protected final Tasks l;
    private static final String K = "replicationGroup";
    protected static final Logger d;
    protected final Supplier<Set<String>> i;
    protected static final long J;
    private static final String h = "transient";
    protected final ScheduledTaskExecutor H;
    private final long a;
    private boolean L;
    protected final Clock j;
    private static final String F = "true";
    protected final Predicate<String> e;

    protected abstract CompletableFuture<Void> processResult(String var1, String var2, TaskStatus var3, long var4, long var6, String var8);

    static {
        J = TimeUnit.MINUTES.toMillis(1L);
        d = LoggerFactory.getLogger(BaseTaskManager.class);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void h(Task task, Throwable throwable) {
        void a2;
        Object a3 = throwable;
        BaseTaskManager a4 = this;
        a4.error((Task)a2, (Throwable)a3);
        return null;
    }

    private /* synthetic */ void e() {
        BaseTaskManager a2;
        d.debug(RaftConfigServiceFactory.K((Object)"Z\bz\u00123\u0000v\u0012p\u000eG\u0007`\rA\u0013}\bv\u0014?Fd\u000f}\u0002|\u00113[3\u001dn"), (Object)a2.a);
        a2.c.scheduleWithFixedDelay(() -> {
            BaseTaskManager a2;
            if (!a2.L) {
                return;
            }
            try {
                BaseTaskManager baseTaskManager = a2;
                long l = baseTaskManager.b.getAndSet(baseTaskManager.j.millis() + a2.a);
                ((Set)baseTaskManager.i.get()).forEach(string -> {
                    void a2;
                    void a3;
                    BaseTaskManager baseTaskManager = this;
                    List a4 = baseTaskManager.l.findScheduled((String)a3, (long)a2, baseTaskManager.b.get());
                    Object[] objectArray = new Object[4];
                    objectArray[0] = a3;
                    objectArray[1] = a4.size();
                    objectArray[2] = (long)a2;
                    objectArray[3] = baseTaskManager.b.get();
                    d.debug(RaftConfigServiceFactory.K((Object)"h\u001b)F`\u0005{\u0003w\u0013\u007f\u000f}\u00013\u001dnFg\u0007`\r`Fq\u0003g\u0011v\u0003}Fh\u001b3\u0007}\u00023\u001dn"), objectArray);
                    a4.forEach(arg_0 -> baseTaskManager.schedule(arg_0));
                });
                return;
            }
            catch (Exception exception) {
                d.warn(SerializedEvent.K((Object)"N\u0003h\u001e{\u000fb\u0014e[m\u001e\u007f\u0018c\u0012e\u001c+\bh\u0013n\u001f~\u0017n\u001f+\u000fj\b`\b'[|\u0012g\u0017+\u000fy\u0002+\u001al\u001ab\u0015+\u0017j\u000fn\t"), (Throwable)exception);
                return;
            }
        }, 0L, a2.a, TimeUnit.MILLISECONDS);
    }

    protected void doScheduleTask(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        if (a3.e.test(a2.getReplicationGroup()) && a2.getTimestamp() < a3.b.get() && TaskStatus.SCHEDULED.equals((Object)a2.getStatus())) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getReplicationGroup();
            objectArray[1] = a2.getTimestamp();
            objectArray[2] = a3.b;
            d.debug(RaftConfigServiceFactory.K((Object)"\u001dn\\3\u0007w\u0002z\btFg\u0007`\r3\u0012|F`\u0005{\u0003w\u0013\u007f\u0003aFg\u000f~\u00033\u001dnFq\u0003u\ta\u00033\u001dn"), objectArray);
            a3.schedule((Task)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void K(Task task, long l, Void void_) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.completed((Task)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected void error(Task task, Throwable throwable) {
        CompletableFuture completableFuture;
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        if (a4.isTransient((Throwable)a2)) {
            BaseTaskManager baseTaskManager;
            BaseTaskManager baseTaskManager2 = a3;
            long l = Math.min(baseTaskManager2.getRetryInterval() * 2L, J);
            if (baseTaskManager2.getRetryInterval() < J) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getPayload().getType();
                objectArray[2] = l;
                d.info(SerializedEvent.K((Object)"p\u00061[M\u001ab\u0017n\u001f+\u000fd[n\u0003n\u0018~\u000fn[\u007f\u001ax\u0010+\\p\u0006,U+[Y\u001e\u007f\tr\u0012e\u001c+\u0012e[p\u0006+\u0016xU%U"), objectArray);
                baseTaskManager = a4;
            } else {
                Object[] objectArray = new Object[5];
                objectArray[0] = a3.getReplicationGroup();
                objectArray[1] = a3.getTaskId();
                objectArray[2] = a3.getTaskExecutor();
                objectArray[3] = a2.getMessage();
                objectArray[4] = l;
                d.warn(RaftConfigServiceFactory.K((Object)"\u001dn\\3 r\u000f\u007f\u0003wFg\t3\u0003k\u0003p\u0013g\u00033\u0012r\u0015xFh\u001b)Fh\u001b3K3\u001dnH34v\u0012a\u001fz\btFz\b3\u001dnF~\u0015=H="), objectArray);
                baseTaskManager = a4;
            }
            CompletableFuture completableFuture2 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.SCHEDULED, a4.newSchedule((Task)a3), l, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = K;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = h;
            stringArray[5] = F;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            a4.g.counter((MetricName)BaseMetricName.Aa, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture2;
        } else {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2;
            d.warn(SerializedEvent.K((Object)"\u0000vA+=j\u0012g\u001eo[\u007f\u0014+\u001es\u001eh\u000e\u007f\u001e+\u000fj\b`[p\u00061[p\u0006"), objectArray);
            BaseTaskManager baseTaskManager = a4;
            CompletableFuture completableFuture3 = baseTaskManager.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.FAILED, a4.j.millis(), 0L, a4.asString((Throwable)a2));
            String[] stringArray = new String[8];
            stringArray[0] = K;
            stringArray[1] = a3.getReplicationGroup();
            stringArray[2] = "request";
            stringArray[3] = a3.getTaskExecutor();
            stringArray[4] = h;
            stringArray[5] = G;
            stringArray[6] = "error";
            stringArray[7] = ErrorCode.fromException((Throwable)a2).getCode();
            baseTaskManager.g.counter((MetricName)BaseMetricName.Aa, Tags.of((String[])stringArray)).increment();
            completableFuture = completableFuture3;
        }
        completableFuture.exceptionally(arg_0 -> BaseTaskManager.K((Task)a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    protected void completed(Task task, long l) {
        void a2;
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.processResult(a3.getReplicationGroup(), a3.getTaskId(), TaskStatus.COMPLETED, a4.j.millis(), 0L, null).exceptionally(arg_0 -> BaseTaskManager.e((Task)a3, arg_0));
        String[] stringArray = new String[4];
        stringArray[0] = K;
        stringArray[1] = a3.getReplicationGroup();
        stringArray[2] = "request";
        stringArray[3] = a3.getTaskExecutor();
        a4.g.timer((MetricName)BaseMetricName.La, Tags.of((String[])stringArray)).record(a4.j.millis() - a2, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public BaseTaskManager(ScheduledTaskExecutor scheduledTaskExecutor, Tasks tasks, Supplier<Set<String>> supplier, Predicate<String> predicate, PlatformTransactionManager platformTransactionManager, @Qualifier(value="taskScheduler") ScheduledExecutorService scheduledExecutorService, MeterFactory meterFactory, Clock clock) {
        void meterFactory2;
        void scheduler;
        void platformTransactionManager2;
        void raftLeaderTest;
        void leaderForGroupProvider;
        void taskRepository;
        void taskExecutor;
        BaseTaskManager a2;
        BaseTaskManager baseTaskManager = object;
        Object object = clock;
        BaseTaskManager baseTaskManager2 = a2 = baseTaskManager;
        BaseTaskManager baseTaskManager3 = a2;
        BaseTaskManager baseTaskManager4 = a2;
        BaseTaskManager baseTaskManager5 = a2;
        BaseTaskManager baseTaskManager6 = a2;
        BaseTaskManager baseTaskManager7 = a2;
        a2.C = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager8 = a2;
        baseTaskManager7.E = new ConcurrentHashMap();
        BaseTaskManager baseTaskManager9 = a2;
        baseTaskManager6.b = new AtomicLong();
        baseTaskManager6.a = Duration.ofMinutes(5L).toMillis();
        baseTaskManager5.H = taskExecutor;
        baseTaskManager5.l = taskRepository;
        baseTaskManager4.i = leaderForGroupProvider;
        baseTaskManager4.e = raftLeaderTest;
        baseTaskManager3.B = platformTransactionManager2;
        baseTaskManager3.c = scheduler;
        baseTaskManager2.g = meterFactory2;
        baseTaskManager2.j = object;
    }

    private /* synthetic */ ScheduledFuture K(Task task, String string) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.c.schedule(() -> a3.e((Task)a2), a3.K((Task)a2), TimeUnit.MILLISECONDS);
    }

    protected void saveAndSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.E.computeIfAbsent(a2.getReplicationGroup(), string -> {
            Object a2 = string;
            BaseTaskManager a3 = this;
            return a3.g.gauge((MetricName)BaseMetricName.k, Tags.of((String)K, (String)a2), () -> a3.K((String)a2));
        });
        new TransactionTemplate(a3.B).execute(arg_0 -> a3.K((Task)a2, arg_0));
        d.debug(SerializedEvent.K((Object)"\u0000vA+/j\b`[x\u0018c\u001eo\u000eg\u001eo[p\u0006"), (Object)a2.getReplicationGroup(), (Object)a2.getTaskId());
        a3.doScheduleTask((Task)a2);
    }

    public void start() {
        BaseTaskManager a2;
        a2.L = true;
        a2.e();
    }

    public void stop() {
        BaseTaskManager a2;
        a2.L = false;
        d.info(SerializedEvent.K((Object)"X\u000fd\u000b+/j\b`6j\u0015j\u001cn\t"));
        a2.c.shutdown();
    }

    private /* synthetic */ void e(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        a3.K((Task)a2);
    }

    /*
     * WARNING - void declaration
     */
    protected void unschedule(String string, String string2) {
        void a2;
        Object a3 = string;
        BaseTaskManager a4 = this;
        if ((a3 = (ScheduledFuture)a4.C.getOrDefault(a3, Collections.emptyMap()).remove(a2)) != null) {
            a3.cancel(false);
        }
    }

    private /* synthetic */ Number e(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.l.countByContext((String)a2);
    }

    private static /* synthetic */ Void e(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        d.warn(RaftConfigServiceFactory.K((Object)"\u001dn\\3 r\u000f\u007f\u0003wFg\t3\u0016a\tp\u0003`\u00153\u0014v\u0015f\ngFu\taFp\t~\u0016\u007f\u0003g\u0003wFg\u0007`\r3\u001dn\\3\u001dn"), objectArray);
        return null;
    }

    protected boolean isTransient(Throwable throwable) {
        Throwable a2 = throwable;
        BaseTaskManager a3 = this;
        if (a2 == null) {
            return false;
        }
        if (a2 instanceof TransientException) {
            return true;
        }
        return a3.isTransient(a2.getCause());
    }

    protected void schedule(Task task) {
        BaseTaskManager a3 = task;
        BaseTaskManager a4 = this;
        a4.C.computeIfAbsent(a3.getReplicationGroup(), a2 -> new ConcurrentHashMap()).computeIfAbsent(a3.getTaskId(), arg_0 -> a4.K((Task)a3, arg_0));
    }

    protected String asString(Throwable throwable) {
        Object a2 = throwable;
        BaseTaskManager a3 = this;
        return MessagingPlatformException.create((Throwable)a2).getMessage();
    }

    private /* synthetic */ Number K(String string) {
        Object a2 = string;
        BaseTaskManager a3 = this;
        return a3.e((String)a2);
    }

    private /* synthetic */ long K(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a2.getTimestamp() - a3.j.millis();
    }

    private /* synthetic */ void K(Task task) {
        BaseTaskManager a2;
        BaseTaskManager a3 = task;
        BaseTaskManager baseTaskManager = a2 = this;
        long l = baseTaskManager.j.millis();
        baseTaskManager.C.getOrDefault(a3.getReplicationGroup(), Collections.emptyMap()).remove(a3.getTaskId());
        if (d.isDebugEnabled()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.getReplicationGroup();
            objectArray[1] = a3.getTaskId();
            objectArray[2] = a3.getTaskExecutor();
            objectArray[3] = a2.j.millis() - a3.getTimestamp();
            d.debug(RaftConfigServiceFactory.K((Object)"\u001dn\\3#k\u0003p\u0013g\u00033\u0012r\u0015xFh\u001b)Fh\u001b3\u0016\u007f\u0007}\bv\u00023\u0003k\u0003p\u0013g\u000f|\b3\u001dn\u000b`Fr\u0001|"), objectArray);
        }
        try {
            ((CompletableFuture)a2.H.executeTask((Task)a3).thenAccept(arg_0 -> a2.K((Task)a3, l, arg_0))).exceptionally(arg_0 -> a2.h((Task)a3, arg_0));
            return;
        }
        catch (Exception exception) {
            a2.error((Task)a3, (Throwable)exception);
            return;
        }
    }

    protected long newSchedule(Task task) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.j.millis() + Math.min(a2.getRetryInterval(), J);
    }

    private /* synthetic */ Task K(Task task, TransactionStatus transactionStatus) {
        BaseTaskManager a2 = task;
        BaseTaskManager a3 = this;
        return a3.l.save((Task)a2);
    }

    private static /* synthetic */ Void K(Task task, Throwable throwable) {
        Object a2 = throwable;
        Task a3 = task;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3.getReplicationGroup();
        objectArray[1] = a3.getTaskId();
        objectArray[2] = a3.getTaskExecutor();
        objectArray[3] = a2;
        d.warn(SerializedEvent.K((Object)"p\u00061[M\u001ab\u0017n\u001f+\u000fd[{\td\u0018n\bx[y\u001ex\u000eg\u000f+\u001dd\t+\u000fj\b`[p\u00061[p\u0006"), objectArray);
        return null;
    }

    public boolean isRunning() {
        BaseTaskManager a2;
        return a2.L;
    }
}

